function GetOciTopLevelCommand_wlms() {
    return 'wlms'
}

function GetOciSubcommands_wlms() {
    $ociSubcommands = @{
        'wlms' = 'agreement configuration managed-instance required-policy-collection resource-inventory wls-domain work-request'
        'wlms agreement' = 'get'
        'wlms configuration' = 'get update'
        'wlms managed-instance' = 'get get-server list list-scan-results list-server-installed-patches list-servers scan update'
        'wlms required-policy-collection' = 'list-required-policies'
        'wlms resource-inventory' = 'summarize'
        'wlms wls-domain' = 'change-compartment create-agreement-record delete get get-credential get-server get-server-backup get-server-backup-content install-latest-patches list list-agreement-records list-applicable-patches list-credentials list-scan-results list-server-backups list-server-installed-patches list-servers restart restore scan set-restart-order start stop update update-credential'
        'wlms work-request' = 'get list list-work-request-errors list-work-request-logs'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_wlms() {
    $ociCommandsToLongParams = @{
        'wlms agreement get' = 'from-json help'
        'wlms configuration get' = 'compartment-id from-json help'
        'wlms configuration update' = 'compartment-id discovery-interval domain-search-paths force from-json help if-match'
        'wlms managed-instance get' = 'from-json help managed-instance-id'
        'wlms managed-instance get-server' = 'from-json help managed-instance-id server-id'
        'wlms managed-instance list' = 'all compartment-id display-name from-json help id limit page page-size plugin-status sort-by sort-order'
        'wlms managed-instance list-scan-results' = 'all from-json help limit managed-instance-id page page-size server-name sort-by sort-order wls-domain-id'
        'wlms managed-instance list-server-installed-patches' = 'all from-json help limit managed-instance-id page page-size server-id sort-by sort-order'
        'wlms managed-instance list-servers' = 'all from-json help limit managed-instance-id name page page-size sort-by sort-order'
        'wlms managed-instance scan' = 'from-json help if-match managed-instance-id max-wait-seconds wait-for-state wait-interval-seconds'
        'wlms managed-instance update' = 'configuration force from-json help if-match managed-instance-id'
        'wlms required-policy-collection list-required-policies' = 'all from-json help'
        'wlms resource-inventory summarize' = 'compartment-id from-json help'
        'wlms wls-domain change-compartment' = 'compartment-id from-json help if-match wls-domain-id'
        'wlms wls-domain create-agreement-record' = 'agreement-signature agreement-uuid from-json help if-match wls-domain-id'
        'wlms wls-domain delete' = 'force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds wls-domain-id'
        'wlms wls-domain get' = 'from-json help wls-domain-id'
        'wlms wls-domain get-credential' = 'credential-type from-json help wls-domain-id'
        'wlms wls-domain get-server' = 'from-json help server-id wls-domain-id'
        'wlms wls-domain get-server-backup' = 'backup-id from-json help server-id wls-domain-id'
        'wlms wls-domain get-server-backup-content' = 'backup-id from-json help server-id wls-domain-id'
        'wlms wls-domain install-latest-patches' = 'from-json help if-match is-force-servers-shutdown max-wait-seconds must-include-domains-sharing-middleware wait-for-state wait-interval-seconds wls-domain-id'
        'wlms wls-domain list' = 'all compartment-id display-name from-json help id lifecycle-state limit middleware-type page page-size patch-readiness-status sort-by sort-order weblogic-version'
        'wlms wls-domain list-agreement-records' = 'all from-json help limit page page-size sort-by sort-order wls-domain-id'
        'wlms wls-domain list-applicable-patches' = 'all from-json help limit page page-size sort-by sort-order wls-domain-id'
        'wlms wls-domain list-credentials' = 'all from-json help wls-domain-id'
        'wlms wls-domain list-scan-results' = 'all from-json help limit page page-size server-name sort-by sort-order wls-domain-id'
        'wlms wls-domain list-server-backups' = 'all from-json help limit page page-size server-id sort-by sort-order wls-domain-id'
        'wlms wls-domain list-server-installed-patches' = 'all from-json help limit page page-size server-id sort-by sort-order wls-domain-id'
        'wlms wls-domain list-servers' = 'all from-json help limit name page page-size sort-by sort-order wls-domain-id'
        'wlms wls-domain restart' = 'from-json help if-match is-force-servers-shutdown max-wait-seconds wait-for-state wait-interval-seconds wls-domain-id'
        'wlms wls-domain restore' = 'from-json help if-match is-force-servers-shutdown max-wait-seconds must-include-domains-sharing-middleware servers-to-restore wait-for-state wait-interval-seconds wls-domain-id'
        'wlms wls-domain scan' = 'from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds wls-domain-id'
        'wlms wls-domain set-restart-order' = 'from-json help if-match servers wls-domain-id'
        'wlms wls-domain start' = 'from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds wls-domain-id'
        'wlms wls-domain stop' = 'from-json help if-match is-force-servers-shutdown max-wait-seconds wait-for-state wait-interval-seconds wls-domain-id'
        'wlms wls-domain update' = 'configuration defined-tags force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds wls-domain-id'
        'wlms wls-domain update-credential' = 'credential-type from-json help if-match password-secret-id strategy user-secret-id wls-domain-id'
        'wlms work-request get' = 'from-json help work-request-id'
        'wlms work-request list' = 'all compartment-id from-json help limit page page-size resource-id sort-by sort-order status work-request-id'
        'wlms work-request list-work-request-errors' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
        'wlms work-request list-work-request-logs' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_wlms() {
    $ociCommandsToShortParams = @{
        'wlms agreement get' = '? h'
        'wlms configuration get' = '? c h'
        'wlms configuration update' = '? c h'
        'wlms managed-instance get' = '? h'
        'wlms managed-instance get-server' = '? h'
        'wlms managed-instance list' = '? c h'
        'wlms managed-instance list-scan-results' = '? h'
        'wlms managed-instance list-server-installed-patches' = '? h'
        'wlms managed-instance list-servers' = '? h'
        'wlms managed-instance scan' = '? h'
        'wlms managed-instance update' = '? h'
        'wlms required-policy-collection list-required-policies' = '? h'
        'wlms resource-inventory summarize' = '? c h'
        'wlms wls-domain change-compartment' = '? c h'
        'wlms wls-domain create-agreement-record' = '? h'
        'wlms wls-domain delete' = '? h'
        'wlms wls-domain get' = '? h'
        'wlms wls-domain get-credential' = '? h'
        'wlms wls-domain get-server' = '? h'
        'wlms wls-domain get-server-backup' = '? h'
        'wlms wls-domain get-server-backup-content' = '? h'
        'wlms wls-domain install-latest-patches' = '? h'
        'wlms wls-domain list' = '? c h'
        'wlms wls-domain list-agreement-records' = '? h'
        'wlms wls-domain list-applicable-patches' = '? h'
        'wlms wls-domain list-credentials' = '? h'
        'wlms wls-domain list-scan-results' = '? h'
        'wlms wls-domain list-server-backups' = '? h'
        'wlms wls-domain list-server-installed-patches' = '? h'
        'wlms wls-domain list-servers' = '? h'
        'wlms wls-domain restart' = '? h'
        'wlms wls-domain restore' = '? h'
        'wlms wls-domain scan' = '? h'
        'wlms wls-domain set-restart-order' = '? h'
        'wlms wls-domain start' = '? h'
        'wlms wls-domain stop' = '? h'
        'wlms wls-domain update' = '? h'
        'wlms wls-domain update-credential' = '? h'
        'wlms work-request get' = '? h'
        'wlms work-request list' = '? c h'
        'wlms work-request list-work-request-errors' = '? h'
        'wlms work-request list-work-request-logs' = '? h'
    }
    return $ociCommandsToShortParams
}