from enum import StrEnum


class ErrorCode(StrEnum):
    INTERNAL_SERVER_ERROR = "A001"
    LOGIN_ERROR = "A002"
    UNAUTHORIZED = "A003"
    FORBIDDEN_ROLE_ERROR = "A004"
    CREATE_API_TOKEN_ERROR = "A005"
    DELETE_API_TOKEN_ERROR = "A006"
    REQUESTED_TOKEN_NOT_FOUND = "A007"
    FIND_ALL_API_TOKENS_ERROR = "A008"
    GET_PUBLIC_KEY_ERROR = "A009"
    ENABLE_NODE_ERROR = "A010"
    NODE_NOT_FOUND = "A011"
    CONFIG_NOT_FOUND = "A012"
    UPDATE_CONFIG_ERROR = "A013"
    GET_CONFIG_ERROR = "A014"
    DELETE_MANY_INBOUNDS_ERROR = "A015"
    CREATE_MANY_INBOUNDS_ERROR = "A016"
    FIND_ALL_INBOUNDS_ERROR = "A017"
    CREATE_USER_ERROR = "A018"
    USER_USERNAME_ALREADY_EXISTS = "A019"
    USER_SHORT_UUID_ALREADY_EXISTS = "A020"
    USER_SUBSCRIPTION_UUID_ALREADY_EXISTS = "A021"
    CREATE_USER_WITH_INBOUNDS_ERROR = "A022"
    CANT_GET_CREATED_USER_WITH_INBOUNDS = "A023"
    GET_ALL_USERS_ERROR = "A024"
    USER_NOT_FOUND = "A025"
    GET_USER_BY_ERROR = "A026"
    REVOKE_USER_SUBSCRIPTION_ERROR = "A027"
    DISABLE_USER_ERROR = "A028"
    USER_ALREADY_DISABLED = "A029"
    USER_ALREADY_ENABLED = "A030"
    ENABLE_USER_ERROR = "A031"
    CREATE_NODE_ERROR = "A032"
    NODE_NAME_ALREADY_EXISTS = "A033"
    NODE_ADDRESS_ALREADY_EXISTS = "A034"
    NODE_ERROR_WITH_MSG = "N001"
    NODE_ERROR_500_WITH_MSG = "N002"
    RESTART_NODE_ERROR = "A035"
    GET_CONFIG_WITH_USERS_ERROR = "A036"
    DELETE_USER_ERROR = "A037"
    UPDATE_NODE_ERROR = "A038"
    UPDATE_USER_ERROR = "A039"
    INCREMENT_USED_TRAFFIC_ERROR = "A040"
    GET_ALL_NODES_ERROR = "A041"
    GET_ONE_NODE_ERROR = "A042"
    DELETE_NODE_ERROR = "A043"
    CREATE_HOST_ERROR = "A044"
    HOST_REMARK_ALREADY_EXISTS = "A045"
    HOST_NOT_FOUND = "A046"
    DELETE_HOST_ERROR = "A047"
    GET_USER_STATS_ERROR = "A048"
    UPDATE_USER_WITH_INBOUNDS_ERROR = "A049"
    GET_ALL_HOSTS_ERROR = "A050"
    REORDER_HOSTS_ERROR = "A051"
    UPDATE_HOST_ERROR = "A052"
    CREATE_CONFIG_ERROR = "A053"
    ENABLED_NODES_NOT_FOUND = "A054"
    GET_NODES_USAGE_BY_RANGE_ERROR = "A055"
    RESET_USER_TRAFFIC_ERROR = "A056"
    REORDER_NODES_ERROR = "A057"
    GET_ALL_INBOUNDS_ERROR = "A058"
    BULK_DELETE_USERS_BY_STATUS_ERROR = "A059"
    UPDATE_INBOUND_ERROR = "A060"
    CONFIG_VALIDATION_ERROR = "A061"
    USERS_NOT_FOUND = "A062"
    GET_USER_BY_UNIQUE_FIELDS_NOT_FOUND = "A063"
    UPDATE_EXCEEDED_TRAFFIC_USERS_ERROR = "A064"
    ADMIN_NOT_FOUND = "A065"
    CREATE_ADMIN_ERROR = "A066"
    GET_AUTH_STATUS_ERROR = "A067"
    FORBIDDEN_ONE = "A068"
    FORBIDDEN_TWO = "E000"
    DISABLE_NODE_ERROR = "A069"
    GET_ONE_HOST_ERROR = "A070"
    SUBSCRIPTION_SETTINGS_NOT_FOUND = "A071"
    GET_SUBSCRIPTION_SETTINGS_ERROR = "A072"
    UPDATE_SUBSCRIPTION_SETTINGS_ERROR = "A073"
