"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmazonMachineImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * @stability stable
 */
class AmazonMachineImage {
    /**
     * @stability stable
     */
    constructor() { }
    /**
     * @stability stable
     */
    static fromSsmParameter(path) {
        return aws_cdk_lib_1.aws_ec2.MachineImage.fromSsmParameter(path);
    }
}
exports.AmazonMachineImage = AmazonMachineImage;
_a = JSII_RTTI_SYMBOL_1;
AmazonMachineImage[_a] = { fqn: "cdk-spot-one.AmazonMachineImage", version: "2.0.12" };
/**
 * @stability stable
 */
AmazonMachineImage.AMAZON_LINUX = aws_cdk_lib_1.aws_ec2.MachineImage.latestAmazonLinux();
/**
 * @stability stable
 */
AmazonMachineImage.AMAZON_LINUX_2 = aws_cdk_lib_1.aws_ec2.MachineImage.latestAmazonLinux({ generation: aws_cdk_lib_1.aws_ec2.AmazonLinuxGeneration.AMAZON_LINUX_2 });
/**
 * CentOS product code from https://wiki.centos.org/Cloud/AWS.
 *
 * @stability stable
 */
AmazonMachineImage.CENTOS_7 = aws_cdk_lib_1.aws_ec2.MachineImage.lookup({
    filters: {
        ['product-code']: ['cvugziknvmxgqna9noibqnnsy'],
    },
    name: '*CentOS*',
    owners: ['aws-marketplace'],
});
/**
 * @stability stable
 */
AmazonMachineImage.CENTOS_8 = aws_cdk_lib_1.aws_ec2.MachineImage.lookup({
    filters: {
        ['product-code']: ['47k9ia2igxpcce2bzo8u3kj03'],
    },
    name: '*CentOS*',
    owners: ['aws-marketplace'],
});
/**
 * @stability stable
 */
AmazonMachineImage.UBUNTU_16_04_AMD64 = AmazonMachineImage.fromSsmParameter('/aws/service/canonical/ubuntu/server/16.04/stable/current/amd64/hvm/ebs-gp2/ami-id');
/**
 * @stability stable
 */
AmazonMachineImage.UBUNTU_16_04_ARM64 = AmazonMachineImage.fromSsmParameter('/aws/service/canonical/ubuntu/server/16.04/stable/current/arm64/hvm/ebs-gp2/ami-id');
/**
 * @stability stable
 */
AmazonMachineImage.UBUNTU_18_04_AMD64 = AmazonMachineImage.fromSsmParameter('/aws/service/canonical/ubuntu/server/18.04/stable/current/amd64/hvm/ebs-gp2/ami-id');
/**
 * @stability stable
 */
AmazonMachineImage.UBUNTU_18_04_ARM64 = AmazonMachineImage.fromSsmParameter('/aws/service/canonical/ubuntu/server/18.04/stable/current/arm64/hvm/ebs-gp2/ami-id');
/**
 * @stability stable
 */
AmazonMachineImage.UBUNTU_20_04_AMD64 = AmazonMachineImage.fromSsmParameter('/aws/service/canonical/ubuntu/server/20.04/stable/current/amd64/hvm/ebs-gp2/ami-id');
/**
 * @stability stable
 */
AmazonMachineImage.UBUNTU_20_04_ARM64 = AmazonMachineImage.fromSsmParameter('/aws/service/canonical/ubuntu/server/20.04/stable/current/arm64/hvm/ebs-gp2/ami-id');
/**
 * @stability stable
 */
AmazonMachineImage.UBUNTU_20_10_AMD64 = AmazonMachineImage.fromSsmParameter('/aws/service/canonical/ubuntu/server/20.10/stable/current/amd64/hvm/ebs-gp2/ami-id');
/**
 * @stability stable
 */
AmazonMachineImage.UBUNTU_20_10_ARM64 = AmazonMachineImage.fromSsmParameter('/aws/service/canonical/ubuntu/server/20.10/stable/current/arm64/hvm/ebs-gp2/ami-id');
//# sourceMappingURL=data:application/json;base64,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