"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cdk = require("aws-cdk-lib");
const ami_helper_1 = require("./ami-helper");
const spot_1 = require("./spot");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stackName = app.node.tryGetContext('stackName') || 'SpotOneStack';
        const stack = new cdk.Stack(app, stackName, { env });
        const keyName = stack.node.tryGetContext('ssh_key_name');
        const vpc = spot_1.VpcProvider.getOrCreate(stack);
        const spot = new spot_1.SpotInstance(stack, 'SpotInstanceUbuntu', {
            vpc,
            customAmiId: ami_helper_1.AmazonMachineImage.CENTOS_8.getImage(stack).imageId,
            keyName,
            blockDeviceMappings: [{ deviceName: '/dev/sda1', ebs: { volumeSize: 20 } }],
            additionalUserData: ['curl -fsSL https://get.docker.com -o get-docker.sh', 'sudo sh get-docker.sh'],
        });
        new cdk.CfnOutput(stack, 'InstnaceId', { value: spot.instanceId });
        new cdk.CfnOutput(stack, 'AmiIdOutput', { value: ami_helper_1.AmazonMachineImage.CENTOS_8.getImage(stack).imageId });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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