"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const spot_1 = require("./spot");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stackName = app.node.tryGetContext('stackName') || 'SpotOneStack';
        const stack = new cdk.Stack(app, stackName, { env });
        const instanceType = stack.node.tryGetContext('instance_type') || 't3.large';
        const eipAllocationId = stack.node.tryGetContext('eip_allocation_id');
        const volumeSize = stack.node.tryGetContext('volume_size') || 60;
        const keyName = stack.node.tryGetContext('ssh_key_name');
        const vpc = spot_1.VpcProvider.getOrCreate(stack);
        const spot = new spot_1.SpotInstance(stack, 'SpotInstance', {
            vpc,
            // instanceInterruptionBehavior: InstanceInterruptionBehavior.STOP,
            eipAllocationId: eipAllocationId,
            assignEip: false,
            defaultInstanceType: new aws_cdk_lib_1.aws_ec2.InstanceType(instanceType),
            keyName,
            ebsVolumeSize: volumeSize,
        });
        new cdk.CfnOutput(stack, 'InstnaceId', { value: spot.instanceId });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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