"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const ami_helper_1 = require("./ami-helper");
const spot_1 = require("./spot");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stackName = app.node.tryGetContext('stackName') || 'SpotOneStack';
        const stack = new cdk.Stack(app, stackName, { env });
        const keyName = stack.node.tryGetContext('ssh_key_name');
        const vpc = spot_1.VpcProvider.getOrCreate(stack);
        const spot = new spot_1.SpotInstance(stack, 'SpotInstanceUbuntu', {
            vpc,
            customAmiId: ami_helper_1.AmazonMachineImage.UBUNTU_20_04_ARM64.getImage(stack).imageId,
            defaultInstanceType: new aws_cdk_lib_1.aws_ec2.InstanceType('t4g.medium'),
            keyName,
            blockDeviceMappings: [{ deviceName: '/dev/sda1', ebs: { volumeSize: 20 } }],
            additionalUserData: ['curl -fsSL https://get.docker.com -o get-docker.sh', 'sudo sh get-docker.sh'],
        });
        new cdk.CfnOutput(stack, 'InstnaceId', { value: spot.instanceId });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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