import { Stack, Duration, aws_ec2 as ec2, aws_iam as iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export declare class VpcProvider extends Stack {
    /**
     * @stability stable
     */
    static getOrCreate(scope: Construct): ec2.IVpc;
}
/**
 * @stability stable
 */
export declare enum BlockDuration {
    /**
     * @stability stable
     */
    ONE_HOUR = 60,
    /**
     * @stability stable
     */
    TWO_HOURS = 120,
    /**
     * @stability stable
     */
    THREE_HOURS = 180,
    /**
     * @stability stable
     */
    FOUR_HOURS = 240,
    /**
     * @stability stable
     */
    FIVE_HOURS = 300,
    /**
     * @stability stable
     */
    SIX_HOURS = 360,
    /**
     * @stability stable
     */
    NONE = 0
}
/**
 * Whether the worker nodes should support GPU or just standard instances.
 *
 * @stability stable
 */
export declare enum NodeType {
    /**
     * Standard instances.
     *
     * @stability stable
     */
    STANDARD = "Standard",
    /**
     * GPU instances.
     *
     * @stability stable
     */
    GPU = "GPU",
    /**
     * Inferentia instances.
     *
     * @stability stable
     */
    INFERENTIA = "INFERENTIA",
    /**
     * ARM instances.
     *
     * @stability stable
     */
    ARM = "ARM"
}
/**
 * @stability stable
 */
export declare enum InstanceInterruptionBehavior {
    /**
     * @stability stable
     */
    HIBERNATE = "hibernate",
    /**
     * @stability stable
     */
    STOP = "stop",
    /**
     * @stability stable
     */
    TERMINATE = "terminate"
}
/**
 * @stability stable
 */
export interface SpotFleetLaunchTemplateConfig {
    /**
     * @stability stable
     */
    readonly spotfleet: SpotFleet;
    /**
     * @stability stable
     */
    readonly launchTemplate: ILaunchtemplate;
}
/**
 * @stability stable
 */
export interface ILaunchtemplate {
    /**
     * @stability stable
     */
    bind(spotfleet: SpotFleet): SpotFleetLaunchTemplateConfig;
}
/**
 * @stability stable
 */
export declare class LaunchTemplate implements ILaunchtemplate {
    /**
     * @stability stable
     */
    bind(spotfleet: SpotFleet): SpotFleetLaunchTemplateConfig;
}
/**
 * @stability stable
 */
export interface SpotOneProps {
    /**
     * VPC for the spot fleet.
     *
     * @default - new VPC will be created
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * default EC2 instance type.
     *
     * @default - t3.large
     * @stability stable
     */
    readonly defaultInstanceType?: ec2.InstanceType;
    /**
     * The behavior when a Spot Instance is interrupted.
     *
     * @default - InstanceInterruptionBehavior.TERMINATE
     * @stability stable
     */
    readonly instanceInterruptionBehavior?: InstanceInterruptionBehavior;
    /**
     * IAM role for the spot instance.
     *
     * @stability stable
     */
    readonly instanceRole?: iam.IRole;
    /**
     * number of the target capacity.
     *
     * @default - 1
     * @stability stable
     */
    readonly targetCapacity?: number;
    /**
     * custom AMI ID.
     *
     * @default - The latest Amaozn Linux 2 AMI ID
     * @stability stable
     */
    readonly customAmiId?: string;
    /**
     * VPC subnet for the spot fleet.
     *
     * @default - public subnet
     * @stability stable
     */
    readonly vpcSubnet?: ec2.SubnetSelection;
    /**
     * Security group for the spot fleet.
     *
     * @default - allows TCP 22 SSH ingress rule
     * @stability stable
     */
    readonly securityGroup?: ec2.SecurityGroup;
    /**
     * SSH key name.
     *
     * @default - no ssh key will be assigned
     * @stability stable
     */
    readonly keyName?: string;
    /**
     * Additional commands for user data.
     *
     * @default - no additional user data
     * @stability stable
     */
    readonly additionalUserData?: string[];
    /**
     * Allocation ID for your existing Elastic IP Address.
     *
     * @stability stable
     * @defalt new EIP and its association will be created for the first instance in this spot fleet
     */
    readonly eipAllocationId?: string;
    /**
     * Auto assign a new EIP on this instance if `eipAllocationId` is not defined.
     *
     * @default true
     * @stability stable
     */
    readonly assignEip?: boolean;
    /**
     * default EBS volume size for the spot instance.
     *
     * @default 60;
     * @stability stable
     */
    readonly ebsVolumeSize?: number;
    /**
     * instance profile for the resource.
     *
     * @default - create a new one
     * @stability stable
     */
    readonly instanceProfile?: iam.CfnInstanceProfile;
}
/**
 * @stability stable
 */
export declare abstract class SpotOne extends Construct {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * The default security group of the instance, which only allows TCP 22 SSH ingress rule.
     *
     * @stability stable
     */
    readonly defaultSecurityGroup: ec2.ISecurityGroup;
    /**
     * @stability stable
     */
    readonly instanceId?: string;
    /**
     * @stability stable
     */
    readonly instanceType?: string;
    /**
     * @stability stable
     */
    readonly defaultInstanceType: ec2.InstanceType;
    /**
     * @stability stable
     */
    readonly imageId: string;
    /**
     * @stability stable
     */
    readonly userData: ec2.UserData;
    /**
     * @stability stable
     */
    protected instanceRole?: iam.IRole;
    /**
     * @stability stable
     */
    protected instanceProfile?: iam.CfnInstanceProfile;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: SpotOneProps);
    /**
     * @stability stable
     */
    protected createInstanceRole(): iam.IRole;
    /**
     * @stability stable
     */
    protected createSecurityGroup(): ec2.SecurityGroup;
    /**
     * @stability stable
     */
    protected associateEip(props: SpotOneProps): void;
    /**
     * @stability stable
     */
    protected createInstanceProfile(role: iam.IRole): iam.CfnInstanceProfile;
}
/**
 * @stability stable
 */
export interface SpotInstanceProps extends SpotOneProps {
    /**
     * blockDeviceMappings for config instance.
     *
     * @default - from ami config.
     * @stability stable
     */
    readonly blockDeviceMappings?: ec2.CfnLaunchTemplate.BlockDeviceMappingProperty[];
}
/**
 * @stability stable
 */
export declare class SpotInstance extends SpotOne {
    /**
     * @stability stable
     */
    readonly instanceId?: string;
    /**
     * @stability stable
     */
    readonly instanceType?: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: SpotInstanceProps);
}
/**
 * @stability stable
 */
export interface BaseSpotFleetProps extends SpotOneProps {
    /**
     * reservce the spot instance as spot block with defined duration.
     *
     * @default - BlockDuration.ONE_HOUR
     * @stability stable
     */
    readonly blockDuration?: BlockDuration;
    /**
     * the time when the spot fleet allocation starts.
     *
     * @default - no expiration
     * @stability stable
     */
    readonly validFrom?: string;
    /**
     * the time when the spot fleet allocation expires.
     *
     * @default - no expiration
     * @stability stable
     */
    readonly validUntil?: string;
    /**
     * terminate the instance when the allocation is expired.
     *
     * @default - true
     * @stability stable
     */
    readonly terminateInstancesWithExpiration?: boolean;
    /**
     * blockDeviceMappings for config instance.
     *
     * @default - from ami config.
     * @stability stable
     */
    readonly blockDeviceMappings?: ec2.CfnLaunchTemplate.BlockDeviceMappingProperty[] | undefined;
}
/**
 * @stability stable
 */
export interface SpotFleetProps extends BaseSpotFleetProps {
    /**
     * Launch template for the spot fleet.
     *
     * @stability stable
     */
    readonly launchTemplate?: ILaunchtemplate;
    /**
     * Whether to create spot instance only instead of a fleet.
     *
     * @default false;
     * @stability stable
     */
    readonly instanceOnly?: boolean;
}
/**
 * @stability stable
 */
export declare class SpotFleet extends SpotOne {
    /**
     * @stability stable
     */
    readonly targetCapacity?: number;
    /**
     * @stability stable
     */
    readonly spotFleetId: string;
    /**
     * @stability stable
     */
    readonly launchTemplate: ILaunchtemplate;
    /**
     * the first instance id in this fleet.
     *
     * @stability stable
     */
    readonly instanceId?: string;
    /**
     * instance type of the first instance in this fleet.
     *
     * @stability stable
     */
    readonly instanceType?: string;
    /**
     * SpotFleetRequestId for this spot fleet.
     *
     * @stability stable
     */
    readonly spotFleetRequestId?: string;
    /**
     * The behavior when a Spot Instance is interrupted.
     *
     * @default terminate
     * @stability stable
     */
    readonly instanceInterruptionBehavior?: InstanceInterruptionBehavior;
    /**
     * The time when the the fleet allocation will expire
     */
    private validUntil?;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: SpotFleetProps);
    /**
     * @stability stable
     */
    expireAfter(duration: Duration): void;
}
/**
 * @stability stable
 */
export interface LaunchTemplateProps {
    /**
     * @stability stable
     */
    readonly imageId?: string;
    /**
     * @stability stable
     */
    readonly defaultInstanceType?: ec2.InstanceType;
    /**
     * @stability stable
     */
    readonly keyName?: string;
    /**
     * @stability stable
     */
    readonly userData?: ec2.UserData;
    /**
     * blockDeviceMappings for config instance.
     *
     * @default - from ami config.
     * @stability stable
     */
    readonly blockDeviceMappings?: ec2.CfnLaunchTemplate.BlockDeviceMappingProperty[] | undefined;
    /**
     * @stability stable
     */
    readonly instanceMarketOptions?: ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty;
    /**
     * @stability stable
     */
    readonly securityGroup?: ec2.ISecurityGroup[];
    /**
     * @stability stable
     */
    readonly iamInstanceProfile?: iam.CfnInstanceProfile;
}
/**
 * @stability stable
 */
export declare class LaunchTemplateResource extends Construct {
    /**
     * @stability stable
     */
    readonly defaultInstanceType: ec2.InstanceType;
    /**
     * @stability stable
     */
    readonly resource: ec2.CfnLaunchTemplate;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: LaunchTemplateProps);
}
