"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LaunchTemplateResource = exports.SpotFleet = exports.SpotInstance = exports.SpotOne = exports.LaunchTemplate = exports.InstanceInterruptionBehavior = exports.NodeType = exports.BlockDuration = exports.VpcProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const DEFAULT_INSTANCE_TYPE = 't3.large';
/**
 * @stability stable
 */
class VpcProvider extends aws_cdk_lib_1.Stack {
    /**
     * @stability stable
     */
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        return stack.node.tryGetContext('use_default_vpc') === '1' ?
            aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(stack, 'Vpc', { isDefault: true }) :
            stack.node.tryGetContext('use_vpc_id') ?
                aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(stack, 'Vpc', { vpcId: stack.node.tryGetContext('use_vpc_id') }) :
                new aws_cdk_lib_1.aws_ec2.Vpc(stack, 'Vpc', { maxAzs: 3, natGateways: 1 });
    }
}
exports.VpcProvider = VpcProvider;
_a = JSII_RTTI_SYMBOL_1;
VpcProvider[_a] = { fqn: "cdk-spot-one.VpcProvider", version: "2.0.12" };
/**
 * @stability stable
 */
var BlockDuration;
(function (BlockDuration) {
    BlockDuration[BlockDuration["ONE_HOUR"] = 60] = "ONE_HOUR";
    BlockDuration[BlockDuration["TWO_HOURS"] = 120] = "TWO_HOURS";
    BlockDuration[BlockDuration["THREE_HOURS"] = 180] = "THREE_HOURS";
    BlockDuration[BlockDuration["FOUR_HOURS"] = 240] = "FOUR_HOURS";
    BlockDuration[BlockDuration["FIVE_HOURS"] = 300] = "FIVE_HOURS";
    BlockDuration[BlockDuration["SIX_HOURS"] = 360] = "SIX_HOURS";
    BlockDuration[BlockDuration["NONE"] = 0] = "NONE";
})(BlockDuration = exports.BlockDuration || (exports.BlockDuration = {}));
/**
 * Whether the worker nodes should support GPU or just standard instances.
 *
 * @stability stable
 */
var NodeType;
(function (NodeType) {
    NodeType["STANDARD"] = "Standard";
    NodeType["GPU"] = "GPU";
    NodeType["INFERENTIA"] = "INFERENTIA";
    NodeType["ARM"] = "ARM";
})(NodeType = exports.NodeType || (exports.NodeType = {}));
/**
 * @stability stable
 */
var InstanceInterruptionBehavior;
(function (InstanceInterruptionBehavior) {
    InstanceInterruptionBehavior["HIBERNATE"] = "hibernate";
    InstanceInterruptionBehavior["STOP"] = "stop";
    InstanceInterruptionBehavior["TERMINATE"] = "terminate";
})(InstanceInterruptionBehavior = exports.InstanceInterruptionBehavior || (exports.InstanceInterruptionBehavior = {}));
/**
 * @stability stable
 */
class LaunchTemplate {
    /**
     * @stability stable
     */
    bind(spotfleet) {
        return {
            spotfleet,
            launchTemplate: this,
        };
    }
}
exports.LaunchTemplate = LaunchTemplate;
_b = JSII_RTTI_SYMBOL_1;
LaunchTemplate[_b] = { fqn: "cdk-spot-one.LaunchTemplate", version: "2.0.12" };
/**
 * @stability stable
 */
class SpotOne extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _g, _h, _j;
        super(scope, id);
        this.vpc = (_g = props.vpc) !== null && _g !== void 0 ? _g : VpcProvider.getOrCreate(this);
        this.defaultSecurityGroup = props.securityGroup || this.createSecurityGroup();
        this.instanceProfile = props.instanceProfile;
        this.defaultInstanceType = (_h = props.defaultInstanceType) !== null && _h !== void 0 ? _h : new aws_cdk_lib_1.aws_ec2.InstanceType(DEFAULT_INSTANCE_TYPE);
        this.imageId = (_j = props.customAmiId) !== null && _j !== void 0 ? _j : aws_cdk_lib_1.aws_ec2.MachineImage.latestAmazonLinux({
            generation: aws_cdk_lib_1.aws_ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
            cpuType: nodeTypeForInstanceType(this.defaultInstanceType) === NodeType.ARM ? aws_cdk_lib_1.aws_ec2.AmazonLinuxCpuType.ARM_64 : undefined,
        }).getImage(this).imageId;
        this.userData = aws_cdk_lib_1.aws_ec2.UserData.forLinux();
        /**
         * If not using custom AMI, we use amazon linux 2 and install the SSM agent and enable docker by default.
         * Otherwise, we simply do nothing here.
         */
        if (props.customAmiId == undefined) {
            this.userData.addCommands('yum install -y https://s3.amazonaws.com/ec2-downloads-windows/SSMAgent/latest/linux_amd64/amazon-ssm-agent.rpm', 'yum install -y docker', 'usermod -aG docker ec2-user', 'usermod -aG docker ssm-user', 'service docker start');
        }
        if (props.additionalUserData) {
            this.userData.addCommands(...props.additionalUserData);
        }
        this.associateEip(props);
    }
    /**
     * @stability stable
     */
    createInstanceRole() {
        this.instanceRole = new aws_cdk_lib_1.aws_iam.Role(this, 'InstanceRole', {
            roleName: aws_cdk_lib_1.PhysicalName.GENERATE_IF_NEEDED,
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('ec2.amazonaws.com'),
        });
        this.instanceRole.addManagedPolicy({
            managedPolicyArn: 'arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore',
        });
        return this.instanceRole;
    }
    /**
     * @stability stable
     */
    createSecurityGroup() {
        const securityGroup = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'SpotFleetSg', {
            vpc: this.vpc,
        });
        securityGroup.connections.allowFromAnyIpv4(aws_cdk_lib_1.aws_ec2.Port.tcp(22));
        return securityGroup;
    }
    /**
     * @stability stable
     */
    associateEip(props) {
        // EIP association
        if (props.eipAllocationId) {
            new aws_cdk_lib_1.aws_ec2.CfnEIPAssociation(this, 'EipAssocation', {
                allocationId: props.eipAllocationId,
                instanceId: this.instanceId,
            });
        }
        else if (props.assignEip !== false) {
            new aws_cdk_lib_1.aws_ec2.CfnEIP(this, 'EIP', {
                instanceId: this.instanceId,
            });
        }
    }
    /**
     * @stability stable
     */
    createInstanceProfile(role) {
        return new aws_cdk_lib_1.aws_iam.CfnInstanceProfile(this, 'InstanceProfile', {
            roles: [role.roleName],
        });
    }
}
exports.SpotOne = SpotOne;
_c = JSII_RTTI_SYMBOL_1;
SpotOne[_c] = { fqn: "cdk-spot-one.SpotOne", version: "2.0.12" };
/**
 * @stability stable
 */
class SpotInstance extends SpotOne {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _g, _h, _j, _k, _l;
        super(scope, id, props);
        const spotInstance = new aws_cdk_lib_1.aws_ec2.Instance(this, 'SpotInstance', {
            vpc: this.vpc,
            instanceType: this.defaultInstanceType,
            machineImage: aws_cdk_lib_1.aws_ec2.MachineImage.latestAmazonLinux({
                generation: aws_cdk_lib_1.aws_ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
                cpuType: nodeTypeForInstanceType(this.defaultInstanceType) === NodeType.ARM ? aws_cdk_lib_1.aws_ec2.AmazonLinuxCpuType.ARM_64 : undefined,
            }),
            keyName: props.keyName,
            securityGroup: this.defaultSecurityGroup,
            vpcSubnets: (_g = props.vpcSubnet) !== null && _g !== void 0 ? _g : {
                subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC,
            },
        });
        spotInstance.role.addManagedPolicy({
            managedPolicyArn: 'arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore',
        });
        const cfnInstance = spotInstance.node.defaultChild;
        // create custom launch template reousrce
        const launchTemplate = new LaunchTemplateResource(this, 'launchTemplateForInstance', {
            imageId: (_h = props.customAmiId) !== null && _h !== void 0 ? _h : aws_cdk_lib_1.aws_ec2.MachineImage.latestAmazonLinux({
                generation: aws_cdk_lib_1.aws_ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
                cpuType: nodeTypeForInstanceType(this.defaultInstanceType) === NodeType.ARM ? aws_cdk_lib_1.aws_ec2.AmazonLinuxCpuType.ARM_64 : undefined,
            }).getImage(this).imageId,
            defaultInstanceType: this.defaultInstanceType,
            instanceMarketOptions: {
                marketType: 'spot',
                spotOptions: {
                    instanceInterruptionBehavior: InstanceInterruptionBehavior.STOP,
                    spotInstanceType: props.instanceInterruptionBehavior === InstanceInterruptionBehavior.TERMINATE ? 'one-time'
                        : 'persistent',
                },
            },
            iamInstanceProfile: (_j = this.instanceProfile) !== null && _j !== void 0 ? _j : spotInstance.node.tryFindChild('InstanceProfile'),
            blockDeviceMappings: (_k = props.blockDeviceMappings) !== null && _k !== void 0 ? _k : [{ deviceName: '/dev/xvda', ebs: { volumeSize: (_l = props.ebsVolumeSize) !== null && _l !== void 0 ? _l : 10 } }],
            userData: this.userData,
        });
        cfnInstance.addPropertyOverride('LaunchTemplate', {
            LaunchTemplateId: launchTemplate.resource.ref,
            Version: launchTemplate.resource.attrLatestVersionNumber,
        });
        // As we can't specify IamInstanceProfile, UserData, ImageId, InstaneType both in launch template and instane property
        // we need delete the property here.
        cfnInstance.addPropertyDeletionOverride('IamInstanceProfile');
        cfnInstance.addPropertyDeletionOverride('UserData');
        cfnInstance.addPropertyDeletionOverride('ImageId');
        cfnInstance.addPropertyDeletionOverride('InstaneType');
        this.instanceId = spotInstance.instanceId;
        this.instanceType = this.defaultInstanceType.toString();
        new aws_cdk_lib_1.CfnOutput(this, 'PublicIpAddress', { value: cfnInstance.attrPublicIp });
    }
}
exports.SpotInstance = SpotInstance;
_d = JSII_RTTI_SYMBOL_1;
SpotInstance[_d] = { fqn: "cdk-spot-one.SpotInstance", version: "2.0.12" };
/**
 * @stability stable
 */
class SpotFleet extends SpotOne {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _g, _h, _j, _k, _l, _m, _o, _p, _q;
        super(scope, id, props);
        this.spotFleetId = id;
        this.launchTemplate = (_g = props.launchTemplate) !== null && _g !== void 0 ? _g : new LaunchTemplate();
        this.targetCapacity = (_h = props.targetCapacity) !== null && _h !== void 0 ? _h : 1;
        this.validUntil = props.validUntil;
        const stack = aws_cdk_lib_1.Stack.of(this);
        this.instanceProfile = ((_j = props.instanceProfile) !== null && _j !== void 0 ? _j : props.instanceRole) ? this.createInstanceProfile(props.instanceRole)
            : this.createInstanceProfile(this.createInstanceRole());
        const lt = new LaunchTemplateResource(this, 'LaunchTemplate', {
            blockDeviceMappings: props.blockDeviceMappings,
            defaultInstanceType: this.defaultInstanceType,
            iamInstanceProfile: this.instanceProfile,
            imageId: this.imageId,
            instanceMarketOptions: {
                marketType: 'spot',
                spotOptions: {
                    blockDurationMinutes: (props.blockDuration == BlockDuration.NONE) ? undefined : ((_k = props.blockDuration) !== null && _k !== void 0 ? _k : BlockDuration.ONE_HOUR),
                    instanceInterruptionBehavior: (_l = props.instanceInterruptionBehavior) !== null && _l !== void 0 ? _l : InstanceInterruptionBehavior.TERMINATE,
                },
            },
            keyName: props.keyName,
            securityGroup: this.defaultSecurityGroup.connections.securityGroups,
            userData: this.userData,
        });
        const spotFleetRole = new aws_cdk_lib_1.aws_iam.Role(this, 'FleetRole', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('spotfleet.amazonaws.com'),
            managedPolicies: [
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonEC2SpotFleetTaggingRole'),
            ],
        });
        const vpcSubnetSelection = (_m = props.vpcSubnet) !== null && _m !== void 0 ? _m : {
            subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC,
        };
        const subnetConfig = this.vpc.selectSubnets(vpcSubnetSelection).subnets.map(s => ({
            subnetId: s.subnetId,
        }));
        const cfnSpotFleet = new aws_cdk_lib_1.aws_ec2.CfnSpotFleet(this, id, {
            spotFleetRequestConfigData: {
                launchTemplateConfigs: [
                    {
                        launchTemplateSpecification: {
                            launchTemplateId: lt.resource.ref,
                            version: lt.resource.attrLatestVersionNumber,
                        },
                        overrides: subnetConfig,
                    },
                ],
                iamFleetRole: spotFleetRole.roleArn,
                targetCapacity: (_o = props.targetCapacity) !== null && _o !== void 0 ? _o : 1,
                validFrom: props.validFrom,
                validUntil: aws_cdk_lib_1.Lazy.string({ produce: () => this.validUntil }),
                terminateInstancesWithExpiration: (_p = props.terminateInstancesWithExpiration) !== null && _p !== void 0 ? _p : true,
                instanceInterruptionBehavior: (_q = props.instanceInterruptionBehavior) !== null && _q !== void 0 ? _q : InstanceInterruptionBehavior.TERMINATE,
            },
        });
        new aws_cdk_lib_1.CfnOutput(stack, 'SpotFleetId', { value: cfnSpotFleet.ref });
        const onEvent = new aws_cdk_lib_1.aws_lambda.Function(this, 'OnEvent', {
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../eip-handler')),
            handler: 'index.on_event',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
        const isComplete = new aws_cdk_lib_1.aws_lambda.Function(this, 'IsComplete', {
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../eip-handler')),
            handler: 'index.is_complete',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
            role: onEvent.role,
        });
        const myProvider = new aws_cdk_lib_1.custom_resources.Provider(this, 'MyProvider', {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
        });
        onEvent.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            actions: ['ec2:DescribeSpotFleetInstances'],
            resources: ['*'],
        }));
        const fleetInstances = new aws_cdk_lib_1.CustomResource(this, 'SpotFleetInstances', {
            serviceToken: myProvider.serviceToken,
            properties: {
                SpotFleetRequestId: cfnSpotFleet.ref,
            },
        });
        fleetInstances.node.addDependency(cfnSpotFleet);
        this.instanceId = aws_cdk_lib_1.Token.asString(fleetInstances.getAtt('InstanceId'));
        this.instanceType = aws_cdk_lib_1.Token.asString(fleetInstances.getAtt('InstanceType'));
        this.spotFleetRequestId = aws_cdk_lib_1.Token.asString(fleetInstances.getAtt('SpotInstanceRequestId'));
        new aws_cdk_lib_1.CfnOutput(stack, 'InstanceId', { value: this.instanceId });
    }
    /**
     * @stability stable
     */
    expireAfter(duration) {
        const date = new Date();
        date.setSeconds(date.getSeconds() + duration.toSeconds());
        this.validUntil = date.toISOString();
    }
}
exports.SpotFleet = SpotFleet;
_e = JSII_RTTI_SYMBOL_1;
SpotFleet[_e] = { fqn: "cdk-spot-one.SpotFleet", version: "2.0.12" };
/**
 * @stability stable
 */
class LaunchTemplateResource extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _g, _h, _j, _k, _l;
        super(scope, id);
        this.defaultInstanceType = (_g = props.defaultInstanceType) !== null && _g !== void 0 ? _g : new aws_cdk_lib_1.aws_ec2.InstanceType(DEFAULT_INSTANCE_TYPE);
        const imageId = (_h = props.imageId) !== null && _h !== void 0 ? _h : aws_cdk_lib_1.aws_ec2.MachineImage.latestAmazonLinux({
            generation: aws_cdk_lib_1.aws_ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
            cpuType: nodeTypeForInstanceType(this.defaultInstanceType) === NodeType.ARM ? aws_cdk_lib_1.aws_ec2.AmazonLinuxCpuType.ARM_64 : undefined,
        }).getImage(this).imageId;
        const userData = (_j = props.userData) !== null && _j !== void 0 ? _j : aws_cdk_lib_1.aws_ec2.UserData.forLinux();
        this.resource = new aws_cdk_lib_1.aws_ec2.CfnLaunchTemplate(this, 'LaunchTemplate', {
            launchTemplateData: {
                imageId,
                instanceType: this.defaultInstanceType.toString(),
                userData: aws_cdk_lib_1.Fn.base64(userData.render()),
                keyName: props.keyName,
                tagSpecifications: [
                    {
                        resourceType: 'instance',
                        tags: [
                            {
                                key: 'Name',
                                value: `${aws_cdk_lib_1.Stack.of(this).stackName}/${id}`,
                            },
                        ],
                    },
                ],
                blockDeviceMappings: (_k = props.blockDeviceMappings) !== null && _k !== void 0 ? _k : undefined,
                instanceMarketOptions: props.instanceMarketOptions,
                securityGroupIds: (_l = props.securityGroup) === null || _l === void 0 ? void 0 : _l.map(s => s.securityGroupId),
                iamInstanceProfile: props.iamInstanceProfile ? {
                    arn: props.iamInstanceProfile.attrArn,
                } : undefined,
            },
        });
    }
}
exports.LaunchTemplateResource = LaunchTemplateResource;
_f = JSII_RTTI_SYMBOL_1;
LaunchTemplateResource[_f] = { fqn: "cdk-spot-one.LaunchTemplateResource", version: "2.0.12" };
const GRAVITON_INSTANCETYPES = ['a1'];
const GRAVITON2_INSTANCETYPES = ['c6g', 'm6g', 'r6g', 'x2gd'];
const GPU_INSTANCETYPES = ['p2', 'p3', 'g4'];
const INFERENTIA_INSTANCETYPES = ['inf1'];
function nodeTypeForInstanceType(instanceType) {
    return GPU_INSTANCETYPES.includes(instanceType.toString().substring(0, 2)) ? NodeType.GPU :
        INFERENTIA_INSTANCETYPES.includes(instanceType.toString().substring(0, 4)) ? NodeType.INFERENTIA :
            GRAVITON2_INSTANCETYPES.includes(instanceType.toString().substring(0, 3)) ? NodeType.ARM :
                GRAVITON_INSTANCETYPES.includes(instanceType.toString().substring(0, 2)) ? NodeType.ARM :
                    NodeType.STANDARD;
}
//# sourceMappingURL=data:application/json;base64,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