# dz_locations

**DZ Locations** is a Django package that provides **Algerian wilayas (states) and communes (municipalities)** ready to use in your Django projects.

This package helps you quickly populate your database with all Algerian locations and access them via Django Admin or API.

---

## **Installation**

Install the package via pip:

```bash
pip install dz-locations
```

---

## **Features**

- ✅ Ready-to-use Wilayas & Communes of Algeria  
- ✅ Arabic & French names  
- ✅ Longitude & Latitude for mapping  
- ✅ DRF serializers included  

---

## **Usage**

1. Add `dz_locations` to your `INSTALLED_APPS` in `settings.py`:

    ```python
    INSTALLED_APPS = [
        ...
        'dz_locations',
    ]
    ```

2. Run migrations to create database tables

    ```bash
    python manage.py makemigrations dz_locations
    python manage.py migrate
    ```

3. Include the app URLs in your root URLconf :
   
   ```python
    from django.urls import include, path
    urlpatterns = [
       ...,
       path("dzloc", include("dz_locations.urls")),
     ]
    ```



3. (Optional) If you want to populate your database with the provided Algerian    locations data,  
   run the following management command:

    ```bash
    python manage.py newload
    ```

4. Access the data:
   - Via **Django Admin** (Wilayas & Communes models).  
   - Or via the provided **serializers** for API development (Django REST Framework).  

---
## **Use Cases**

Example usage with the included endpoints:

```python
from django.urls import path
from .views import WilayaListAPI, get_wliaya

urlpatterns = [
    path('wilayas/', WilayaListAPI.as_view(), name='wilaya-list'),
    path('wilaya/<str:code>/', get_wliaya, name='get-wilaya-by-code'),
]
```

### Example Requests

- **Get all Wilayas**
  ```http
  GET /dzloc/wilayas/
  ```

- **Get a specific Wilaya by code**
  ```http
  GET /dzloc/wilaya/01/
  ```

### Example Response (for `/dzloc/wilaya/01/`)
```json
{
  "id": 1,
  "code": "01",
  "name": "Adrar",
  "ar_name": "أدرار",
  "longitude": 27.9766155,
  "latitude": -0.20396,
  "communes": [
    {
      "id": 1,
      "post_code": "01001",
      "name": "Adrar",
      "ar_name": "أدرار",
      "longitude": 27.9763317,
      "latitude": -0.4841573
    }
    ,
    
  ]
}
```

---

## **Data Source**

The JSON data used in this project is sourced from:  
👉 [Wilaya-Of-Algeria by AbderrahmeneDZ](https://github.com/AbderrahmeneDZ/Wilaya-Of-Algeria)


---

## **Contributing**

Contributions are welcome! If you'd like to contribute, please follow these steps:

1. Fork the repository.
2. Create a new branch for your feature or bugfix.
3. Commit your changes and push them to your fork.
4. Submit a pull request.

---

## **License**

This project is licensed under the MIT License. See the LICENSE file for details.