/*!
 * ColumnControl 1.1.1
 * Copyright (c) SpryMedia Ltd - datatables.net/license
 *
 * SVG icons: ISC License
 * Copyright (c) for portions of Lucide are held by Cole Bemis 2013-2022 as part of Feather (MIT).
 * All other copyright (c) for Lucide are held by Lucide Contributors 2022.
 */
!function(t){if('function'==typeof define&&define.amd)define(['jquery','datatables.net'],function(e){return t(e,window,document)});else if('object'==typeof exports){var e=require('jquery'),n=function(t,e){e.fn.dataTable||require('datatables.net')(t,e)};'undefined'==typeof window?module.exports=function(r,o){return r||(r=window),o||(o=e(r)),n(r,o),t(o,r,r.document)}:(n(window,e),module.exports=t(e,window,window.document))}else t(jQuery,window,document)}(function(t,e,n){'use strict';var r=t.fn.dataTable;function o(t,e,r,o){void 0===e&&(e=[]),void 0===r&&(r=null),void 0===o&&(o=[]);var s=n.createElement(t);return i(s,e),r&&(s.innerHTML=r),o.forEach(function(t){s.appendChild(t)}),s}function i(t,e){e&&(Array.isArray(e)||(e=[e]),e.forEach(function(e){t&&e&&t.classList.add(e)}))}function s(t){return'<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">'+t+'</svg>'}var a={chevronRight:s('<path d="m9 18 6-6-6-6"/>'),columns:s('<rect width="18" height="18" x="3" y="3" rx="2"/><path d="M9 3v18"/><path d="M15 3v18"/>'),contains:s('<path d="M10 3h4v18h-4z"/><path d="M18 8h3v9h-3"/><path d="M6 17H3V8h3"/>'),empty:s('<circle cx="12" cy="12" r="10"/>'),ends:s('<path d="M21 3h-4v18h4z"/><path d="M13 8H3v9h10"/>'),equal:s('<line x1="5" x2="19" y1="9" y2="9"/><line x1="5" x2="19" y1="15" y2="15"/>'),greater:s('<path d="m9 18 6-6-6-6"/>'),greaterOrEqual:s('<path d="m9 16 6-6-6-6"/><path d="m9 21 6-6"/>'),groupAdd:s('<path d="M6 21v-7.5m-3.549 3.75H9.75"/><rect width="13.5" height="7.5" x="3" y="3" rx="1.5"/><rect width="7.5" height="7.5" x="13.5" y="13.5" fill="currentColor" rx="1.5"/>'),groupClear:s('<rect width="13.5" height="7.5" x="3" y="3" rx="1.5"/><rect width="7.5" height="7.5" x="13.5" y="13.5" rx="1.5"/>'),groupTop:s('<rect width="13.5" height="7.5" x="3" y="3" fill="currentColor" rx="1.5"/><rect width="7.5" height="7.5" x="13.5" y="13.5" rx="1.5"/>'),groupRemove:s('<path d="M2.451 17.25H9.75"/><rect width="13.5" height="7.5" x="3" y="3" rx="1.5"/><rect width="7.5" height="7.5" x="13.5" y="13.5" rx="1.5"/>'),less:s('<path d="m15 18-6-6 6-6"/>'),lessOrEqual:s('<path d="m15 16-6-6 6-6"/><path d="m15 21-6-6"/>'),menu:s('<line x1="4" x2="20" y1="12" y2="12"/><line x1="4" x2="20" y1="6" y2="6"/><line x1="4" x2="20" y1="18" y2="18"/>'),move:s('<line x1="12" x2="12" y1="3" y2="21"/><polyline points="8 8 4 12 8 16"/><polyline points="16 16 20 12 16 8"/>'),moveLeft:s('<path d="m9 6-6 6 6 6"/><path d="M3 12h14"/><path d="M21 19V5"/>'),moveRight:s('<path d="M3 5v14"/><path d="M21 12H7"/><path d="m15 18 6-6-6-6"/>'),notContains:s('<path d="M15 4 9 20"/><path d="M3 8h18v9H3z"/>'),notEmpty:s('<circle cx="12" cy="12" r="10"/><line x1="9" x2="15" y1="15" y2="9"/>'),notEqual:s('<path d="M5 9h14"/><path d="M5 15h14"/><path d="M15 5 9 19"/>'),orderAddAsc:s('<path d="M17 21v-8"/><path d="M3 4h6"/><path d="M3 8h9"/><path d="M3 12h10"/><path d="M13 17h8"/>'),orderAddDesc:s('<path d="M17 21v-8"/><path d="M3 4h12"/><path d="M3 8h9"/><path d="M3 12h6"/><path d="M13 17h8"/>'),orderAsc:s('<path d="m3 8 4-4 4 4"/><path d="M7 4v16"/><path d="M11 12h4"/><path d="M11 16h7"/><path d="M11 20h10"/>'),orderClear:s('<path d="m21 21-8-8"/><path d="M3 4h12"/><path d="M3 8h9"/><path d="M3 12h6"/><path d="m13 21 8-8"/>'),orderDesc:s('<path d="m3 16 4 4 4-4"/><path d="M7 20V4"/><path d="M11 4h10"/><path d="M11 8h7"/><path d="M11 12h4"/>'),orderRemove:s('<path d="M3 4h12"/><path d="M3 8h9"/><path d="M3 12h6"/><path d="M13 17h8"/>'),orderNone:s('<path d="m3 8 4-4 4 4"/><path d="m11 16-4 4-4-4"/><path d="M7 4v16"/><path d="M15 8h6"/><path d="M15 16h6"/><path d="M13 12h8"/>'),search:s('<circle cx="11" cy="11" r="8"/><path d="m21 21-4.3-4.3"/>'),searchClear:s('<path d="m13.5 8.5-5 5"/><path d="m8.5 8.5 5 5"/><circle cx="11" cy="11" r="8"/><path d="m21 21-4.3-4.3"/>'),starts:s('<path d="M3 3h4v18H3z"/><path d="M11 8h10v9H11"/>'),tick:s('<path d="M20 6 9 17l-5-5"/>'),x:s('<path d="M18 6 6 18"/><path d="m6 6 12 12"/>')};function c(t){void 0===t&&(t=null),n.querySelectorAll('div.dtcc-dropdown').forEach(function(e){null!==t&&e.contains(t.target)||(e._close(),t._closed||(t._closed=[]),t._closed.push(e))})}function l(t,e){return e.closest('div.dtfh-floatingparent')||t.table().container()}function u(t,e,n){var r,o,i=n.closest('div.dt-column-header'),s=l(e,n),a=getComputedStyle(i),c=t.offsetWidth,u=h(s,n);o=u.top+n.offsetHeight,r='row-reverse'===a.flexDirection?u.left:u.left-c+n.offsetWidth;var d=s.offsetWidth;r+c>d&&(r-=r+c-d),r<0&&(r=0),t.style.top=o+'px',t.style.left=r+'px'}function d(t,e,r){var o=l(e,r.element());t._shown=!0,o.append(t),u(t,e,r.element()),r.element().setAttribute('aria-expanded','true');var i=function(e){if(t._shown){if(e.target!==t&&!t.contains(e.target)){var r=n.querySelector('div.dt-datetime');r&&(e.target===r||r.contains(e.target))||(t._close(),n.body.removeEventListener('click',i))}}else n.body.removeEventListener('click',i)};return n.body.addEventListener('click',i),i}function h(t,e){for(var r=0,o=0;e&&e!==t&&e!==n.body;)r+=e.offsetTop,o+=e.offsetLeft,e.scrollTop&&(o-=e.scrollTop),e.scrollLeft&&(o-=e.scrollLeft),e=e.offsetParent;return{top:r,left:o}}function p(t,e){return function(r){if(t._shown){var o=Array.from(t.querySelectorAll('a, button, input, select')),i=n.activeElement;if('Escape'===r.key)return t._close(),void e.focus();'Tab'===r.key&&0!==o.length&&(o.includes(i)?r.shiftKey?i===o[0]&&(o[o.length-1].focus(),r.preventDefault()):i===o[o.length-1]&&(o[0].focus(),r.preventDefault()):(o[0].focus(),r.preventDefault()))}}}var f={classes:{container:'dtcc-dropdown',liner:'dtcc-dropdown-liner'},defaults:{className:'dropdown',content:[],icon:'menu',text:'More...'},init:function(t){var e=this.dt(),r=o('div',f.classes.container,'',[o('div',f.classes.liner)]);r._shown=!1,r._close=function(){r.remove(),r._shown=!1,s.element().setAttribute('aria-expanded','false')},r.setAttribute('role','dialog'),r.setAttribute('aria-label',e.i18n('columnControl.dropdown',t.text)),e.on('fixedheader-mode',function(){r._shown&&d(r,e,t._parents?t._parents[0]:s)});var i=r.childNodes[0],s=new v(e,this).text(e.i18n('columnControl.dropdown',t.text)).icon(t.icon).className(t.className).dropdownDisplay(i).handler(function(n){if(!n._closed||!n._closed.includes(r)){d(r,e,t._parents?t._parents[0]:s);var o=r.querySelector('input, a, button');o&&'keypress'===n.type&&o.focus()}});s.element().setAttribute('aria-haspopup','dialog'),s.element().setAttribute('aria-expanded','false');for(var a=0;a<t.content.length;a++){var c=this.resolve(t.content[a]);c.config._parents||(c.config._parents=[]),c.config._parents.push(s);var l=c.plugin.init.call(this,c.config);i.appendChild(l)}t._parents&&t._parents.length&&s.extra('chevronRight'),e.on('columns-reordered',function(){u(r,e,s.element())});var h=p(r,s.element());return n.body.addEventListener('keydown',h),e.on('destroy',function(){n.body.removeEventListener('keydown',h)}),s.element()}},m=0,v=function(){function t(e,n){this._s={active:!1,activeList:[],buttonClick:null,dt:null,enabled:!0,host:null,label:'',namespace:'',value:null},this._s.dt=e,this._s.host=n,this._dom={button:o('button',t.classes.container),dropdownDisplay:null,extra:o('span','dtcc-button-extra'),icon:o('span','dtcc-button-icon'),state:o('span','dtcc-button-state'),text:o('span','dtcc-button-text')},this._dom.button.setAttribute('type','button'),this._dom.button.append(this._dom.icon),this._dom.button.append(this._dom.text),this._dom.button.append(this._dom.state),this._dom.button.append(this._dom.extra),this.enable(!0)}return t.prototype.active=function(t){return void 0===t?this._s.active:(this._s.active=t,this._checkActive(),this)},t.prototype.activeList=function(t,e){return this._s.activeList[t]=e,this._checkActive(),this},t.prototype.checkDisplay=function(){for(var t=0,e=this._dom.dropdownDisplay.childNodes,n=0;n<e.length;n++)'none'!==e[n].style.display&&t++;return 0===t&&(this._dom.button.style.display='none'),this},t.prototype.className=function(t){return this._dom.button.classList.add('dtcc-button_'+t),this},t.prototype.destroy=function(){this._s.buttonClick&&(this._dom.button.removeEventListener('click',this._s.buttonClick),this._dom.button.removeEventListener('keypress',this._s.buttonClick)),this._s.host.destroyRemove(this)},t.prototype.dropdownDisplay=function(t){return this._dom.dropdownDisplay=t,this},t.prototype.element=function(){return this._dom.button},t.prototype.enable=function(t){return void 0===t?this._s.enabled:(this._dom.button.classList.toggle('dtcc-button_disabled',!t),this._s.enabled=t,this)},t.prototype.extra=function(t){return this._dom.extra.innerHTML=t?a[t]:'',this},t.prototype.handler=function(t){var e=this,n=function(n){c(n),n.stopPropagation(),n.preventDefault(),e._s.enabled&&t(n)};return this._s.buttonClick=n,this._s.namespace='dtcc-'+m++,this._dom.button.addEventListener('click',n),this._dom.button.addEventListener('keypress',n),this._s.host.destroyAdd(this),this},t.prototype.icon=function(t){return this._dom.icon.innerHTML=t?a[t]:'',this},t.prototype.text=function(t){return void 0===t?this._s.label:(this._dom.text.innerHTML=t,this._s.label=t,this._dom.button.setAttribute('aria-label',t),this)},t.prototype.value=function(t){return void 0===t?this._s.value:(this._s.value=t,this)},t.prototype._checkActive=function(){return!0===this._s.active||Object.values(this._s.activeList).includes(!0)?(this._dom.state.innerHTML=a.tick,this._dom.button.classList.add('dtcc-button_active')):(this._dom.state.innerHTML='',this._dom.button.classList.remove('dtcc-button_active')),this},t.classes={container:'dtcc-button'},t}(),x=function(){function t(e,n,r){var i=this;this._s={buttons:[],dt:null,handler:function(){},host:null,search:''},this._s.dt=e,this._s.host=n,this._dom={buttons:o('div','dtcc-list-buttons'),container:o('div',t.classes.container),controls:o('div','dtcc-list-controls'),empty:o('div','dtcc-list-empty',e.i18n('columnControl.list.empty','No options')),title:o('div','dtcc-list-title'),selectAll:o('button','dtcc-list-selectAll',e.i18n('columnControl.list.all','Select all')),selectAllCount:o('span'),selectNone:o('button','dtcc-list-selectNone',e.i18n('columnControl.list.none','Deselect')),selectNoneCount:o('span'),search:o('input',t.classes.input)};var s=this._dom;s.search.setAttribute('type','text'),s.container.append(s.title),s.container.append(s.controls),s.container.append(s.empty),s.container.append(s.buttons),r.select&&(s.controls.append(s.selectAll),s.controls.append(s.selectNone),s.selectAll.append(s.selectAllCount),s.selectNone.append(s.selectNoneCount),s.selectAll.setAttribute('type','button'),s.selectNone.setAttribute('type','button'));var a=function(){i._s.search=s.search.value,i._redraw()},c=function(t){i.selectAll(),i._s.handler(t,null,i._s.buttons,!0),i._updateCount()},l=function(t){i.selectNone(),i._s.handler(t,null,i._s.buttons,!0),i._updateCount()};r.search&&(s.controls.append(s.search),s.search.setAttribute('placeholder',e.i18n('columnControl.list.search','Search...')),s.search.addEventListener('input',a)),s.selectAll.addEventListener('click',c),s.selectNone.addEventListener('click',l),e.on('destroy',function(){s.selectAll.removeEventListener('click',c),s.selectNone.removeEventListener('click',l),s.search.removeEventListener('input',a)})}return t.prototype.add=function(t,e){var n=this;Array.isArray(t)||(t=[t]);for(var r=function(e){var r=t[e],i=new v(o._s.dt,o._s.host).active(r.active||!1).handler(function(t){n._s.handler(t,i,n._s.buttons,!0),n._updateCount()}).icon(r.icon||'').text(''!==r.label?r.label:o._s.dt.i18n('columnControl.list.empty','Empty')).value(r.value);''===r.label&&i.className('empty'),o._s.buttons.push(i)},o=this,i=0;i<t.length;i++)r(i);var s=this._s.buttons.length;return!0!==e&&void 0!==e||(this._dom.selectAllCount.innerHTML=s?'('+s+')':'',this._redraw()),this},t.prototype.button=function(t){for(var e=this._s.buttons,n=0;n<e.length;n++)if(e[n].value()===t)return e[n];return null},t.prototype.clear=function(){for(var t=0;t<this._s.buttons.length;t++)this._s.buttons[t].destroy();return this._dom.buttons.replaceChildren(),this._s.buttons.length=0,this},t.prototype.element=function(){return this._dom.container},t.prototype.handler=function(t){return this._s.handler=t,this},t.prototype.searchListener=function(t){var e=this;return t.on('cc-search-clear',function(t,n){n===e._s.host.idx()&&(e.selectNone(),e._s.handler(t,null,e._s.buttons,!1),e._s.search='',e._dom.search.value='',e._redraw(),e._updateCount())}),this},t.prototype.selectAll=function(){for(var t=0;t<this._s.buttons.length;t++)this._s.buttons[t].active(!0);return this},t.prototype.selectNone=function(){for(var t=0;t<this._s.buttons.length;t++)this._s.buttons[t].active(!1);return this},t.prototype.title=function(t){return this._dom.title.innerHTML=t,this},t.prototype.values=function(t){var e,n=[],r=this._s.buttons;if(void 0!==t){for(e=0;e<r.length;e++)t.includes(r[e].value())&&r[e].active(!0);return this._updateCount(),this}for(e=0;e<r.length;e++)r[e].active()&&n.push(r[e].value());return n},t.prototype._updateCount=function(){var t=this.values().length;this._dom.selectNoneCount.innerHTML=t?'('+t+')':''},t.prototype._redraw=function(){var t=this._s.buttons,e=this._dom.buttons,n=this._s.search.toLowerCase();e.replaceChildren();for(var r=0;r<t.length;r++){var o=t[r];n&&!o.text().toLowerCase().includes(n)||e.appendChild(o.element())}this._dom.empty.style.display=0===t.length?'block':'none',e.style.display=t.length>0?'block':'none'},t.classes={container:'dtcc-list',input:'dtcc-list-search'},t}(),y={defaults:{className:'colVis',columns:'',search:!1,select:!1,title:'Column visibility'},init:function(t){var e=this.dt(),n=new x(e,this,{search:t.search,select:t.select}).title(e.i18n('columnControl.colVis',t.title)).handler(function(t,e,n){e&&e.active(!e.active()),r(n)}),r=function(t){for(var n=0;n<t.length;n++){var r=t[n],o=r.value(),i=e.column(o);r.active()&&!i.visible()?i.visible(!0):!r.active()&&i.visible()&&i.visible(!1)}},o=function(){e.columns(t.columns).every(function(){n.add({active:this.visible(),label:this.title(),value:this.index()})})};return o(),e.on('column-visibility',function(t,e,r,o){var i=n.button(r);i&&i.active(o)}),e.on('columns-reordered',function(t,e){n.clear(),o()}),n.element()}},_={defaults:{className:'colVis',columns:'',search:!1,select:!1,text:'Column visibility',title:'Column visibility'},extend:function(t){return{extend:'dropdown',icon:'columns',text:this.dt().i18n('columnControl.colVisDropdown',t.text),content:[Object.assign(t,{extend:'colVis'})]}}},b={defaults:{className:'reorder',icon:'move',text:'Reorder columns'},init:function(t){var e=this,n=this.dt(),o=new v(n,this).text(n.i18n('columnControl.reorder',t.text)).icon(t.icon).className(t.className);return 0===this.idx()&&o.enable(!1),n.on('columns-reordered',function(t,n){o.enable(e.idx()>0)}),n.init().colReorder||new r.ColReorder(n,{}),o.element()}},g={defaults:{className:'reorderLeft',icon:'moveLeft',text:'Move column left'},init:function(t){var e=this,n=this.dt(),r=new v(n,this).text(n.i18n('columnControl.reorderLeft',t.text)).icon(t.icon).className(t.className).handler(function(){var t=e.idx();t>0&&n.colReorder.move(t,t-1)});return 0===this.idx()&&r.enable(!1),n.on('columns-reordered',function(t,n){r.enable(e.idx()>0)}),r.element()}},w={defaults:{className:'reorderRight',icon:'moveRight',text:'Move column right'},init:function(t){var e=this,n=this.dt(),r=new v(n,this).text(n.i18n('columnControl.reorderRight',t.text)).icon(t.icon).className(t.className).handler(function(){var t=e.idx();t<n.columns().count()-1&&n.colReorder.move(t,t+1)});return this.idx()===n.columns().count()-1&&r.enable(!1),n.on('columns-reordered',function(t,o){r.enable(e.idx()<n.columns().count()-1)}),r.element()}},C={defaults:{className:'order',iconAsc:'orderAsc',iconDesc:'orderDesc',iconNone:'orderNone',statusOnly:!1,text:'Toggle ordering'},init:function(t){var e=this,n=this.dt(),o=new v(n,this).text(n.i18n('columnControl.order',t.text)).icon('orderAsc').className(t.className);return t.statusOnly||n.order.listener(o.element(),r.versionCheck('2.3.2')?function(){return[e.idx()]}:this.idx(),function(){}),n.on('order',function(n,r,i){var s=i.find(function(t){return t.col===e.idx()});s?'asc'===s.dir?o.active(!0).icon(t.iconAsc):'desc'===s.dir&&o.active(!0).icon(t.iconDesc):o.active(!1).icon(t.iconNone)}),o.element()}},A={defaults:{className:'orderAddAsc',icon:'orderAddAsc',text:'Add Sort Ascending'},init:function(t){var e=this,n=this.dt(),r=new v(n,this).text(n.i18n('columnControl.orderAddAsc',t.text)).icon(t.icon).className(t.className).handler(function(){n.order().push([e.idx(),'asc']),n.draw()});return n.on('order',function(t,n,o){var i=o.some(function(t){return t.col===e.idx()});r.enable(!i)}),r.element()}},M={defaults:{className:'orderAddDesc',icon:'orderAddDesc',text:'Add Sort Descending'},init:function(t){var e=this,n=this.dt(),r=new v(n,this).text(n.i18n('columnControl.orderAddDesc',t.text)).icon(t.icon).className(t.className).handler(function(){n.order().push([e.idx(),'desc']),n.draw()});return n.on('order',function(t,n,o){var i=o.some(function(t){return t.col===e.idx()});r.enable(!i)}),r.element()}},L={defaults:{className:'orderAsc',icon:'orderAsc',text:'Sort Ascending'},init:function(t){var e=this,n=this.dt(),r=new v(n,this).text(n.i18n('columnControl.orderAsc',t.text)).icon(t.icon).className(t.className).handler(function(){e.dt().order([{idx:e.idx(),dir:'asc'}]).draw()});return n.on('order',function(t,n,o){var i=o.some(function(t){return t.col===e.idx()&&'asc'===t.dir});r.active(i)}),r.element()}},N={defaults:{className:'orderClear',icon:'orderClear',text:'Clear sort'},init:function(t){var e=this.dt(),n=new v(e,this).text(e.i18n('columnControl.orderClear',t.text)).icon(t.icon).className(t.className).handler(function(){e.order([]).draw()});return e.on('order',function(t,e,r){n.enable(r.length>0)}),0===e.order().length&&n.enable(!1),n.element()}},D={defaults:{className:'orderDesc',icon:'orderDesc',text:'Sort Descending'},init:function(t){var e=this,n=this.dt(),r=new v(n,this).text(n.i18n('columnControl.orderDesc',t.text)).icon(t.icon).className(t.className).handler(function(){e.dt().order([{idx:e.idx(),dir:'desc'}]).draw()});return n.on('order',function(t,n,o){var i=o.some(function(t){return t.col===e.idx()&&'desc'===t.dir});r.active(i)}),r.element()}},E={defaults:{className:'orderRemove',icon:'orderRemove',text:'Remove from sort'},init:function(t){var e=this,n=this.dt(),r=new v(n,this).text(n.i18n('columnControl.orderRemove',t.text)).icon(t.icon).className(t.className).handler(function(){var t=n.order(),r=t.findIndex(function(t){return t[0]===e.idx()});t.splice(r,1),n.order(t).draw()});return n.on('order',function(t,n,o){var i=o.some(function(t){return t.col===e.idx()});r.enable(i)}),r.enable(!1),r.element()}},S={defaults:{className:'order',iconAsc:'orderAsc',iconDesc:'orderDesc',iconNone:'orderNone',statusOnly:!0,text:'Sort status'},extend:function(t){return Object.assign(t,{extend:'order'})}};function q(t,e){var n=T(t);return-1===n.indexOf(e)&&(n.push(e),t.rowGroup().dataSrc(n)),n}function T(t){var e=t.rowGroup().dataSrc();return Array.isArray(e)?e:[e]}function k(t){t.rowGroup().dataSrc([])}function O(t,e){var n=T(t),r=n.indexOf(e);return-1!==r&&(n.splice(r,1),t.rowGroup().dataSrc(n)),n}var Y={defaults:{className:'rowGroup',icon:'groupTop',order:!0,text:'Group rows'},init:function(t){var e=this,n=this.dt(),r=new v(n,this).text(n.i18n('columnControl.rowGroup',t.text)).icon(t.icon).className(t.className).handler(function(){var o=n.column(e.idx()).dataSrc();r.active()?O(n,o):(k(n),q(n,o),!1!==t.order&&n.order([e.idx(),'asc'])),n.draw()});return n.on('rowgroup-datasrc',function(){var t=T(n),o=n.column(e.idx()).dataSrc();r.active(t.includes(o))}),r.element()}},j={defaults:{className:'rowGroupAdd',icon:'groupAdd',order:!0,text:'Add to grouping'},init:function(t){var e=this,n=this.dt(),r=new v(n,this).text(n.i18n('columnControl.rowGroup',t.text)).icon(t.icon).className(t.className).handler(function(){var t=n.column(e.idx()).dataSrc();r.enable()&&q(n,t),n.draw()});return n.on('rowgroup-datasrc',function(){var t=T(n),o=n.column(e.idx()).dataSrc();r.enable(!t.includes(o))}),r.element()}},R={defaults:{className:'rowGroupClear',icon:'groupClear',text:'Clear all grouping'},init:function(t){var e=this.dt(),n=new v(e,this).text(e.i18n('columnControl.rowGroup',t.text)).icon(t.icon).className(t.className).handler(function(){k(e),e.draw()});return e.on('rowgroup-datasrc',function(){n.enable(T(e).length>0)}),n.enable(T(e).length>0),n.element()}},H={defaults:{className:'rowGroupRemove',icon:'groupRemove',order:!0,text:'Remove from grouping'},init:function(t){var e=this,n=this.dt(),r=new v(n,this).text(n.i18n('columnControl.rowGroup',t.text)).icon(t.icon).className(t.className).handler(function(){var t=n.column(e.idx()).dataSrc();r.enable()&&(O(n,t),n.draw())});return n.on('rowgroup-datasrc',function(){var t=T(n),o=n.column(e.idx()).dataSrc();r.enable(t.includes(o))}),r.enable(!1),r.element()}},I=function(){function t(e,n){var r=this;this._type='text',this._sspTransform=null,this._sspData={},this._dt=e,this._idx=n,this._dom={clear:o('span','dtcc-search-clear',a.x),container:o('div',t.classes.container),typeIcon:o('div','dtcc-search-type-icon'),searchIcon:o('div','dtcc-search-icon',a.search),input:o('input',t.classes.input),inputs:o('div'),select:o('select',t.classes.select),title:o('div','dtcc-search-title')};var i=this._dom,s=n;i.input.setAttribute('type','text'),i.container.append(i.title,i.inputs),i.inputs.append(i.typeIcon,i.select,i.searchIcon,i.clear,i.input);var c=function(){r.runSearch()},l=function(){i.typeIcon.innerHTML=a[i.select.value],r.runSearch()},u=function(){r.clear()};i.input.addEventListener('input',c),i.select.addEventListener('input',l),i.clear.addEventListener('click',u),e.on('destroy',function(){i.input.removeEventListener('input',c),i.select.removeEventListener('input',l),i.clear.removeEventListener('click',u)}),e.on('stateSaveParams.DT',function(t,e,n){n.columnControl||(n.columnControl={}),n.columnControl[r._idx]||(n.columnControl[r._idx]={}),n.columnControl[r._idx].searchInput={logic:i.select.value,type:r._type,value:i.input.value}}),e.on('stateLoaded.DT',function(t,e,n){r._stateLoad(n)}),e.on('columns-reordered.DT',function(t,n){r._idx=e.colReorder.transpose(s,'fromOriginal')}),e.on('cc-search-clear.DT',function(t,e){e===r._idx&&(r._loadingState=!0,r.clear(),r._loadingState=!1)}),e.page.info().serverSide&&e.on('preXhr.DT',function(t,e,n){if(n.columns&&n.columns[r._idx]){n.columns[r._idx].columnControl||(n.columns[r._idx].columnControl={});var o=r._dom.input.value;r._sspTransform&&(o=r._sspTransform(o)),n.columns[r._idx].columnControl.search=Object.assign({value:o,logic:r._dom.select.value,type:r._type},r._sspData)}})}return t.prototype.addClass=function(t){return this._dom.container.classList.add(t),this},t.prototype.clear=function(){return this.set(this._dom.select.children[0].getAttribute('value'),''),this},t.prototype.clearable=function(t){return t||this._dom.clear.remove(),this},t.prototype.element=function(){return this._dom.container},t.prototype.input=function(){return this._dom.input},t.prototype.options=function(t){for(var e=this._dom.select,n=0;n<t.length;n++)e.add(new Option(t[n].label,t[n].value));return this._dom.typeIcon.innerHTML=a[t[0].value],this},t.prototype.placeholder=function(t){if(t){var e=this._dt.column(this._idx).title();this._dom.input.placeholder=t.replace('[title]',e)}return this},t.prototype.runSearch=function(){var t=this._dom,e='empty'===t.select.value||'notEmpty'===t.select.value||''!==t.input.value;t.container.classList.toggle('dtcc-search_active',e),!this._search||this._lastValue===t.input.value&&this._lastType===t.select.value||(this._search(t.select.value,t.input.value,this._loadingState),this._lastValue=t.input.value,this._lastType=t.select.value)},t.prototype.search=function(t){return this._search=t,this._stateLoad(this._dt.state.loaded()),this},t.prototype.set=function(t,e){var n=this._dom;return n.input.value=e,n.select.value=t,n.typeIcon.innerHTML=a[n.select.value],this.runSearch(),this},t.prototype.sspTransform=function(t){return this._sspTransform=t,this},t.prototype.sspData=function(t){return this._sspData=t,this},t.prototype.title=function(t){if(t){var e=this._dt.column(this._idx).title();this._dom.title.innerHTML=t.replace('[title]',e)}return this},t.prototype.titleAttr=function(t){if(t){var e=this._dt.column(this._idx).title();this._dom.input.title=t.replace('[title]',e)}return this},t.prototype.type=function(t){return this._type=t,this},t.prototype._stateLoad=function(t){var e,n,r=this._dom,o=this._idx,i=null===(n=null===(e=null==t?void 0:t.columnControl)||void 0===e?void 0:e[o])||void 0===n?void 0:n.searchInput;i&&(this._loadingState=!0,r.select.value=i.logic,r.input.value=i.value,r.select.dispatchEvent(new Event('input')),this._loadingState=!1)},t.classes={container:['dtcc-content','dtcc-search'],input:'',select:''},t}(),G={defaults:{clear:!0,format:'',mask:'',placeholder:'',title:'',titleAttr:''},init:function(t){var e,n=this,o=!1,i=r.use('moment'),s=r.use('luxon'),a=this.dt(),c='columnControl.search.datetime.',l='',u='',d=new I(a,this.idx()).type('date').addClass('dtcc-searchDateTime').sspTransform(function(t){return U(t,l,i,s)}).sspData({mask:t.mask}).clearable(t.clear).placeholder(t.placeholder).title(t.title).titleAttr(t.titleAttr).options([{label:a.i18n(c+'equal','Equals'),value:'equal'},{label:a.i18n(c+'notEqual','Does not equal'),value:'notEqual'},{label:a.i18n(c+'greater','After'),value:'greater'},{label:a.i18n(c+'less','Before'),value:'less'},{label:a.i18n(c+'empty','Empty'),value:'empty'},{label:a.i18n(c+'notEmpty','Not empty'),value:'notEmpty'}]).search(function(r,c,d){if(a.page.info().serverSide)d||a.draw();else{var h=t.mask,p=a.column(n.idx()),f=''===c?'':P(e&&o?e.val():c.trim(),l,i,s,h);if('empty'===r)p.search.fixed('dtcc',function(t){return!t});else if('notEmpty'===r)p.search.fixed('dtcc',function(t){return!!t});else{if(''===p.search.fixed('dtcc')&&''===f)return;f?'equal'===r?p.search.fixed('dtcc',function(t){return P(t,u,i,s,h)==f}):'notEqual'===r?p.search.fixed('dtcc',function(t){return P(t,u,i,s,h)!=f}):'greater'===r?p.search.fixed('dtcc',function(t){return P(t,u,i,s,h)>f}):'less'===r&&p.search.fixed('dtcc',function(t){return P(t,u,i,s,h)<f}):p.search.fixed('dtcc','')}t._parents&&t._parents.forEach(function(t){return t.activeList(n.unique(),!!p.search.fixed('dtcc'))}),d||p.draw()}});return a.ready(function(){var i=r.use('datetime');u=V(a,n.idx()),l=t.format?t.format:u,i&&(e=new i(d.input(),{format:l,i18n:a.settings()[0].oLanguage.datetime,onChange:function(){o=!0,d.runSearch(),o=!1}}))}),d.element()}};function V(t,e){var n=t.column(e).type();if(!n)return'YYYY-MM-DD';if('datetime'===n){var o=t.settings()[0].aoColumns[e].mRender,i=o('1999-08-07T23:05:04Z','display'),s=o('1999-08-07T03:05:04Z','display').includes('03');if(r.use('moment'))return i.replace('23',s?'HH':'H').replace('11',s?'hh':'h').replace('05','mm').replace('04','ss').replace('PM','A').replace('pm','a').replace('07','DD').replace('7','D').replace('08','MM').replace('8','M').replace('1999','YYYY').replace('99','YY');if(r.use('luxon'))return i.replace('23',s?'HH':'H').replace('11',s?'hh':'h').replace('05','mm').replace('04','ss').replace('PM','a').replace('07','dd').replace('7','d').replace('08','MM').replace('8','M').replace('1999','yyyy').replace('99','yy');if(i.includes('23')&&i.includes('1999'))return'YYYY-MM-DD hh:mm:ss';if(i.includes('23'))return'hh:mm:ss'}else{if(n.includes('datetime-'))return n.replace(/datetime-/g,'');if(n.includes('moment'))return n.replace(/moment-/g,'');if(n.includes('luxon'))return n.replace(/luxon-/g,'')}return'YYYY-MM-DD'}function P(t,e,n,r,o){var i;return''===t?'':(i=t instanceof Date?t:'YYYY-MM-DD'!==e&&(n||r)?new Date(n?1e3*n(t,e).unix():r.DateTime.fromFormat(t,e).toMillis()):new Date(t.replace(/\//g,'-')),o&&(o.includes('YYYY')||i.setFullYear(1970),o.includes('MM')||i.setUTCMonth(0),o.includes('DD')||i.setUTCDate(1),o.includes('hh')||i.setUTCHours(0),o.includes('mm')||i.setUTCMinutes(0),o.includes('ss')||i.setUTCSeconds(0),o.includes('sss')||i.setUTCMilliseconds(0)),i.getTime())}function U(t,e,n,r){return''===t?'':'YYYY-MM-DD'!==e&&n?n.utc(t,e).toISOString():'YYYY-MM-DD'!==e&&r?r.DateTime.fromFormat(t,e).toISO():t=t.replace(/\//g,'-')}function W(t,e){var n=t.values();t.clear();for(var r=0;r<e.length;r++)'object'==typeof e[r]?t.add({active:!1,label:e[r].label,value:e[r].value},r===e.length-1):t.add({active:!1,label:e[r],value:e[r]},r===e.length-1);n.length&&t.values(n)}function B(t,e){var n,r,o=null===(r=null===(n=null==e?void 0:e.columnControl)||void 0===n?void 0:n[t])||void 0===r?void 0:r.searchList;if(o)return o}function z(t,e){var n,r=null===(n=t.ajax.json())||void 0===n?void 0:n.columnControl,o=t.column(e),i=o.name(),s=o.dataSrc();return r&&r[i]?r[i]:r&&'string'==typeof s&&r[s]?r[s]:r&&r[e]?r[e]:null}function F(t,e,n,r,o){var i,s=null===(i=t.ajax.json())||void 0===i?void 0:i.columnControl,a=[],c=z(t,n);if(c)a=c;else{if(s&&e.ajaxOnly)return void(e.hidable&&(r.element().style.display='none',e._parents&&e._parents.forEach(function(t){return t.checkDisplay()})));if(!t.page.info().serverSide)for(var l={},u=t.rows({order:n}).indexes().toArray(),d=t.settings()[0],h=0;h<u.length;h++){var p=d.fastData(u[h],n,'filter'),f=null!=p?p.toString():'';l[f]||(l[f]=!0,a.push({label:d.fastData(u[h],n,e.orthogonal),value:f}))}}W(r,a),o&&r.values(o)}var X={defaults:{ajaxOnly:!0,className:'searchList',hidable:!0,options:null,orthogonal:'display',search:!0,select:!0,title:''},init:function(t){var e=this,n=null,r=this.dt(),o=function(n){if(!r.page.info().serverSide){var o=r.column(e.idx());n&&(0===n.length?o.search.fixed('dtcc-list',''):o.search.fixed('dtcc-list',function(t){return n.includes(t)}),t._parents&&t._parents.forEach(function(t){return t.activeList(e.unique(),!!n.length)}))}},i=new x(r,this,{search:t.search,select:t.select}).searchListener(r).title(r.i18n('columnControl.searchList',t.title).replace('[title]',r.column(this.idx()).title())).handler(function(t,e,n,s){e&&e.active(!e.active()),o(i.values()),s&&r.draw()});return t.options?W(i,t.options):(r.ready(function(){F(r,t,e.idx(),i,n)}),r.on('xhr',function(o,s,a){r.one('draw',function(){F(r,t,e.idx(),i,n)})})),r.page.info().serverSide&&r.on('preXhr.DT',function(t,n,r){r.columns&&r.columns[e.idx()]&&(r.columns[e.idx()].columnControl||(r.columns[e.idx()].columnControl={}),r.columns[e.idx()].columnControl.list=Object.assign({},i.values()))}),r.on('stateLoaded',function(t,n,r){var s=B(e.idx(),r);s&&(i.values(s),o(s))}),r.on('stateSaveParams',function(t,o,s){var a=e.idx();s.columnControl||(s.columnControl={}),s.columnControl[a]||(s.columnControl[a]={}),s.columnControl[a].searchList=r.ready()?i.values():n}),r.settings()[0].aoColumns[this.idx()].columnControlSearchList=function(n){'refresh'===n?F(r,t,e.idx(),i,null):W(i,n)},n=B(this.idx(),r.state.loaded()),o(n),i.element()}},Z={defaults:{clear:!0,placeholder:'',title:'',titleAttr:''},init:function(t){var e=this,n=this.dt(),r='columnControl.search.number.',o=new I(n,this.idx()).type('num').addClass('dtcc-searchNumber').clearable(t.clear).placeholder(t.placeholder).title(t.title).titleAttr(t.titleAttr).options([{label:n.i18n(r+'equal','Equals'),value:'equal'},{label:n.i18n(r+'notEqual','Does not equal'),value:'notEqual'},{label:n.i18n(r+'greater','Greater than'),value:'greater'},{label:n.i18n(r+'greaterOrEqual','Greater or equal'),value:'greaterOrEqual'},{label:n.i18n(r+'less','Less than'),value:'less'},{label:n.i18n(r+'lessOrEqual','Less or equal'),value:'lessOrEqual'},{label:n.i18n(r+'empty','Empty'),value:'empty'},{label:n.i18n(r+'notEmpty','Not empty'),value:'notEmpty'}]).search(function(r,o,i){if(n.page.info().serverSide)i||n.draw();else{var s=n.column(e.idx());if('empty'===r)s.search.fixed('dtcc',function(t){return!t});else if('notEmpty'===r)s.search.fixed('dtcc',function(t){return!!t});else{if(''===s.search.fixed('dtcc')&&''===o)return;''===o?s.search.fixed('dtcc',''):'equal'===r?s.search.fixed('dtcc',function(t){return $(t)==o}):'notEqual'===r?s.search.fixed('dtcc',function(t){return $(t)!=o}):'greater'===r?s.search.fixed('dtcc',function(t){return $(t)>o}):'greaterOrEqual'===r?s.search.fixed('dtcc',function(t){return $(t)>=o}):'less'===r?s.search.fixed('dtcc',function(t){return $(t)<o}):'lessOrEqual'===r&&s.search.fixed('dtcc',function(t){return $(t)<=o})}t._parents&&t._parents.forEach(function(t){return t.activeList(e.unique(),!!s.search.fixed('dtcc'))}),i||s.draw()}});return o.input().setAttribute('inputmode','numeric'),o.input().setAttribute('pattern','[0-9]*'),o.element()}},K=/<([^>]*>)/g,Q=/['\u00A0,$£€¥%\u2009\u202F\u20BD\u20a9\u20BArfkɃΞ]/gi;function $(t){if(0!==t&&(!t||'-'===t))return-1/0;var e=typeof t;return'number'===e||'bigint'===e?t:(t.replace&&(t=t.replace(K,'').replace(Q,'')),1*t)}var J={defaults:{clear:!0,placeholder:'',title:'',titleAttr:''},init:function(t){var e=this,n=this.dt(),r='columnControl.search.text.';return new I(n,this.idx()).addClass('dtcc-searchText').clearable(t.clear).placeholder(t.placeholder).title(t.title).titleAttr(t.titleAttr).options([{label:n.i18n(r+'contains','Contains'),value:'contains'},{label:n.i18n(r+'notContains','Does not contain'),value:'notContains'},{label:n.i18n(r+'equal','Equals'),value:'equal'},{label:n.i18n(r+'notEqual','Does not equal'),value:'notEqual'},{label:n.i18n(r+'starts','Starts'),value:'starts'},{label:n.i18n(r+'ends','Ends'),value:'ends'},{label:n.i18n(r+'empty','Empty'),value:'empty'},{label:n.i18n(r+'notEmpty','Not empty'),value:'notEmpty'}]).search(function(r,o,i){if(n.page.info().serverSide)i||n.draw();else{var s=n.column(e.idx());if(o=o.toLowerCase(),'empty'===r)s.search.fixed('dtcc',function(t){return!t});else if('notEmpty'===r)s.search.fixed('dtcc',function(t){return!!t});else{if(''===s.search.fixed('dtcc')&&''===o)return;''===o?s.search.fixed('dtcc',''):'equal'===r?s.search.fixed('dtcc',function(t){return t.toLowerCase()==o}):'notEqual'===r?s.search.fixed('dtcc',function(t){return t.toLowerCase()!=o}):'contains'===r?s.search.fixed('dtcc',o):'notContains'===r?s.search.fixed('dtcc',function(t){return!t.toLowerCase().includes(o)}):'starts'===r?s.search.fixed('dtcc',function(t){return t.toLowerCase().startsWith(o)}):'ends'===r&&s.search.fixed('dtcc',function(t){return t.toLowerCase().endsWith(o)})}t._parents&&t._parents.forEach(function(t){return t.activeList(e.unique(),!!s.search.fixed('dtcc'))}),i||s.draw()}}).element()}},tt={defaults:{className:'searchClear',icon:'searchClear',text:'Clear Search'},init:function(t){var e=this,n=this.dt(),r=new v(n,this).text(n.i18n('columnControl.searchClear',t.text)).icon(t.icon).className(t.className).handler(function(){n.column(e.idx()).columnControl.searchClear().draw()}).enable(!1);return n.on('draw',function(){var t=n.column(e.idx()).search.fixed('dtcc'),o=n.column(e.idx()).search.fixed('dtcc-list');r.enable(!(!t&&!o))}),r.element()}},et={colVis:y,colVisDropdown:_,dropdown:f,reorder:b,reorderLeft:g,reorderRight:w,rowGroup:Y,rowGroupAdd:j,rowGroupClear:R,rowGroupRemove:H,order:C,orderAddAsc:A,orderAddDesc:M,orderAsc:L,orderClear:N,orderDesc:D,orderRemove:E,orderStatus:S,search:{defaults:{allowSearchList:!1},init:function(t){var e,r,o,i,s=this,a=this.dt(),c=this.idx(),l=null===(o=null===(r=null===(e=a.state.loaded())||void 0===e?void 0:e.columnControl)||void 0===r?void 0:r[c])||void 0===o?void 0:o.searchInput,u=function(e){var n=z(a,c);return t.allowSearchList&&n?X.init.call(s,Object.assign({},X.defaults,t)):'date'===e||e.startsWith('datetime')?G.init.call(s,Object.assign({},G.defaults,t)):e.includes('num')?Z.init.call(s,Object.assign({},Z.defaults,t)):J.init.call(s,Object.assign({},J.defaults,t))};return l?i=u(l.type):(i=n.createElement('div'),a.ready(function(){var t=a.column(c),e=u(t.type());i.replaceWith(e)})),i}},searchClear:tt,searchDropdown:{defaults:{ajaxOnly:!0,allowSearchList:!0,className:'searchDropdown',clear:!0,columns:'',hidable:!0,options:null,orthogonal:'display',placeholder:'',search:!0,select:!0,text:'Search',title:'',titleAttr:''},extend:function(t){return{extend:'dropdown',icon:'search',text:this.dt().i18n('columnControl.searchDropdown',t.text),content:[Object.assign(t,{extend:'search'})]}}},searchDateTime:G,searchList:X,searchNumber:Z,searchText:J,spacer:{defaults:{className:'dtcc-spacer',text:''},init:function(t){var e=this.dt(),n=o('div',t.className,e.i18n('columnControl.spacer',t.text));return n.setAttribute('role','separator'),n}},title:{defaults:{className:'dtcc-title',text:null},init:function(t){var e=this.dt().column(this.idx()).title(),n=null===t.text?'[title]':t.text;return o('div',t.className,n.replace('[title]',e))}}},nt=function(){function t(e,r,o){var s=this;this._dom={target:null,wrapper:null},this._c={},this._s={columnIdx:null,unique:null,toDestroy:[]},this._dt=e,this._s.columnIdx=r,this._s.unique=Math.random();var a=r;Object.assign(this._c,t.defaults,o),this._dom.target=this._target(),o.className&&i(this._dom.target.closest('tr'),o.className),this._c.content&&(e.on('columns-reordered',function(t,n){s._s.columnIdx=e.colReorder.transpose(a,'fromOriginal')}),this._dom.wrapper=n.createElement('span'),this._dom.wrapper.classList.add('dtcc'),this._dom.target.appendChild(this._dom.wrapper),this._c.content.forEach(function(t){var e=s.resolve(t),n=e.plugin,r=e.config,o=n.init.call(s,r);s._dom.wrapper.appendChild(o)}),e.on('destroy',function(){s._s.toDestroy.slice().forEach(function(t){t.destroy()}),s._dom.wrapper.remove()}))}return t.prototype.destroyAdd=function(t){this._s.toDestroy.push(t)},t.prototype.destroyRemove=function(t){var e=this._s.toDestroy.indexOf(t);-1!==e&&this._s.toDestroy.splice(e,1)},t.prototype.dt=function(){return this._dt},t.prototype.idx=function(){return this._s.columnIdx},t.prototype.resolve=function(e){var n=null,r=null,o=null;if('string'==typeof e?(o=e,n=t.content[o],r=Object.assign({},null==n?void 0:n.defaults)):Array.isArray(e)?(o='dropdown',n=t.content[o],r=Object.assign({},null==n?void 0:n.defaults,{content:e})):e.extend&&(o=e.extend,n=t.content[o],r=Object.assign({},null==n?void 0:n.defaults,e)),!n)throw new Error('Unknown ColumnControl content type: '+o);if(n.extend){var i=n.extend.call(this,r);return this.resolve(i)}return{config:r,type:o,plugin:n}},t.prototype.unique=function(){return this._s.unique},t.prototype._target=function(){var t,e=this._c.target,n=this._dt.column(this._s.columnIdx),r='header';if('number'==typeof e)t=n.header(e);else{var o=e.split(':'),i='tfoot'!==o[0],s=o[1]?parseInt(o[1]):0;i?t=n.header(s):(t=n.footer(s),r='footer')}return t.querySelector('div.dt-column-'+r)},t.Button=v,t.CheckList=x,t.SearchInput=I,t.content=et,t.defaults={className:'',content:null,target:0},t.icons=a,t.version='1.1.1',t}();function rt(){var t=this;return this.iterator('column',function(e,n){t.trigger('cc-search-clear',[n])})}function ot(t,e,n){if(!t[e]){var r=!0,i=0;if('number'==typeof e)i=e;else{var s=e.split(':');'tfoot'===s[0]&&(r=!1),s[1]&&(i=parseInt(s[1]))}var a=r?n.table().header():n.table().footer();if(!a.querySelectorAll('tr')[i]){var c=n.columns().count(),l=o('tr');l.setAttribute('data-dt-order','disable');for(var u=0;u<c;u++)l.appendChild(o('td'));a.appendChild(l)}t[e]=!0}}function it(t,e){var n=nt.defaults.target;if(ct(e)){if(n===t)return{target:n,content:e}}else if(Array.isArray(e))for(var r=0;r<e.length;r++){var o=e[r];if(ct(o)){if(n===t)return{target:n,content:o}}else if(at(o)){if(t===(void 0!==o.target?o.target:n))return o}else if(t===n)return{target:n,content:e}}else if('object'==typeof e)if(at(e)){if(t===(void 0!==e.target?e.target:n))return e}else if(t===n)return{target:n,content:e}}function st(t,e){function n(e){t.includes(e)||t.push(e)}return Array.isArray(e)?0===e.length?n(nt.defaults.target):e.forEach(function(t){n('object'==typeof t&&void 0!==t.target?t.target:nt.defaults.target)}):'object'==typeof e&&n(void 0!==e.target?e.target:nt.defaults.target),t}function at(t){return'object'==typeof t&&void 0!==t.target}function ct(t){var e=!1;if(!Array.isArray(t))return!1;for(var n=0;n<t.length;n++)if(at(t[n])){e=!0;break}return!e}return r.ColumnControl=nt,t(n).on('i18n.dt',function(t,e){if('dt'===t.namespace){var n=new r.Api(e),o=n.table().header(),i=e.oInit.columnControl,s=nt.defaults,a=[],c={};o.querySelectorAll('tr').length<=1&&null===e.titleRow&&(e.titleRow=0),st(a,i),nt.defaults.content&&st(a,s),n.columns().every(function(t){var e=this.init().columnControl;st(a,e)});for(var l=0;l<a.length;l++)ot(c,a[l],n)}}),t(n).on('preInit.dt',function(t,e){if('dt'===t.namespace){var n=new r.Api(e),o=e.oInit.columnControl,i=nt.defaults,s=[];st(s,o),nt.defaults.content&&st(s,i),n.columns().every(function(t){for(var e=this.init().columnControl,r=st(s.slice(),e),a=0;a<r.length;a++){var c=it(r[a],e),l=it(r[a],o),u=it(r[a],i);(u||l||c)&&new nt(n,this.index(),Object.assign({},u||{},l||{},c||{}))}})}}),r.Api.registerPlural('columns().columnControl.searchClear()','column().columnControl.searchClear()',rt),r.Api.registerPlural('columns().ccSearchClear()','column().ccSearchClear()',rt),r.Api.registerPlural('columns().columnControl.searchList()','column().columnControl.searchList()',function(t){return this.iterator('column',function(e,n){var r=e.aoColumns[n].columnControlSearchList;r&&r(t)})}),r.ext.buttons.ccSearchClear={text:function(t){return t.i18n('columnControl.buttons.searchClear','Clear search')},init:function(t,e,n){var r=this;t.on('draw.DT',function(){var e=!1,n=!!t.search();n||t.columns().every(function(){(this.search.fixed('dtcc')||this.search.fixed('dtcc-list'))&&(e=!0)}),r.enable(n||e)}),this.enable(!1)},action:function(t,e,n,r){e.search(''),e.columns().columnControl.searchClear(),e.draw()}},r});
//# sourceMappingURL=dataTables.columnControl.min.js.map