# cognite_toolkit

This directory contains the configuration files for CDF project cognite_toolkit.

Check all the files in this directory into Git.

Overview of this directory:

```bash
📦cognite_toolkit
 ┣ 📂cognite_modules - Root folder for modules delivered by Cognite.
 ┃ ┗ 📜_system.yaml - DO NOT EDIT THIS FILE. This file is used by the toolkit to store information about the modules.
 ┣ 📂custom_modules - Put your own modules here.
 ┣ 📜.env.templ - (Optional) Rename to .env and set variables to set environment variables for the toolkit.
 ┣ 📜.gitignore - Ignore files that should not be checked into Git.
 ┣ 📜config.dev.yaml - Variables and deployment information for the dev environment.
 ┣ 📜config.prod.yaml - Variables and deployment information for the prod environment.
 ┗ 📜README.md - This file
```

## Root Modules

There are two root folders for modules, `cognite_modules` are modules that are
delivered by Cognite and `custom_modules` were you can put your own modules.

Typically, you can copy modules from `cognite_modules` to `custom_modules` and
modify them to your needs. You can also create your own modules from scratch.

## Configuration Files

You have one `config.[env].yaml` file per environment, i.e., CDF project. This files
contains information about which modules to deploy in each environment, and which
variables to use. If you have more than environments than `dev` and `prod`, you can
add more `config.[env].yaml` files, for example, `config.test.yaml`.

The `config.[env].yaml` file has two main sections, `environment` and `modules`.
The `environment` have the following fields:

- `name` - The name of the environment, for example, `dev` or `prod`.
- `project` - The name of the CDF project.
- `type` - The type of environment, for example, `dev` or `prod`. When type is
  `prod` the toolkit is stricter and will for example require that `project`
  match the `CDF_PROJECT` environment variable.
- `selected_modules_and_packages` - A list of modules to deploy in this environment.
  You can see the list of packages in `cognite_modules/_system.yaml`. Note
  packages are a collection of modules.
- `common_function_code` - The path to where common code for functions can be found.

The `modules` section contains the variables for each module. The variables
are hierarchically structured:

```yaml
modules:
  cognite_modules:
    cdf_cluster: ${CDF_CLUSTER}
    common:
      cdf_auth_readwrite_all:
        readwrite_source_id: <change_me>
    core:
      cdf_apm_base:
        apm_datamodel_space: APM_SourceData
  custom_modules:
    local:
      my_module:
        my_variable: <change_me>
```

In the example above, there are three variables `cdf_cluster`, `readwrite_source_id`,
and `apm_datamodel_space`. The variables `readwrite_source_id` and `apm_datamodel_space` are
only available in the modules they are defined, `cdf_auth_readwrite_all` and `cdf_apm_base`,
respectively. The variable `cdf_cluster` is available in all modules in the `cognite_modules`
Note that variables are identified as the leaf in the tree structure, and modules
as the level above.

If we move the `cdf_cluster` variable up one level, it will also be available in the `custom_modules`:

```yaml
modules:
  cdf_cluster: ${CDF_CLUSTER}
  cognite_modules:
    ...
  custom_modules:
    ...
```

## Upgrading Modules

You can do `cdf-tk init --upgrade` in this directory to upgrade all the `cdf_*` modules to the
latest version. Your `config.[yaml].yaml` will be updated with new variables and modules
will be added if they are missing.

Use this file to document your configuration files!
