# Generated by Django 5.0.6 on 2024-06-25 12:48

import django.db.models.deletion
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='WikiSpace',
            fields=[
                ('spaceid', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.SlugField(default='')),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'Wiki Space',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='HistoricalWikiSpace',
            fields=[
                ('spaceid', models.IntegerField(blank=True, db_index=True)),
                ('name', models.SlugField(default='')),
                ('description', models.TextField(blank=True, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField(db_index=True)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical Wiki Space',
                'verbose_name_plural': 'historical Wiki Spaces',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='WikiPage',
            fields=[
                ('name', models.CharField(max_length=255, primary_key=True, serialize=False, verbose_name='Page Name')),
                ('content', models.TextField(verbose_name='Page Content')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('edit_reason', models.CharField(default='Created', max_length=256, verbose_name='Reason for Edit')),
                ('space', models.ForeignKey(default=1, on_delete=django.db.models.deletion.PROTECT, to='wikiwikiweb.wikispace')),
            ],
            options={
                'verbose_name': 'Wiki Page',
            },
        ),
        migrations.CreateModel(
            name='HistoricalWikiPage',
            fields=[
                ('name', models.CharField(db_index=True, max_length=255, verbose_name='Page Name')),
                ('content', models.TextField(verbose_name='Page Content')),
                ('created', models.DateTimeField(blank=True, editable=False)),
                ('updated', models.DateTimeField(blank=True, editable=False)),
                ('edit_reason', models.CharField(default='Created', max_length=256, verbose_name='Reason for Edit')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField(db_index=True)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('space', models.ForeignKey(blank=True, db_constraint=False, default=1, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='wikiwikiweb.wikispace')),
            ],
            options={
                'verbose_name': 'historical Wiki Page',
                'verbose_name_plural': 'historical Wiki Pages',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
