import uuid
import stix2
import os
import shutil

from uuid import UUID

from stix2extensions.exploit import Exploit
# create the directories

tmp_directories = [
    "tmp_object_store",
]

for directory in tmp_directories:
    if not os.path.exists(directory):
        os.makedirs(directory)

# define UUID for generating UUIDv5s -- use stix2extensions namespace as this is an SDO

namespace=UUID("1abb62b9-e513-5f55-8e73-8f6d7b55c237")

# define values that are recycled between objects

### dogesec-demo

created_by_ref="identity--" + str(uuid.uuid5(namespace, f"dogesec-demo"))
created="2020-01-01T00:00:00.000Z"
modified="2020-01-01T00:00:00.000Z"

# Create Exploit SDO object

### exploit--519a9c84-3c54-5698-bd9a-99bd01f003d1

example_ExploitSDO = Exploit(
                        id="exploit--"+ str(uuid.uuid5(namespace, f"A demo exploit")),
                        created_by_ref=created_by_ref,
                        created=created,
                        modified=modified,
                        name="Exploit Demo",
                        description="A demo exploit",
                        vulnerability_ref="vulnerability--c5dcf0f3-4afe-4458-b79b-0b3e671db8ed",
                        exploit_type="client-side",
                        proof_of_concept="git@github.com:dogesec/CVE-0000-00000-Proof-Of-Concept.git",
                        external_references=[
                            {
                                "source_name": "cve",
                                "external_id": "CVE-0000-00000",
                                "url": "https://nvd.nist.gov/vuln/detail/CVE-0000-00000"
                            }
                        ],
                        object_marking_refs=[
                            "marking-definition--94868c89-83c2-464b-929b-a1a8aa3c8487", # this is TLP:CLEAR
                            "marking-definition--" + str(uuid.uuid5(namespace, f"stix2extensions")) # marking-definition--97ba4e8b-04f6-57e8-8f6e-3a0f0a7dc0fb
                        ]
                    )

# Write the objects to the filestore
## https://stix2.readthedocs.io/en/latest/guide/filesystem.html#FileSystemSource

### Creating FileSystemStore and adding MarkingDefinitionSMO for each directory

fs_directories = {
    "tmp_object_store": example_ExploitSDO
}

for directory, exploit_sdo in fs_directories.items():
    fs_store = stix2.FileSystemStore(directory)
    fs_store.add([exploit_sdo])

# Now move those files into the standardised locations for easy download

final_directories = [
    "example_objects/sdos"
]

for directory in final_directories:
    if not os.path.exists(directory):
        os.makedirs(directory)

shutil.move("tmp_object_store/exploit/exploit--" + str(uuid.uuid5(namespace, f"A demo exploit")) + "/20200101000000000.json", "example_objects/sdos/exploit--" + str(uuid.uuid5(namespace, f"A demo exploit")) + ".json")

shutil.rmtree("tmp_object_store")