# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_daisy.ipynb.

# %% auto 0
__all__ = ['AlertT', 'Alert', 'StepsT', 'StepT', 'Steps', 'LiStep', 'LoadingT', 'Loading', 'ToastHT', 'ToastVT', 'Toast']

# %% ../nbs/03_daisy.ipynb
import fasthtml.common as fh
from .foundations import *
from fasthtml.common import Div, Span, FT
from fasthtml.svg import *
from enum import auto
from fastcore.all import *


# %% ../nbs/03_daisy.ipynb
class AlertT(VEnum):
    "Alert styles from DaisyUI"
    def _generate_next_value_(name, start, count, last_values): return f"alert-{name}"
    info = auto()
    success = auto()
    warning = auto()
    error = auto()

# %% ../nbs/03_daisy.ipynb
def Alert(*c, # Content for Alert (often text and/or icon)
          cls='',  # Class for the alert (often an `AlertT` option)
          **kwargs # Additional arguments for outer Div
         )->FT: # Div(Span(...), cls='alert', role='alert')
    "Alert informs users about important events."
    return Div(Span(*c), cls=('alert', stringify(cls)), role='alert', **kwargs)

# %% ../nbs/03_daisy.ipynb
class StepsT(VEnum):
    "Options for Steps"
    def _generate_next_value_(name, start, count, last_values): return f'steps-{name}'
    vertical = auto()
    horizonal = auto()

# %% ../nbs/03_daisy.ipynb
class StepT(VEnum):
    'Step styles for LiStep'
    def _generate_next_value_(name, start, count, last_values): return f'step-{name}'
    primary = auto()
    secondary = auto()
    accent = auto() 
    info = auto()
    success = auto()
    warning = auto()
    error = auto()
    neutral = auto()

# %% ../nbs/03_daisy.ipynb
def Steps(*li, # Each `Li` represent a step (generally use `LiStep`)
          cls='', # class for Steps (generally a `StepsT` option)
          **kwargs # Additional args for outer wrapper (`Ul` component)
         )->FT: # Ul(..., cls='steps')
    "Creates a steps container"
    return Ul(*li, cls=('steps',stringify(cls)), **kwargs)

def LiStep(*c, # Description for Step that goes next to bubble (often text)
           cls='', # Additional step classes (generally a `StepT` component)
           data_content=None, # Content for inside bubble (defaults to number, often an emoji)
           **kwargs # Aditional arguments for the step (`Li` component)
          )->FT: # Li(..., cls='step')
    "Creates a step list item"
    return Li(*c, cls=('step', stringify(cls)), data_content=data_content, **kwargs)

# %% ../nbs/03_daisy.ipynb
class LoadingT(VEnum):
    def _generate_next_value_(name, start, count, last_values): return f'loading-{name}'
    spinner = auto()
    dots = auto()
    ring = auto()
    ball = auto()
    bars = auto()
    infinity = auto()
    
    xs = 'loading-xsmall'
    sm = 'loading-small'
    md = 'loading-medium'
    lg = 'loading-large'

# %% ../nbs/03_daisy.ipynb
def Loading(cls=(LoadingT.bars, LoadingT.lg), # Classes for indicator (generally `LoadingT` options)
            htmx_indicator=False, # Add htmx-indicator class
            **kwargs # additional args for outer conainter (`Span`)
           )->FT: # Span(cls=...)
    "Creates a loading animation component"
    classes = ['loading', stringify(cls)]
    if htmx_indicator: classes.append('htmx-indicator')
    return Span(cls=classes, **kwargs)

# %% ../nbs/03_daisy.ipynb
class ToastHT(VEnum):
    "Horizontal position for Toast"
    def _generate_next_value_(name, start, count, last_values): return f'toast-{name}'
    start = auto()
    center = auto()
    end = auto()

class ToastVT(VEnum):
    "Vertical position for Toast"
    def _generate_next_value_(name, start, count, last_values): return f'toast-{name}'
    top = auto()
    middle = auto()
    bottom = auto()

# %% ../nbs/03_daisy.ipynb
def Toast(*c, # Content for toast (often test)
          cls='', # Classes for toast (often `ToastHT` and `ToastVT` options)
          alert_cls='', # classes for altert (often `AlertT` options)
          dur=5.0, # no. of seconds before the toast disappears
          **kwargs # Additional args for outer container (`Div` tag)
         )->FT: # Div(Alert(...), cls='toast')
    "Toasts are stacked announcements, positioned on the corner of page."
    a = Alert(*c, cls=alert_cls)
    _id = fh.unqid()
    js = '''(() => setTimeout(() => document.querySelector('[data-mui="%s"]').remove(),%s))()'''%(_id,dur*1000)
    return Div(a, NotStr(f"<script>{js}</script>"), data_mui=_id, cls=('toast', stringify(cls)), **kwargs)
