# Examples (selective only):

ToolMate AI Plugins allow you to acheive variety of tasks with simple words:

* generate tweets

> Post a short tweet about LetMeDoIt AI

* analyze audio

> transcribe "meeting_records.mp3"

* search / analyze financial data

> What was the average stock price of Apple Inc. in 2023?

> Analyze Apple Inc's stock price over last 5 years.

* search weather information

> what is the current weather in New York?

* search news

> tell me the latest news about ChatGPT

* search old conversations

> search for "joke" in chat records

* load old conversations

> load chat records with this ID: 2024-01-20_19_21_04

* connect a sqlite file and fetch data or make changes

> connect /temp/my_database.sqlite and tell me about the tables that it contains

* integrated Google PaLM 2 multiturn chat, e.g.

> ask PaLM 2 to write an article about Google

* integrated Google Codey multiturn chat, e.g.

> ask Codey how to use decorators in python

* execute python codes with auto-healing feature and risk assessment, e.g.

> join "01.mp3" and "02.mp3" into a single file

* execute system commands to achieve specific tasks, e.g.

> Launch VLC player and play music in folder "music_folder"

* manipulate files, e.g.

> remove all desktop files with names starting with "Screenshot"

> zip "folder1"

* save memory, e.g.

> Remember, my birthday is January 1st.

* send Whatsapp messages, e.g.

> send Whatsapp message "come to office 9am tomorrow" to "staff" group

* retrieve memory, e.g.

> When is my birthday?

* search for online information when LM lacks information, e.g.

> Tell me somtheing about ToolMate AI?

* add google or outlook calendar events, e.g.

> I am going to London on Friday. Add it to my outlook calendar

* send google or outlook emails, e.g.

> Email an appreciation letter to someone@someone.com

* analyze files, e.g.

> Summarize 'Hello_World.docx'

* analyze web content, e.g.

> Give me a summary on https://assets.publishing.service.gov.uk/government/uploads/system/uploads/attachment_data/file/1171397/CC3_feb20.pdf 

* analyze images, e.g.

> Describe the image 'Hello.png' in detail

> Compare images insider folder 'images'

* remove image background, e.g.

> Remove image background of "my_photo.png"

* create qrcode, e.g.

> Create a QR code for the website: https://letmedoit.ai

* create maps, e.g.

> Show me a map with Hype Park Corner and Victoria stations pinned

* create statistical graphics, e.g.

> Create a bar chart that illustrates the correlation between each of the 12 months and their respective number of days

> Create a pie chart: Mary £10, Peter £8, John £15

* solve queries about dates and times, e.g.

> What is the current time in Hong Kong?

* solve math problem, e.g.

> You have a standard deck of 52 playing cards, which is composed of 4 suits: hearts, diamonds, clubs, and spades. Each suit has 13 cards: Ace through 10, and the face cards Jack, Queen, and King. If you draw 5 cards from the deck, in how many ways can you draw exactly 3 cards of one suit and exactly 2 cards of another suit?  

* pronounce words in different dialects, e.g.

> read tomato in American English

> read tomato in British English

> read 中文 in Mandarin

> read 中文 in Cantonese

* download Youtube video files, e.g.

> Download https://www.youtube.com/watch?v=CDdvReNKKuk

* download Youtube audio files and convert them into mp3 format, e.g.

> Download https://www.youtube.com/watch?v=CDdvReNKKuk and convert it into mp3

* edit text with built-in or custom text editors, e.g.

> Edit README.md

* improve language skills, e.g. British English trainer, e.g.

> Improve my writing according to British English style

* convert text display, e.g. from simplified Chinese to traditional Chinese, e.g.

> Translate your last response into Chinese

* create images, e.g.

> Create an app icon for "LetMeDoIt AI"

* modify images, e.g.

> Make a cartoon verion of image "my_photo.png"

## Fetures with OpenAI API key ONLY

Currently, the following features work only with a valid OpenAI API key

* create ai assistants based on the requested task, e.g.

> create a team of AI assistants to write a Christmas drama

> create a team of AI assistants to build a scalable and customisable python application to remove image noise
