# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .config_values import ConfigValues
from .source_connection_auth_fields import SourceConnectionAuthFields
from .source_connection_status import SourceConnectionStatus
from .sync_job_status import SyncJobStatus


class SourceConnection(UniversalBaseModel):
    """
    Complete source connection representation returned by the API.
    """

    name: str = pydantic.Field()
    """
    Human-readable display name for the source connection. This helps you identify the connection in the UI and should clearly describe what data it connects to (e.g., 'Production Stripe Account', 'Customer Support Database').
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional additional context about the data this connection provides. Use this to document the purpose, data types, or any special considerations for this connection.
    """

    config_fields: typing.Optional[ConfigValues] = pydantic.Field(default=None)
    """
    Source-specific configuration options that control data retrieval behavior. These vary by source type and control how data is retrieved (e.g., database queries, API filters, file paths). Check the documentation of a specific source (for example [Github](https://docs.airweave.ai/docs/connectors/github)) to see what is required.
    """

    short_name: str = pydantic.Field()
    """
    Technical identifier of the source type (e.g., 'github', 'stripe', 'postgresql', 'slack'). This determines which connector Airweave uses to sync data.
    """

    white_label_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Identifier for custom OAuth integrations. Only present for connections created through white label OAuth flows.
    """

    id: str = pydantic.Field()
    """
    Unique system identifier for this source connection. This UUID is generated automatically and used for API operations.
    """

    sync_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Internal identifier for the sync configuration associated with this source connection. Managed automatically by the system.
    """

    organization_id: str = pydantic.Field()
    """
    Identifier of the organization that owns this source connection. Source connections are isolated per organization.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the source connection was created (ISO 8601 format).
    """

    modified_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the source connection was last modified (ISO 8601 format).
    """

    connection_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Internal identifier for the underlying connection object that manages authentication and configuration.
    """

    collection: str = pydantic.Field()
    """
    Readable ID of the collection where this source connection syncs its data. This creates the link between your data source and searchable content.
    """

    created_by_email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Email address of the user who created this source connection.
    """

    modified_by_email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Email address of the user who last modified this source connection.
    """

    auth_fields: typing.Optional[SourceConnectionAuthFields] = pydantic.Field(default=None)
    """
    Authentication credentials for the data source. Returns '********' by default for security.
    """

    status: typing.Optional[SourceConnectionStatus] = pydantic.Field(default=None)
    """
    Current operational status of the source connection:<br/>• **active**: Connection is healthy and ready for data synchronization<br/>• **in_progress**: Currently syncing data from the source<br/>• **failing**: Recent sync attempts have failed and require attention
    """

    latest_sync_job_status: typing.Optional[SyncJobStatus] = pydantic.Field(default=None)
    """
    Status of the most recent data synchronization job:<br/>• **completed**: Last sync finished successfully<br/>• **failed**: Last sync encountered errors<br/>• **in_progress**: Currently running a sync job<br/>• **pending**: Sync job is queued and waiting to start
    """

    latest_sync_job_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier of the most recent sync job. Use this to track sync progress or retrieve detailed job information.
    """

    latest_sync_job_started_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the most recent sync job started (ISO 8601 format).
    """

    latest_sync_job_completed_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the most recent sync job completed (ISO 8601 format). Null if the job is still running or failed.
    """

    latest_sync_job_error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error message from the most recent sync job if it failed. Use this to diagnose and resolve sync issues.
    """

    cron_schedule: typing.Optional[str] = pydantic.Field(default=None)
    """
    Cron expression defining when automatic data synchronization occurs. Null if automatic syncing is disabled and syncs must be triggered manually.
    """

    next_scheduled_run: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the next automatic sync is scheduled to run (ISO 8601 format). Null if no automatic schedule is configured.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
