# Generated by Django 4.2.9 on 2024-01-30 16:05

from django.db import migrations, models
from tqdm import tqdm


def migrate_fees_date(apps, schema_editor):
    Fees = apps.get_model("wbportfolio", "Fees")
    fees = []

    for fee in tqdm(Fees.objects.all(), total=Fees.objects.count()):
        fee.fee_date = fee.transaction_date
        fees.append(fee)
        if len(fees) % 10000:
            Fees.objects.bulk_update(fees, fields=["fee_date"])
            fees = []
    Fees.objects.bulk_update(fees, fields=["fee_date"])


class Migration(migrations.Migration):
    dependencies = [
        ("wbportfolio", "0049_trade_claimed_shares"),
    ]

    operations = [
        migrations.AddField(
            model_name="fees",
            name="fee_date",
            field=models.DateField(null=True, blank=True),
        ),
        migrations.RunPython(migrate_fees_date),
        migrations.AlterField(
            model_name="fees",
            name="fee_date",
            field=models.DateField(),
        ),
        migrations.AddIndex(
            model_name="fees",
            index=models.Index(
                fields=["transaction_subtype", "linked_product", "fee_date", "calculated"],
                name="wbportfolio_transac_1f7a29_idx",
            ),
        ),
    ]
