# Generated by Django 4.2.9 on 2024-02-12 11:34

from datetime import date
from decimal import Decimal

import django.contrib.postgres.constraints
import django.contrib.postgres.fields.ranges
import django.db.models.deletion
from django.db import migrations, models
from psycopg.types.range import DateRange


def create_fees(apps, schema_editor):
    Product = apps.get_model("wbportfolio", "Product")
    FeeProductPercentage = apps.get_model("wbportfolio", "FeeProductPercentage")
    for product in Product.objects.all():
        FeeProductPercentage.objects.get_or_create(
            product=product,
            type="BANK",
            timespan=DateRange(date.min, date.max),
            defaults={"percent": product.bank_fees},
        )
        FeeProductPercentage.objects.get_or_create(
            product=product,
            type="MANAGEMENT",
            timespan=DateRange(date.min, date.max),
            defaults={"percent": product.management_fees},
        )
        FeeProductPercentage.objects.get_or_create(
            product=product,
            type="PERFORMANCE",
            timespan=DateRange(date.min, date.max),
            defaults={"percent": product.performance_fees, "vat_deduction": product.performance_fees_vat},
        )


class Migration(migrations.Migration):
    dependencies = [
        ("wbportfolio", "0054_portfolioinstrumentpreferredclassificationthroughmodel_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="FeeProductPercentage",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "type",
                    models.CharField(
                        choices=[("MANAGEMENT", "Management"), ("PERFORMANCE", "Performance"), ("BANK", "Bank")],
                        default="MANAGEMENT",
                        max_length=16,
                    ),
                ),
                (
                    "vat_deduction",
                    models.DecimalField(
                        decimal_places=6,
                        default=Decimal("0"),
                        help_text="The VAT deducted from this fees percentage",
                        max_digits=6,
                        verbose_name="VAT Deduction",
                    ),
                ),
                ("percent", models.DecimalField(decimal_places=6, max_digits=6)),
                ("timespan", django.contrib.postgres.fields.ranges.DateRangeField()),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="fees_percentages",
                        to="wbportfolio.product",
                    ),
                ),
            ],
            options={
                "verbose_name": "Fees Percentage",
                "verbose_name_plural": "Fees Percentage",
            },
        ),
        migrations.RunPython(create_fees),
        migrations.RemoveField(
            model_name="product",
            name="_custom_management_rebates",
        ),
        migrations.RemoveField(
            model_name="product",
            name="_custom_management_rebates_indirect",
        ),
        migrations.RemoveField(
            model_name="product",
            name="_custom_minimum_investment",
        ),
        migrations.RemoveField(
            model_name="product",
            name="_custom_performance_rebates",
        ),
        migrations.RemoveField(
            model_name="product",
            name="_custom_performance_rebates_indirect",
        ),
        migrations.RemoveField(
            model_name="product",
            name="bank_fees",
        ),
        migrations.RemoveField(
            model_name="product",
            name="management_fees",
        ),
        migrations.RemoveField(
            model_name="product",
            name="performance_fees",
        ),
        migrations.RemoveField(
            model_name="product",
            name="performance_fees_vat",
        ),
        migrations.AddConstraint(
            model_name="feeproductpercentage",
            constraint=django.contrib.postgres.constraints.ExclusionConstraint(
                expressions=[("timespan", "&&"), ("product", "="), ("type", "=")],
                name="exclude_overlapping_product_fees_type",
            ),
        ),
        migrations.RemoveConstraint(
            model_name="portfolioportfoliothroughmodel",
            name="unique_actual",
        ),
        migrations.RemoveConstraint(
            model_name="portfolioportfoliothroughmodel",
            name="unique_benchmark",
        ),
        migrations.AddConstraint(
            model_name="portfolioportfoliothroughmodel",
            constraint=models.UniqueConstraint(
                condition=models.Q(("type", "PRIMARY")), fields=("portfolio", "type"), name="unique_primary"
            ),
        ),
    ]
