# Persons
A list of every person saved in the database.

## Columns:
Each column title has three lines on the right if you hover over it. Click on them to show options for that column. The second tab of the options menu will allow you to filter the column, the third to completely hide entire columns. Click on anywhere else on the column to order it, cycling between ascending, descending and no ordering. Hold shift while clicking to order multiple columns with individual weights.

### Name:
The first and last name of the person.

### Primary Employer:
The primary employer of the person.

### Status:
The primary employer's status. Company statuses can be added, edited and deleted by managers under CRM > Administration > Customer Status.

### Position:
The position of the person within its primary employer. Positions can be added, edited and deleted by managers under CRM > Administration > Company Positions.

### City:
The city of the person's primary address. Hover over the name to display the full address.

### Primary Phone Number:
The person's primary phone number.

### Tier:
The person's primary employer's tier. Tiers range from 1 to 5 and are automatically computed.

### AUM Invested:
The person's primary employer's assets under management managed by the main company.

### AUM:
Total assets under management for the person's primary employer.

### Potential:
The potential reflects how much potential a person's primary employer (regardless of whether this employer is a client or propective) has. Formula: AUM * (Asset Allocation * Asset Allocation Max Investment) - Invested AUM. The field is populated automatically.

### Primary Relationship Manager:
The primary relationship manager of this person. Hover over the name to display further information about the person.

### Last Activity:
The name and end date of the person's last activity. Hover over it to display further information about the activity. Column can also be ordered by end date of the activity.

### Activity Heat:
A visual representation of the person's activeness. The data representation ranges from 0 to 1 which needs to be kept in mind to be able to apply a proper filter to the column.

## Filters:

### Specializations:
Filter persons by their specializations.

### No Activity:
Filter persons with no activity for x amount of time.

### Has User Account:
Filter persons by if they have a user account on the workbench.

### Email:
Filter persons by their email address.

## Search Field:
Typing in the search field allows to filter the persons by name.

## Buttons:
Each row can be right-clicked to reveal two buttons at the end of it.

### Activities:
Displays all activities for the row's person.

### Relationship Managers:
Displays all relationship managers of the row's person.
