from typing import Optional

from wbcore.contrib.color.enums import WBColor
from wbcore.metadata.configs import display as dp
from wbcore.metadata.configs.display.instance_display import Inline, Layout, Page
from wbcore.metadata.configs.display.instance_display.operators import default
from wbcore.metadata.configs.display.instance_display.shortcuts import Display
from wbcore.metadata.configs.display.view_config import DisplayViewConfig

from wbportfolio.models import TradeProposal


class TradeProposalDisplayConfig(DisplayViewConfig):
    def get_list_display(self) -> Optional[dp.ListDisplay]:
        return dp.ListDisplay(
            fields=[
                dp.Field(key="trade_date", label="Trade Date"),
                dp.Field(key="comment", label="Comment"),
            ],
            legends=[
                dp.Legend(
                    key="status",
                    items=[
                        dp.LegendItem(
                            icon=WBColor.BLUE_LIGHT.value,
                            label=TradeProposal.Status.DRAFT.label,
                            value=TradeProposal.Status.DRAFT.value,
                        ),
                        dp.LegendItem(
                            icon=WBColor.YELLOW_LIGHT.value,
                            label=TradeProposal.Status.SUBMIT.label,
                            value=TradeProposal.Status.SUBMIT.value,
                        ),
                        dp.LegendItem(
                            icon=WBColor.GREEN_LIGHT.value,
                            label=TradeProposal.Status.APPROVED.label,
                            value=TradeProposal.Status.APPROVED.value,
                        ),
                        dp.LegendItem(
                            icon=WBColor.RED_LIGHT.value,
                            label=TradeProposal.Status.DENIED.label,
                            value=TradeProposal.Status.DENIED.value,
                        ),
                    ],
                ),
            ],
            formatting=[
                dp.Formatting(
                    column="status",
                    formatting_rules=[
                        dp.FormattingRule(
                            style={"backgroundColor": WBColor.BLUE_LIGHT.value},
                            condition=("==", TradeProposal.Status.DRAFT.value),
                        ),
                        dp.FormattingRule(
                            style={"backgroundColor": WBColor.YELLOW_LIGHT.value},
                            condition=("==", TradeProposal.Status.SUBMIT.value),
                        ),
                        dp.FormattingRule(
                            style={"backgroundColor": WBColor.GREEN_LIGHT.value},
                            condition=("==", TradeProposal.Status.APPROVED.value),
                        ),
                        dp.FormattingRule(
                            style={"backgroundColor": WBColor.RED_LIGHT.value},
                            condition=("==", TradeProposal.Status.DENIED.value),
                        ),
                    ],
                )
            ],
        )

    def get_instance_display(self) -> Display:
        return Display(
            pages=[
                Page(
                    title="Main Information",
                    layouts={
                        default(): Layout(
                            grid_template_areas=[
                                ["status", "status"],
                                ["trade_date", "total_cash_weight"],
                                ["rebalancing_model", "target_portfolio"]
                                if self.view.new_mode
                                else ["rebalancing_model", "rebalancing_model"],
                                ["comment", "comment"],
                            ],
                        ),
                    },
                ),
                Page(
                    title="Trades",
                    layouts={
                        default(): Layout(
                            grid_template_areas=[["trades"]],
                            grid_template_rows=["1fr"],
                            inlines=[Inline(key="trades", endpoint="trades")],
                        ),
                    },
                ),
            ]
        )
