# pretty-mod

A module tree explorer for humans and LLMs.

## Installation

```bash
uv add pretty-mod
```

## Usage

```python
from pretty_mod.explorer import ModuleTreeExplorer

# Explore a module structure
explorer = ModuleTreeExplorer("json", max_depth=2)
explorer.explore()
print(explorer.get_tree_string())
```

<details>
<summary>Example output</summary>

```text
📦 json
└── 📜 __all__: dump, dumps, load, loads, JSONDecoder, JSONDecodeError, JSONEncoder
├── ⚡ functions: dump, dumps, load, loads
├── 📦 decoder
    ├── 📜 __all__: JSONDecoder, JSONDecodeError
    ├── 🔷 classes: JSONDecodeError, JSONDecoder
├── 📦 encoder
    ├── 🔷 classes: JSONEncoder
    ├── ⚡ functions: py_encode_basestring, py_encode_basestring_ascii
├── 📦 scanner
    ├── 📜 __all__: make_scanner
└── 📦 tool
    └── ⚡ functions: main
```
</details>



```python
from pretty_mod.explorer import display_signature

# Display function signatures
print(display_signature("json:loads"))
```

<details>
<summary>Example output</summary>

```text
📎 loads
├── Parameters:
├── s
├── cls = None (keyword-only)
├── object_hook = None (keyword-only)
├── parse_float = None (keyword-only)
├── parse_int = None (keyword-only)
├── parse_constant = None (keyword-only)
├── object_pairs_hook = None (keyword-only)
└── kw (**kwargs)
```
</details>

## Examples

See the [`examples/`](examples/) directory for more detailed usage patterns and advanced features.

## Development

```bash
git clone https://github.com/zzstoatzz/pretty-mod.git
cd pretty-mod
uv sync
uv run pytest
```
