"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from nabla_py.errors import NablaError
from nabla_py.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated


class ErrorData(BaseModel):
    error: str
    r"""Error type"""

    message: str
    r"""Error message"""

    code: Optional[str] = None
    r"""HTTP status code"""

    request_id: Annotated[Optional[str], pydantic.Field(alias="requestId")] = None
    r"""Request identifier for debugging"""


@dataclass(unsafe_hash=True)
class Error(NablaError):
    r"""Bad request - invalid input"""

    data: ErrorData = field(hash=False)

    def __init__(
        self, data: ErrorData, raw_response: httpx.Response, body: Optional[str] = None
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
