"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from nabla_py import errors, models, utils
from nabla_py._hooks import HookContext
from nabla_py.types import OptionalNullable, UNSET
from nabla_py.utils import get_security_from_env
from nabla_py.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class Evidence(BaseSDK):
    r"""Compliance evidence generation and analysis"""

    def assess_terraform_state(
        self,
        *,
        name: str,
        format_: models.AssessTerraformStateFormat,
        content_base64: str,
        include_diagram: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EvidenceResponse:
        r"""Analyze Terraform state for compliance

        Generate NIST 800-53 compliance assessment from Terraform state file with optional architecture diagram

        :param name: Name for the evidence assessment
        :param format_: Output format for the assessment
        :param content_base64: Base64-encoded Terraform state file (JSON)
        :param include_diagram: Include Mermaid architecture diagram in artifacts
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AssessTerraformStateRequest(
            name=name,
            format_=format_,
            content_base64=content_base64,
            include_diagram=include_diagram,
        )

        req = self._build_request(
            method="POST",
            path="/v1/evidence/terraform",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AssessTerraformStateRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="assessTerraformState",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EvidenceResponse, http_res)
        if utils.match_response(http_res, ["400", "401", "422"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorData, http_res)
            raise errors.Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.NablaDefaultError("Unexpected response received", http_res)

    async def assess_terraform_state_async(
        self,
        *,
        name: str,
        format_: models.AssessTerraformStateFormat,
        content_base64: str,
        include_diagram: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EvidenceResponse:
        r"""Analyze Terraform state for compliance

        Generate NIST 800-53 compliance assessment from Terraform state file with optional architecture diagram

        :param name: Name for the evidence assessment
        :param format_: Output format for the assessment
        :param content_base64: Base64-encoded Terraform state file (JSON)
        :param include_diagram: Include Mermaid architecture diagram in artifacts
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AssessTerraformStateRequest(
            name=name,
            format_=format_,
            content_base64=content_base64,
            include_diagram=include_diagram,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/evidence/terraform",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AssessTerraformStateRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="assessTerraformState",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EvidenceResponse, http_res)
        if utils.match_response(http_res, ["400", "401", "422"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorData, http_res)
            raise errors.Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.NablaDefaultError("Unexpected response received", http_res)

    def assess_azure_environment(
        self,
        *,
        name: str,
        format_: models.AssessAzureEnvironmentFormat,
        azure_wif: Union[models.AzureWif, models.AzureWifTypedDict],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EvidenceResponse:
        r"""Analyze Azure environment for compliance (live)

        Generate NIST 800-53 compliance assessment from live Azure environment using Workload Identity Federation. Requires Fabric plan.

        :param name: Name for the evidence assessment
        :param format_: Output format for the assessment
        :param azure_wif: Azure Workload Identity Federation configuration
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AssessAzureEnvironmentRequest(
            name=name,
            format_=format_,
            azure_wif=utils.get_pydantic_model(azure_wif, models.AzureWif),
        )

        req = self._build_request(
            method="POST",
            path="/v1/evidence/azure",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AssessAzureEnvironmentRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="assessAzureEnvironment",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EvidenceResponse, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "422"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.ErrorData, http_res)
            raise errors.Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.NablaDefaultError("Unexpected response received", http_res)

    async def assess_azure_environment_async(
        self,
        *,
        name: str,
        format_: models.AssessAzureEnvironmentFormat,
        azure_wif: Union[models.AzureWif, models.AzureWifTypedDict],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EvidenceResponse:
        r"""Analyze Azure environment for compliance (live)

        Generate NIST 800-53 compliance assessment from live Azure environment using Workload Identity Federation. Requires Fabric plan.

        :param name: Name for the evidence assessment
        :param format_: Output format for the assessment
        :param azure_wif: Azure Workload Identity Federation configuration
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AssessAzureEnvironmentRequest(
            name=name,
            format_=format_,
            azure_wif=utils.get_pydantic_model(azure_wif, models.AzureWif),
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/evidence/azure",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AssessAzureEnvironmentRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="assessAzureEnvironment",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EvidenceResponse, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "422"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.ErrorData, http_res)
            raise errors.Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.NablaDefaultError("Unexpected response received", http_res)
