"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from nabla_py import errors, models, utils
from nabla_py._hooks import HookContext
from nabla_py.types import OptionalNullable, UNSET
from nabla_py.utils import get_security_from_env
from nabla_py.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional


class Fips(BaseSDK):
    def generate_assessment(
        self,
        *,
        name: str,
        format_: models.GenerateFipsAssessmentFormat,
        zip_content: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EvidenceResponse:
        r"""Generate FIPS cryptographic assessment from ZIP bundle

        Upload a ZIP archive containing multiple evidence sources (SBOMs, Terraform state, Kubernetes manifests, Ansible playbooks, package locks, system info) and generate FIPS 140-2/140-3 cryptographic compliance assessment. Detects cryptographic libraries, validates FIPS compliance, and checks for weak algorithms.

        :param name: Name for the FIPS assessment
        :param format_: Output format for the assessment
        :param zip_content: Base64-encoded ZIP archive. Supported file types: sbom.json/spdx.json (SBOM), *.tfstate (Terraform), *.yaml/manifest.yaml (Kubernetes), playbook.yaml (Ansible), package-lock.json/Cargo.lock/go.mod/poetry.lock (package managers), system_info.json/openssl.json (system crypto info)
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GenerateFipsAssessmentRequest(
            name=name,
            format_=format_,
            zip_content=zip_content,
        )

        req = self._build_request(
            method="POST",
            path="/v1/fips",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.GenerateFipsAssessmentRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="generateFipsAssessment",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EvidenceResponse, http_res)
        if utils.match_response(http_res, ["400", "401", "422"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorData, http_res)
            raise errors.Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.NablaDefaultError("Unexpected response received", http_res)

    async def generate_assessment_async(
        self,
        *,
        name: str,
        format_: models.GenerateFipsAssessmentFormat,
        zip_content: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EvidenceResponse:
        r"""Generate FIPS cryptographic assessment from ZIP bundle

        Upload a ZIP archive containing multiple evidence sources (SBOMs, Terraform state, Kubernetes manifests, Ansible playbooks, package locks, system info) and generate FIPS 140-2/140-3 cryptographic compliance assessment. Detects cryptographic libraries, validates FIPS compliance, and checks for weak algorithms.

        :param name: Name for the FIPS assessment
        :param format_: Output format for the assessment
        :param zip_content: Base64-encoded ZIP archive. Supported file types: sbom.json/spdx.json (SBOM), *.tfstate (Terraform), *.yaml/manifest.yaml (Kubernetes), playbook.yaml (Ansible), package-lock.json/Cargo.lock/go.mod/poetry.lock (package managers), system_info.json/openssl.json (system crypto info)
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GenerateFipsAssessmentRequest(
            name=name,
            format_=format_,
            zip_content=zip_content,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/fips",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.GenerateFipsAssessmentRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="generateFipsAssessment",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EvidenceResponse, http_res)
        if utils.match_response(http_res, ["400", "401", "422"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorData, http_res)
            raise errors.Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.NablaDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.NablaDefaultError("Unexpected response received", http_res)
