"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from nabla_py.types import BaseModel
import pydantic
from typing import List, Literal
from typing_extensions import Annotated, TypedDict


AssessAzureEnvironmentFormat = Literal[
    "oscal",
    "yaml",
    "json",
]
r"""Output format for the assessment"""


class AzureWifTypedDict(TypedDict):
    r"""Azure Workload Identity Federation configuration"""

    tenant_id: str
    r"""Azure AD tenant ID"""
    client_id: str
    r"""Azure AD application (client) ID"""
    oidc_token: str
    r"""OIDC JWT token from identity provider (e.g., GitHub Actions)"""
    subscription_ids: List[str]
    r"""List of Azure subscription IDs to analyze"""


class AzureWif(BaseModel):
    r"""Azure Workload Identity Federation configuration"""

    tenant_id: str
    r"""Azure AD tenant ID"""

    client_id: str
    r"""Azure AD application (client) ID"""

    oidc_token: str
    r"""OIDC JWT token from identity provider (e.g., GitHub Actions)"""

    subscription_ids: List[str]
    r"""List of Azure subscription IDs to analyze"""


class AssessAzureEnvironmentRequestTypedDict(TypedDict):
    name: str
    r"""Name for the evidence assessment"""
    format_: AssessAzureEnvironmentFormat
    r"""Output format for the assessment"""
    azure_wif: AzureWifTypedDict
    r"""Azure Workload Identity Federation configuration"""


class AssessAzureEnvironmentRequest(BaseModel):
    name: str
    r"""Name for the evidence assessment"""

    format_: Annotated[AssessAzureEnvironmentFormat, pydantic.Field(alias="format")]
    r"""Output format for the assessment"""

    azure_wif: AzureWif
    r"""Azure Workload Identity Federation configuration"""
