"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .artifact import Artifact, ArtifactTypedDict
from .mappinghit import MappingHit, MappingHitTypedDict
from nabla_py.types import BaseModel
from typing import List, Literal, Optional
from typing_extensions import NotRequired, TypedDict


DetectedFormat = Literal[
    "elf",
    "pe",
    "mach_o",
    "wasm",
    "raw",
]
r"""Detected binary format"""


SecurityFeature = Literal[
    "nx",
    "aslr",
    "stack_canary",
    "cfi",
    "fortify",
    "pie",
    "relro",
    "signed",
]


class PfrAssessmentTypedDict(TypedDict):
    r"""NIST SP 800-193 Platform Firmware Resilience assessment"""


class PfrAssessment(BaseModel):
    r"""NIST SP 800-193 Platform Firmware Resilience assessment"""


class FirmwareResponseTypedDict(TypedDict):
    id: str
    name: str
    r"""Firmware name"""
    detected_format: DetectedFormat
    r"""Detected binary format"""
    strings: List[str]
    r"""Extracted ASCII strings (max 200)"""
    security_features: List[SecurityFeature]
    r"""Detected security features"""
    findings: List[str]
    r"""Security findings with severity (CRITICAL, HIGH, MED, LOW, INFO)"""
    architecture: NotRequired[str]
    r"""CPU architecture"""
    entry_point: NotRequired[str]
    r"""Entry point address"""
    cfg_mermaid: NotRequired[str]
    r"""Control Flow Graph in Mermaid format (if available)"""
    mappings: NotRequired[List[MappingHitTypedDict]]
    r"""Mappings to compliance frameworks"""
    pfr_assessment: NotRequired[PfrAssessmentTypedDict]
    r"""NIST SP 800-193 Platform Firmware Resilience assessment"""
    artifacts: NotRequired[List[ArtifactTypedDict]]


class FirmwareResponse(BaseModel):
    id: str

    name: str
    r"""Firmware name"""

    detected_format: DetectedFormat
    r"""Detected binary format"""

    strings: List[str]
    r"""Extracted ASCII strings (max 200)"""

    security_features: List[SecurityFeature]
    r"""Detected security features"""

    findings: List[str]
    r"""Security findings with severity (CRITICAL, HIGH, MED, LOW, INFO)"""

    architecture: Optional[str] = None
    r"""CPU architecture"""

    entry_point: Optional[str] = None
    r"""Entry point address"""

    cfg_mermaid: Optional[str] = None
    r"""Control Flow Graph in Mermaid format (if available)"""

    mappings: Optional[List[MappingHit]] = None
    r"""Mappings to compliance frameworks"""

    pfr_assessment: Optional[PfrAssessment] = None
    r"""NIST SP 800-193 Platform Firmware Resilience assessment"""

    artifacts: Optional[List[Artifact]] = None
