# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.1.0] - 2025-01-XX

### Added
- Initial release of OMAM AuthKit Python SDK
- Core `AuthKitClient` for OAuth 2.0 authentication
- `TokenManager` for automatic token refresh and validation
- `SecureTokenStorage` for encrypted token storage
- `WebhookHandler` for webhook verification
- Django integration with middleware, decorators, and utilities
- Flask integration examples
- FastAPI integration examples
- Comprehensive test coverage
- Full type hints support
- Documentation and examples

### Features
- OAuth 2.0 authorization code flow
- Token refresh and introspection
- User registration and management
- Webhook signature verification
- Django middleware and decorators
- Secure token storage with encryption
- Context manager support for client
- Configurable timeouts and retries

### Documentation
- Complete README with examples
- API reference documentation
- Integration guides for Django, Flask, and FastAPI
- Best practices and security recommendations
