![Starplot](images/favicon.svg){ align=right width="128" .off-glb }

**Starplot** is a Python library for creating star charts and maps of the sky. It lets you create zenith plots that show the whole sky from a time/place, map plots that show more detail of an area, and optic plots that simulate the field of view from a particular optic (e.g. telescope, binoculars, or a camera).

👷 **Work In Progress** 🚧 Starplot is still very much a work in progress, and under active development. We try to follow [semantic versioning](https://semver.org/), which means that [_anything_ can change between versions before `1.0.0`](https://semver.org/#spec-item-4).

However, the Starplot API becomes more stable with each new version. We anticipate that version `1.0.0` is still at least a year away (2026+). The best way to help us get there faster is to [join as a contributor](https://github.com/steveberardi/starplot/blob/main/CONTRIBUTING.md) 😃 help is wanted and very much appreciated!

--8<-- "docs/snippets/_newsletter.html"

---

### _Note from the author..._

Like many amateur astronomers, when I first started looking up at the sky through a scope I bought the wonderful book [_Turn Left at Orion_](https://www.amazon.com/Turn-Left-Orion-Hundreds-Telescope-dp-1108457568/dp/1108457568/), and it really helped me learn how to find stuff in the sky. The thing that helped me the most were all the finder charts that show an object in various ways: first a general overview of where the object is in the sky (useful for finding the object with your naked eye), and then vector drawings of what the object looks like through a medium/high power scope (including any transformations to the image from mirrors in the scope). These really helped me confirm I found the object.

After finding most of the sky objects in _Turn Left at Orion_, I tried finding another book or software that would create those finder charts in the book for any spot in the sky, but I couldn't find anything. That was my main motivation for creating Starplot.

I also just really love any kind of map of the stars, including more abstract/artistic types of maps. So, one of my goals with Starplot is to make it customizable for many different purposes.

Starplot is still very much a work in progress, so I appreciate any feedback! Please feel free to [contact me](https://steveberardi.com/contact/) or [open an issue](https://github.com/steveberardi/starplot/issues) on the GitHub repo.

Thanks!

[Steve Berardi](https://steveberardi.com)
