---
title: Star Charts and Maps of the Sky in Python
---

# Welcome to Starplot

![Python](https://img.shields.io/pypi/pyversions/starplot?style=for-the-badge&color=6388b0)
![PyPI](https://img.shields.io/pypi/v/starplot?style=for-the-badge&color=57a8a8)
![License](https://img.shields.io/github/license/steveberardi/starplot?style=for-the-badge&color=8b63b0)
![GitHub Workflow Status](https://img.shields.io/github/actions/workflow/status/steveberardi/starplot/test.yml?style=for-the-badge&color=88b063)

Starplot is a Python library for creating star charts and maps of the sky.
{.text-subtitle}

- ⭐ **Zenith Plots** - shows the entire sky at a specific time and place

- 🗺️ **Map Plots** - including many projections

- 🌃 **Horizon Plots** - shows the horizon at a specific time and place

- 🔭 **Optic Plots** - shows what you'll see through an optic (e.g. telescope) at a specific time and place

- 🪐 **Planets and Deep Sky Objects (DSOs)** - more than 14,000 objects built-in

- 🎨 **Custom Styles** - for all objects

- 📥 **Export** - png, svg, jpeg

- 🚀 **Data Backend** - powered by DuckDB + Ibis for fast object lookup

- 🧭 **Label Collision Avoidance**


--8<-- "docs/snippets/_newsletter.html"

<br/>
*Example charts and maps created with Starplot:*

<figure markdown>
  <img src="images/examples/star_chart_basic.png" height="900" width="900">
  <figcaption>Zenith plot of the stars from a specific time/location (<a href="/examples/star-chart-basic/">source code</a>)</figcaption>
</figure>

<figure markdown>
  <img src="images/examples/map_orion.png" width="900">
  <figcaption>Map around the constellation Orion (<a href="/examples/map-orion/">source code</a>)</figcaption>
</figure>

<figure markdown>
  <img src="images/examples/horizon_gradient.png" width="900">
  <figcaption>Horizon plot that shows the sky looking South from Stonehaugh, England at 11:30pm (<a href="/examples/horizon-gradient/">source code</a>)</figcaption>
</figure>

<figure markdown>
  <img src="images/examples/optic_m45.png" width="900">
  <figcaption>Optic plot that shows what The Pleiades looked like through a refractor telescope on December 16, 2023 at 9pm PT from Palomar Mountain in California (<a href="/examples/optic-m45/">source code</a>)</figcaption>
</figure>


---

✨ [Check out more examples...](examples.md)
{.text-subtitle}
