Statistical Process Control with Python
========================
This Python package implements various methods from the field of Statistical Process Control (SPC).

The idea of the package is to make easily available a lot of functionality from the SPC
field for Python as we feel this is not currently available in one single package.

Most of the basic functionality is based on the book "Statistical Quality Control" from 2013, 7th Edition, 
by Douglas C. Montgomery. All references to equations and otherwise are to this book if
not stated otherwise.

The aim of the functions is to have a consistent and standardized, easy-to-use API, so
that each procedure is used in roughly the same way. Some 
inspiration for this comes from the popular scikit-learn library, especially the fit() method API. 

This package contains some advanced SPC methods as well in the form of dynamic principal components analysis 
and orthogonal autoencoders.
