# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.apiaccesscontrol.src.oci_cli_apiaccesscontrol.generated import apiaccesscontrol_service_cli


@click.command(cli_util.override('privileged_api_control.privileged_api_control_root_group.command_name', 'privileged-api-control'), cls=CommandGroupWithAlias, help=cli_util.override('privileged_api_control.privileged_api_control_root_group.help', """This service is used to restrict the control plane service apis; so that everybody won't be
able to access those apis.
There are two main resouces defined as a part of this service
1. PrivilegedApiControl: This is created by the customer which defines which service apis are
   controlled and who can access it.
2. PrivilegedApiRequest: This is a request object again created by the customer operators who           seek access to those privileged apis. After a request is obtained based on the                       PrivilegedAccessControl for which the api belongs to, either it can be approved so that the          requested person can execute the service apis or it will wait for the customer to approve it."""), short_help=cli_util.override('privileged_api_control.privileged_api_control_root_group.short_help', """Oracle API Access Control"""))
@cli_util.help_option_group
def privileged_api_control_root_group():
    pass


@click.command(cli_util.override('privileged_api_control.privileged_api_control_group.command_name', 'privileged-api-control'), cls=CommandGroupWithAlias, help="""A PrivilegedApiControl is a kind of Policy definition which provides details about which operations needs to be secure; who can approve a privilegedApiRequest requesting for a particular operation, whether the operations needs to be approved by customer or is it preApproved.

To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def privileged_api_control_group():
    pass


@click.command(cli_util.override('privileged_api_control.privileged_api_control_collection_group.command_name', 'privileged-api-control-collection'), cls=CommandGroupWithAlias, help="""Results of a privilegedApiControl search. Contains both PrivilegedApiControlSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def privileged_api_control_collection_group():
    pass


apiaccesscontrol_service_cli.apiaccesscontrol_service_group.add_command(privileged_api_control_root_group)
privileged_api_control_root_group.add_command(privileged_api_control_group)
privileged_api_control_root_group.add_command(privileged_api_control_collection_group)


@privileged_api_control_group.command(name=cli_util.override('privileged_api_control.change_privileged_api_control_compartment.command_name', 'change-compartment'), help=u"""Moves a PrivilegedApiControl into a different compartment within the same tenancy. For information about moving resources between compartments, see [Moving Resources to a Different Compartment]. \n[Command Reference](changePrivilegedApiControlCompartment)""")
@cli_util.option('--privileged-api-control-id', required=True, help=u"""The [OCID] of the PrivilegedApiControl.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment to move the PrivilegedApiControl to.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_privileged_api_control_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, privileged_api_control_id, compartment_id, if_match):

    if isinstance(privileged_api_control_id, six.string_types) and len(privileged_api_control_id.strip()) == 0:
        raise click.UsageError('Parameter --privileged-api-control-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_control', ctx)
    result = client.change_privileged_api_control_compartment(
        privileged_api_control_id=privileged_api_control_id,
        change_privileged_api_control_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@privileged_api_control_group.command(name=cli_util.override('privileged_api_control.create_privileged_api_control.command_name', 'create'), help=u"""Creates a PrivilegedApiControl. \n[Command Reference](createPrivilegedApiControl)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment to create the PrivilegedApiControl in.""")
@cli_util.option('--notification-topic-id', required=True, help=u"""The OCID of the OCI Notification topic to publish messages related to this Delegation Control.""")
@cli_util.option('--approver-group-id-list', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of user IAM group ids who can approve an privilegedApi request associated with a resource governed by this operator control.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--privileged-operation-list', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--resource-type', required=True, help=u"""resourceType for which the PrivilegedApiControl is applicable""")
@cli_util.option('--resources', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""contains Resource details""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""Name of the privilegedApi control It has to be unique.""")
@cli_util.option('--description', help=u"""Description of the privilegedApi control.""")
@cli_util.option('--number-of-approvers', type=click.INT, help=u"""Number of approvers required to approve an privilegedApi request.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'approver-group-id-list': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'privileged-operation-list': {'module': 'apiaccesscontrol', 'class': 'list[PrivilegedApiDetails]'}, 'resources': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'approver-group-id-list': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'privileged-operation-list': {'module': 'apiaccesscontrol', 'class': 'list[PrivilegedApiDetails]'}, 'resources': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'apiaccesscontrol', 'class': 'PrivilegedApiControl'})
@cli_util.wrap_exceptions
def create_privileged_api_control(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, notification_topic_id, approver_group_id_list, privileged_operation_list, resource_type, resources, display_name, description, number_of_approvers, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['notificationTopicId'] = notification_topic_id
    _details['approverGroupIdList'] = cli_util.parse_json_parameter("approver_group_id_list", approver_group_id_list)
    _details['privilegedOperationList'] = cli_util.parse_json_parameter("privileged_operation_list", privileged_operation_list)
    _details['resourceType'] = resource_type
    _details['resources'] = cli_util.parse_json_parameter("resources", resources)

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if number_of_approvers is not None:
        _details['numberOfApprovers'] = number_of_approvers

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_control', ctx)
    result = client.create_privileged_api_control(
        create_privileged_api_control_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@privileged_api_control_group.command(name=cli_util.override('privileged_api_control.delete_privileged_api_control.command_name', 'delete'), help=u"""Deletes a PrivilegedApiControl. \n[Command Reference](deletePrivilegedApiControl)""")
@cli_util.option('--privileged-api-control-id', required=True, help=u"""The [OCID] of the PrivilegedApiControl.""")
@cli_util.option('--description', help=u"""reason for deletion of PrivilegedApiControl.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_privileged_api_control(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, privileged_api_control_id, description, if_match):

    if isinstance(privileged_api_control_id, six.string_types) and len(privileged_api_control_id.strip()) == 0:
        raise click.UsageError('Parameter --privileged-api-control-id cannot be whitespace or empty string')

    kwargs = {}
    if description is not None:
        kwargs['description'] = description
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_control', ctx)
    result = client.delete_privileged_api_control(
        privileged_api_control_id=privileged_api_control_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@privileged_api_control_group.command(name=cli_util.override('privileged_api_control.get_privileged_api_control.command_name', 'get'), help=u"""Gets information about a PrivilegedApiControl. \n[Command Reference](getPrivilegedApiControl)""")
@cli_util.option('--privileged-api-control-id', required=True, help=u"""The [OCID] of the PrivilegedApiControl.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apiaccesscontrol', 'class': 'PrivilegedApiControl'})
@cli_util.wrap_exceptions
def get_privileged_api_control(ctx, from_json, privileged_api_control_id):

    if isinstance(privileged_api_control_id, six.string_types) and len(privileged_api_control_id.strip()) == 0:
        raise click.UsageError('Parameter --privileged-api-control-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_control', ctx)
    result = client.get_privileged_api_control(
        privileged_api_control_id=privileged_api_control_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@privileged_api_control_collection_group.command(name=cli_util.override('privileged_api_control.list_privileged_api_controls.command_name', 'list-privileged-api-controls'), help=u"""Gets a list of PrivilegedApiControls. \n[Command Reference](listPrivilegedApiControls)""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--id', help=u"""The [OCID] of the PrivilegedApiControl.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION"]), help=u"""A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the given display name exactly.""")
@cli_util.option('--resource-type', help=u"""A filter to return only lists of resources that match the entire given service type.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--page', help=u"""For list pagination. The value of the opc-next-page response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. You can provide only one sort order. Default order for `timeCreated` is descending. Default order for `displayName` is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apiaccesscontrol', 'class': 'PrivilegedApiControlCollection'})
@cli_util.wrap_exceptions
def list_privileged_api_controls(ctx, from_json, all_pages, page_size, compartment_id, id, lifecycle_state, display_name, resource_type, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if id is not None:
        kwargs['id'] = id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if resource_type is not None:
        kwargs['resource_type'] = resource_type
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_control', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_privileged_api_controls,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_privileged_api_controls,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_privileged_api_controls(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@privileged_api_control_group.command(name=cli_util.override('privileged_api_control.update_privileged_api_control.command_name', 'update'), help=u"""Updates a PrivilegedApiControl. \n[Command Reference](updatePrivilegedApiControl)""")
@cli_util.option('--privileged-api-control-id', required=True, help=u"""The [OCID] of the PrivilegedApiControl.""")
@cli_util.option('--display-name', help=u"""Name of the privilegedApi control. Needs to be unique.""")
@cli_util.option('--description', help=u"""Description of the privilegedApi control.""")
@cli_util.option('--resource-type', help=u"""resourceType for which the PrivilegedApiControl is applicable""")
@cli_util.option('--resources', type=custom_types.CLI_COMPLEX_TYPE, help=u"""contains Resource details""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--notification-topic-id', help=u"""The OCID of the OCI Notification topic to publish messages related to this Delegation Control.""")
@cli_util.option('--approver-group-id-list', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of user IAM group ids who can approve an privilegedApi request associated with a target resource under the governance of this privilegedApi control.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--privileged-operation-list', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.

This option is a JSON list with items of type PrivilegedApiDetails.  For documentation on PrivilegedApiDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/privilegedapicontrol/20241130/datatypes/PrivilegedApiDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--number-of-approvers', type=click.INT, help=u"""Number of approvers required to approve an privilegedApi request.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'resources': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'approver-group-id-list': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'privileged-operation-list': {'module': 'apiaccesscontrol', 'class': 'list[PrivilegedApiDetails]'}, 'freeform-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'resources': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'approver-group-id-list': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'privileged-operation-list': {'module': 'apiaccesscontrol', 'class': 'list[PrivilegedApiDetails]'}, 'freeform-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_privileged_api_control(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, privileged_api_control_id, display_name, description, resource_type, resources, notification_topic_id, approver_group_id_list, privileged_operation_list, number_of_approvers, freeform_tags, defined_tags, if_match):

    if isinstance(privileged_api_control_id, six.string_types) and len(privileged_api_control_id.strip()) == 0:
        raise click.UsageError('Parameter --privileged-api-control-id cannot be whitespace or empty string')
    if not force:
        if resources or approver_group_id_list or privileged_operation_list or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to resources and approver-group-id-list and privileged-operation-list and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if resource_type is not None:
        _details['resourceType'] = resource_type

    if resources is not None:
        _details['resources'] = cli_util.parse_json_parameter("resources", resources)

    if notification_topic_id is not None:
        _details['notificationTopicId'] = notification_topic_id

    if approver_group_id_list is not None:
        _details['approverGroupIdList'] = cli_util.parse_json_parameter("approver_group_id_list", approver_group_id_list)

    if privileged_operation_list is not None:
        _details['privilegedOperationList'] = cli_util.parse_json_parameter("privileged_operation_list", privileged_operation_list)

    if number_of_approvers is not None:
        _details['numberOfApprovers'] = number_of_approvers

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_control', ctx)
    result = client.update_privileged_api_control(
        privileged_api_control_id=privileged_api_control_id,
        update_privileged_api_control_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
