# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.apiaccesscontrol.src.oci_cli_apiaccesscontrol.generated import apiaccesscontrol_service_cli


@click.command(cli_util.override('privileged_api_requests.privileged_api_requests_root_group.command_name', 'privileged-api-requests'), cls=CommandGroupWithAlias, help=cli_util.override('privileged_api_requests.privileged_api_requests_root_group.help', """This service is used to restrict the control plane service apis; so that everybody won't be
able to access those apis.
There are two main resouces defined as a part of this service
1. PrivilegedApiControl: This is created by the customer which defines which service apis are
   controlled and who can access it.
2. PrivilegedApiRequest: This is a request object again created by the customer operators who           seek access to those privileged apis. After a request is obtained based on the                       PrivilegedAccessControl for which the api belongs to, either it can be approved so that the          requested person can execute the service apis or it will wait for the customer to approve it."""), short_help=cli_util.override('privileged_api_requests.privileged_api_requests_root_group.short_help', """Oracle API Access Control"""))
@cli_util.help_option_group
def privileged_api_requests_root_group():
    pass


@click.command(cli_util.override('privileged_api_requests.privileged_api_request_collection_group.command_name', 'privileged-api-request-collection'), cls=CommandGroupWithAlias, help="""Results of privilegedApi request search, which contains summary of privilegedApi request.""")
@cli_util.help_option_group
def privileged_api_request_collection_group():
    pass


@click.command(cli_util.override('privileged_api_requests.privileged_api_request_group.command_name', 'privileged-api-request'), cls=CommandGroupWithAlias, help="""An Oracle operator raises privilegedApi request when they need access to any infrastructure resource governed by PrivilegedApi Access Control.   The privilegedApi request identifies the target resource and the set of operator actions. Access request handling depends upon the Operator Control   that governs the target resource, and the set of operator actions listed for approval in the access request. If all of the operator actions   listed in the privilegedApi request are in the pre-approved list in the PrivilegedApi Control that governs the target resource, then the privilegedApi request is   automatically approved. If not, then the privilegedApi request requires explicit approval from the approver group specified by the PrivilegedApi Control governing the target resource.

You can approve or reject an privilegedApi request. You can also revoke the approval of an already approved privilegedApi request. While creating an access request,   the operator specifies the duration of access. You have the option to approve the entire duration or reduce or even increase the time duration.   An operator can also request for an extension. The approval for such an extension is processed the same way the original privilegedApi request was processed.""")
@cli_util.help_option_group
def privileged_api_request_group():
    pass


apiaccesscontrol_service_cli.apiaccesscontrol_service_group.add_command(privileged_api_requests_root_group)
privileged_api_requests_root_group.add_command(privileged_api_request_collection_group)
privileged_api_requests_root_group.add_command(privileged_api_request_group)


@privileged_api_request_group.command(name=cli_util.override('privileged_api_requests.approve_privileged_api_request.command_name', 'approve'), help=u"""Approves privilegedApi request. \n[Command Reference](approvePrivilegedApiRequest)""")
@cli_util.option('--privileged-api-request-id', required=True, help=u"""unique PrivilegedApiRequest identifier""")
@cli_util.option('--approver-comment', help=u"""Comment by the approver during approval.""")
@cli_util.option('--time-of-user-creation', type=custom_types.CLI_DATETIME, help=u"""The time when access request is scheduled to be approved in [RFC 3339] timestamp format.Example: '2020-05-22T21:10:29.600Z'""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def approve_privileged_api_request(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, privileged_api_request_id, approver_comment, time_of_user_creation, if_match):

    if isinstance(privileged_api_request_id, six.string_types) and len(privileged_api_request_id.strip()) == 0:
        raise click.UsageError('Parameter --privileged-api-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if approver_comment is not None:
        _details['approverComment'] = approver_comment

    if time_of_user_creation is not None:
        _details['timeOfUserCreation'] = time_of_user_creation

    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_requests', ctx)
    result = client.approve_privileged_api_request(
        privileged_api_request_id=privileged_api_request_id,
        approve_privileged_api_request_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@privileged_api_request_group.command(name=cli_util.override('privileged_api_requests.close_privileged_api_request.command_name', 'close'), help=u"""Closes privilegedApi request. \n[Command Reference](closePrivilegedApiRequest)""")
@cli_util.option('--privileged-api-request-id', required=True, help=u"""unique PrivilegedApiRequest identifier""")
@cli_util.option('--description', help=u"""description about why the request is closed""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def close_privileged_api_request(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, privileged_api_request_id, description, if_match):

    if isinstance(privileged_api_request_id, six.string_types) and len(privileged_api_request_id.strip()) == 0:
        raise click.UsageError('Parameter --privileged-api-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if description is not None:
        _details['description'] = description

    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_requests', ctx)
    result = client.close_privileged_api_request(
        privileged_api_request_id=privileged_api_request_id,
        close_privileged_api_request_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@privileged_api_request_group.command(name=cli_util.override('privileged_api_requests.create_privileged_api_request.command_name', 'create'), help=u"""Creates a PrivilegedApiRequest. \n[Command Reference](createPrivilegedApiRequest)""")
@cli_util.option('--reason-summary', required=True, help=u"""Summary comment by the operator creating the access request.""")
@cli_util.option('--resource-id', required=True, help=u"""The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.""")
@cli_util.option('--privileged-operation-list', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of api names, attributes for which approval is sought by the user.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment.""")
@cli_util.option('--sub-resource-name-list', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The subresource names requested for approval.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--notification-topic-id', help=u"""The OCID of the OCI Notification topic to publish messages related to this Privileged Api Request.""")
@cli_util.option('--reason-detail', help=u"""Reason in detail for which the operator is requesting access on the target resource.""")
@cli_util.option('--severity', type=custom_types.CliCaseInsensitiveChoice(["SEV_1", "SEV_2", "SEV_3", "SEV_4"]), help=u"""Priority assigned to the access request by the operator""")
@cli_util.option('--duration-in-hrs', type=click.INT, help=u"""Duration in hours for which access is sought on the target resource.""")
@cli_util.option('--ticket-numbers', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--time-requested-for-future-access', type=custom_types.CLI_DATETIME, help=u"""Time in future when the user for the privilegedApi request needs to be created in [RFC 3339]timestamp format. Example: '2020-05-22T21:10:29.600Z'""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'sub-resource-name-list': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'privileged-operation-list': {'module': 'apiaccesscontrol', 'class': 'list[PrivilegedApiRequestOperationDetails]'}, 'ticket-numbers': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'sub-resource-name-list': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'privileged-operation-list': {'module': 'apiaccesscontrol', 'class': 'list[PrivilegedApiRequestOperationDetails]'}, 'ticket-numbers': {'module': 'apiaccesscontrol', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apiaccesscontrol', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'apiaccesscontrol', 'class': 'PrivilegedApiRequest'})
@cli_util.wrap_exceptions
def create_privileged_api_request(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, reason_summary, resource_id, privileged_operation_list, compartment_id, sub_resource_name_list, notification_topic_id, reason_detail, severity, duration_in_hrs, ticket_numbers, time_requested_for_future_access, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['reasonSummary'] = reason_summary
    _details['resourceId'] = resource_id
    _details['privilegedOperationList'] = cli_util.parse_json_parameter("privileged_operation_list", privileged_operation_list)

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if sub_resource_name_list is not None:
        _details['subResourceNameList'] = cli_util.parse_json_parameter("sub_resource_name_list", sub_resource_name_list)

    if notification_topic_id is not None:
        _details['notificationTopicId'] = notification_topic_id

    if reason_detail is not None:
        _details['reasonDetail'] = reason_detail

    if severity is not None:
        _details['severity'] = severity

    if duration_in_hrs is not None:
        _details['durationInHrs'] = duration_in_hrs

    if ticket_numbers is not None:
        _details['ticketNumbers'] = cli_util.parse_json_parameter("ticket_numbers", ticket_numbers)

    if time_requested_for_future_access is not None:
        _details['timeRequestedForFutureAccess'] = time_requested_for_future_access

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_requests', ctx)
    result = client.create_privileged_api_request(
        create_privileged_api_request_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@privileged_api_request_group.command(name=cli_util.override('privileged_api_requests.get_privileged_api_request.command_name', 'get'), help=u"""Gets information about a PrivilegedApiRequest. \n[Command Reference](getPrivilegedApiRequest)""")
@cli_util.option('--privileged-api-request-id', required=True, help=u"""unique PrivilegedApiRequest identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apiaccesscontrol', 'class': 'PrivilegedApiRequest'})
@cli_util.wrap_exceptions
def get_privileged_api_request(ctx, from_json, privileged_api_request_id):

    if isinstance(privileged_api_request_id, six.string_types) and len(privileged_api_request_id.strip()) == 0:
        raise click.UsageError('Parameter --privileged-api-request-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_requests', ctx)
    result = client.get_privileged_api_request(
        privileged_api_request_id=privileged_api_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@privileged_api_request_collection_group.command(name=cli_util.override('privileged_api_requests.list_privileged_api_requests.command_name', 'list-privileged-api-requests'), help=u"""Lists all privilegedApi requests in the compartment. \n[Command Reference](listPrivilegedApiRequests)""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--id', help=u"""The [OCID] of the PrivilegedApiRequest.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the given display name exactly.""")
@cli_util.option('--resource-id', help=u"""The [OCID] of the resource .""")
@cli_util.option('--resource-type', help=u"""A filter to return only lists of resources that match the entire given service type.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "NEEDS_ATTENTION"]), help=u"""A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--state', type=custom_types.CliCaseInsensitiveChoice(["CREATED", "APPROVAL_WAITING", "APPROVED", "APPROVED_FOR_FUTURE", "REJECTED", "DEPLOYED", "DEPLOY_FAILED", "CLOSE_FAILED", "REVOKE_FAILED", "EXPIRY_FAILED", "REVOKING", "REVOKED", "CLOSING", "CLOSED", "EXPIRED"]), help=u"""A filter to return only resources that match the state. The state value is case-insensitive.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--page', help=u"""For list pagination. The value of the opc-next-page response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. You can provide only one sort order. Default order for `timeCreated` is descending. Default order for `displayName` is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apiaccesscontrol', 'class': 'PrivilegedApiRequestCollection'})
@cli_util.wrap_exceptions
def list_privileged_api_requests(ctx, from_json, all_pages, page_size, compartment_id, id, display_name, resource_id, resource_type, lifecycle_state, state, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if id is not None:
        kwargs['id'] = id
    if display_name is not None:
        kwargs['display_name'] = display_name
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if resource_type is not None:
        kwargs['resource_type'] = resource_type
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if state is not None:
        kwargs['state'] = state
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_requests', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_privileged_api_requests,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_privileged_api_requests,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_privileged_api_requests(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@privileged_api_request_group.command(name=cli_util.override('privileged_api_requests.reject_privileged_api_request.command_name', 'reject'), help=u"""Rejects privilegedApi request. \n[Command Reference](rejectPrivilegedApiRequest)""")
@cli_util.option('--privileged-api-request-id', required=True, help=u"""unique PrivilegedApiRequest identifier""")
@cli_util.option('--approver-comment', help=u"""Comment by the approver explaining why the request is rejected.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def reject_privileged_api_request(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, privileged_api_request_id, approver_comment, if_match):

    if isinstance(privileged_api_request_id, six.string_types) and len(privileged_api_request_id.strip()) == 0:
        raise click.UsageError('Parameter --privileged-api-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if approver_comment is not None:
        _details['approverComment'] = approver_comment

    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_requests', ctx)
    result = client.reject_privileged_api_request(
        privileged_api_request_id=privileged_api_request_id,
        reject_privileged_api_request_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@privileged_api_request_group.command(name=cli_util.override('privileged_api_requests.revoke_privileged_api_request.command_name', 'revoke'), help=u"""Revokes an already approved privilegedApi request. \n[Command Reference](revokePrivilegedApiRequest)""")
@cli_util.option('--privileged-api-request-id', required=True, help=u"""unique PrivilegedApiRequest identifier""")
@cli_util.option('--approver-comment', help=u"""Comment specified by the approver explaining why the approval is revoked.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def revoke_privileged_api_request(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, privileged_api_request_id, approver_comment, if_match):

    if isinstance(privileged_api_request_id, six.string_types) and len(privileged_api_request_id.strip()) == 0:
        raise click.UsageError('Parameter --privileged-api-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if approver_comment is not None:
        _details['approverComment'] = approver_comment

    client = cli_util.build_client('apiaccesscontrol', 'privileged_api_requests', ctx)
    result = client.revoke_privileged_api_request(
        privileged_api_request_id=privileged_api_request_id,
        revoke_privileged_api_request_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
