# jfjoch-client
API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland).
Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU.
Jungfraujoch uses FPGA boards to acquire data at high data rates.

# License Clarification

While this API definition is licensed under GPL-3.0, **the GPL copyleft provisions do not apply**
when this file is used solely to generate OpenAPI clients or when implementing applications that
interact with the API. Generated client code and applications using this API definition are not
subject to the GPL license requirements and may be distributed under terms of your choosing.

This exception is similar in spirit to the Linux Kernel's approach to userspace API headers and
the GCC Runtime Library Exception. The Linux Kernel developers have explicitly stated that
user programs that merely use the kernel interfaces (syscalls, ioctl definitions, etc.) are not
derivative works of the kernel and are not subject to the terms of the GPL.

This exception is intended to allow wider use of this API specification without imposing GPL
requirements on applications that merely interact with the API, regardless of whether they
communicate through network calls or other mechanisms.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0-rc.104
- Package version: 1.0.0-rc.104
- Generator version: 7.8.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://git.psi.ch/jungfraujoch/jungfraujoch.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://git.psi.ch/jungfraujoch/jungfraujoch.git`)

Then import the package:
```python
import jfjoch_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import jfjoch_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import jfjoch_client
from jfjoch_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:5232
# See configuration.py for a list of all supported configuration parameters.
configuration = jfjoch_client.Configuration(
    host = "http://localhost:5232"
)



# Enter a context with an instance of the API client
with jfjoch_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = jfjoch_client.DefaultApi(api_client)

    try:
        # Cancel running data collection
        api_instance.cancel_post()
    except ApiException as e:
        print("Exception when calling DefaultApi->cancel_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:5232*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**cancel_post**](docs/DefaultApi.md#cancel_post) | **POST** /cancel | Cancel running data collection
*DefaultApi* | [**config_azim_int_get**](docs/DefaultApi.md#config_azim_int_get) | **GET** /config/azim_int | Get azimuthal integration configuration
*DefaultApi* | [**config_azim_int_put**](docs/DefaultApi.md#config_azim_int_put) | **PUT** /config/azim_int | Configure azimuthal integration
*DefaultApi* | [**config_dark_mask_get**](docs/DefaultApi.md#config_dark_mask_get) | **GET** /config/dark_mask | Get settings for dark data collection to calculate mask
*DefaultApi* | [**config_dark_mask_put**](docs/DefaultApi.md#config_dark_mask_put) | **PUT** /config/dark_mask | Set configuration for dark data collection to calculate mask
*DefaultApi* | [**config_detector_get**](docs/DefaultApi.md#config_detector_get) | **GET** /config/detector | Get detector configuration
*DefaultApi* | [**config_detector_put**](docs/DefaultApi.md#config_detector_put) | **PUT** /config/detector | Change detector configuration
*DefaultApi* | [**config_file_writer_get**](docs/DefaultApi.md#config_file_writer_get) | **GET** /config/file_writer | Get file writer settings
*DefaultApi* | [**config_file_writer_put**](docs/DefaultApi.md#config_file_writer_put) | **PUT** /config/file_writer | Change file writer settings
*DefaultApi* | [**config_image_format_conversion_post**](docs/DefaultApi.md#config_image_format_conversion_post) | **POST** /config/image_format/conversion | Configure format for data collection with full conversion
*DefaultApi* | [**config_image_format_get**](docs/DefaultApi.md#config_image_format_get) | **GET** /config/image_format | Get image output format
*DefaultApi* | [**config_image_format_put**](docs/DefaultApi.md#config_image_format_put) | **PUT** /config/image_format | Change image output format
*DefaultApi* | [**config_image_format_raw_post**](docs/DefaultApi.md#config_image_format_raw_post) | **POST** /config/image_format/raw | Configure format for raw data collection
*DefaultApi* | [**config_indexing_get**](docs/DefaultApi.md#config_indexing_get) | **GET** /config/indexing | Get indexing configuration
*DefaultApi* | [**config_indexing_put**](docs/DefaultApi.md#config_indexing_put) | **PUT** /config/indexing | Change indexing algorithm settings
*DefaultApi* | [**config_instrument_get**](docs/DefaultApi.md#config_instrument_get) | **GET** /config/instrument | Get instrument metadata
*DefaultApi* | [**config_instrument_put**](docs/DefaultApi.md#config_instrument_put) | **PUT** /config/instrument | Change instrument metadata
*DefaultApi* | [**config_internal_generator_image_put**](docs/DefaultApi.md#config_internal_generator_image_put) | **PUT** /config/internal_generator_image | Load binary image for internal FPGA generator
*DefaultApi* | [**config_internal_generator_image_tiff_put**](docs/DefaultApi.md#config_internal_generator_image_tiff_put) | **PUT** /config/internal_generator_image.tiff | Load TIFF image for internal FPGA generator
*DefaultApi* | [**config_mask_get**](docs/DefaultApi.md#config_mask_get) | **GET** /config/mask | Get mask of the detector (binary)
*DefaultApi* | [**config_mask_tiff_get**](docs/DefaultApi.md#config_mask_tiff_get) | **GET** /config/mask.tiff | Get mask of the detector (TIFF)
*DefaultApi* | [**config_roi_get**](docs/DefaultApi.md#config_roi_get) | **GET** /config/roi | Get ROI definitions
*DefaultApi* | [**config_roi_put**](docs/DefaultApi.md#config_roi_put) | **PUT** /config/roi | Upload ROI definitions
*DefaultApi* | [**config_select_detector_get**](docs/DefaultApi.md#config_select_detector_get) | **GET** /config/select_detector | List available detectors
*DefaultApi* | [**config_select_detector_put**](docs/DefaultApi.md#config_select_detector_put) | **PUT** /config/select_detector | Select detector
*DefaultApi* | [**config_spot_finding_get**](docs/DefaultApi.md#config_spot_finding_get) | **GET** /config/spot_finding | Get data processing configuration
*DefaultApi* | [**config_spot_finding_put**](docs/DefaultApi.md#config_spot_finding_put) | **PUT** /config/spot_finding | Configure spot finding
*DefaultApi* | [**config_user_mask_get**](docs/DefaultApi.md#config_user_mask_get) | **GET** /config/user_mask | Detector must be Initialized. Get user mask of the detector (binary) 
*DefaultApi* | [**config_user_mask_put**](docs/DefaultApi.md#config_user_mask_put) | **PUT** /config/user_mask | Upload user mask of the detector (binary)
*DefaultApi* | [**config_user_mask_tiff_get**](docs/DefaultApi.md#config_user_mask_tiff_get) | **GET** /config/user_mask.tiff | Detector must be Initialized. Get user mask of the detector (TIFF) 
*DefaultApi* | [**config_user_mask_tiff_put**](docs/DefaultApi.md#config_user_mask_tiff_put) | **PUT** /config/user_mask.tiff | Upload user mask of the detector
*DefaultApi* | [**config_zeromq_metadata_get**](docs/DefaultApi.md#config_zeromq_metadata_get) | **GET** /config/zeromq_metadata | Get ZeroMQ metadata socket settings
*DefaultApi* | [**config_zeromq_metadata_put**](docs/DefaultApi.md#config_zeromq_metadata_put) | **PUT** /config/zeromq_metadata | Set ZeroMQ metadata settings
*DefaultApi* | [**config_zeromq_preview_get**](docs/DefaultApi.md#config_zeromq_preview_get) | **GET** /config/zeromq_preview | Get ZeroMQ preview settings
*DefaultApi* | [**config_zeromq_preview_put**](docs/DefaultApi.md#config_zeromq_preview_put) | **PUT** /config/zeromq_preview | Set ZeroMQ preview settings
*DefaultApi* | [**deactivate_post**](docs/DefaultApi.md#deactivate_post) | **POST** /deactivate | Prepare detector to turn off
*DefaultApi* | [**detector_status_get**](docs/DefaultApi.md#detector_status_get) | **GET** /detector/status | Get detector status
*DefaultApi* | [**fpga_status_get**](docs/DefaultApi.md#fpga_status_get) | **GET** /fpga_status | Get status of FPGA devices
*DefaultApi* | [**image_buffer_clear_post**](docs/DefaultApi.md#image_buffer_clear_post) | **POST** /image_buffer/clear | Clear image buffer
*DefaultApi* | [**image_buffer_image_cbor_get**](docs/DefaultApi.md#image_buffer_image_cbor_get) | **GET** /image_buffer/image.cbor | Get image message in CBOR format
*DefaultApi* | [**image_buffer_image_jpeg_get**](docs/DefaultApi.md#image_buffer_image_jpeg_get) | **GET** /image_buffer/image.jpeg | Get preview image in JPEG format using custom settings
*DefaultApi* | [**image_buffer_image_tiff_get**](docs/DefaultApi.md#image_buffer_image_tiff_get) | **GET** /image_buffer/image.tiff | Get preview image in TIFF format
*DefaultApi* | [**image_buffer_start_cbor_get**](docs/DefaultApi.md#image_buffer_start_cbor_get) | **GET** /image_buffer/start.cbor | Get Start message in CBOR format
*DefaultApi* | [**image_buffer_status_get**](docs/DefaultApi.md#image_buffer_status_get) | **GET** /image_buffer/status | Get status of the image buffers
*DefaultApi* | [**initialize_post**](docs/DefaultApi.md#initialize_post) | **POST** /initialize | Initialize detector and data acquisition
*DefaultApi* | [**pedestal_post**](docs/DefaultApi.md#pedestal_post) | **POST** /pedestal | Collect dark current for the detector
*DefaultApi* | [**preview_pedestal_tiff_get**](docs/DefaultApi.md#preview_pedestal_tiff_get) | **GET** /preview/pedestal.tiff | Get pedestal in TIFF format
*DefaultApi* | [**preview_plot_get**](docs/DefaultApi.md#preview_plot_get) | **GET** /preview/plot | Generate 1D plot from Jungfraujoch
*DefaultApi* | [**result_scan_get**](docs/DefaultApi.md#result_scan_get) | **GET** /result/scan | Get full scan result
*DefaultApi* | [**start_post**](docs/DefaultApi.md#start_post) | **POST** /start | Start detector
*DefaultApi* | [**statistics_calibration_get**](docs/DefaultApi.md#statistics_calibration_get) | **GET** /statistics/calibration | Get calibration statistics
*DefaultApi* | [**statistics_data_collection_get**](docs/DefaultApi.md#statistics_data_collection_get) | **GET** /statistics/data_collection | Get data collection statistics
*DefaultApi* | [**statistics_get**](docs/DefaultApi.md#statistics_get) | **GET** /statistics | Get general statistics
*DefaultApi* | [**status_get**](docs/DefaultApi.md#status_get) | **GET** /status | Get Jungfraujoch status
*DefaultApi* | [**trigger_post**](docs/DefaultApi.md#trigger_post) | **POST** /trigger | Send soft trigger to the detector
*DefaultApi* | [**version_get**](docs/DefaultApi.md#version_get) | **GET** /version | Get Jungfraujoch version of jfjoch_broker
*DefaultApi* | [**wait_till_done_post**](docs/DefaultApi.md#wait_till_done_post) | **POST** /wait_till_done | Wait for acquisition done
*DefaultApi* | [**xfel_event_code_get**](docs/DefaultApi.md#xfel_event_code_get) | **GET** /xfel/event_code | Return XFEL event codes for the current data acquisition
*DefaultApi* | [**xfel_pulse_id_get**](docs/DefaultApi.md#xfel_pulse_id_get) | **GET** /xfel/pulse_id | Return XFEL pulse IDs for the current data acquisition


## Documentation For Models

 - [AzimIntSettings](docs/AzimIntSettings.md)
 - [BrokerStatus](docs/BrokerStatus.md)
 - [CalibrationStatisticsInner](docs/CalibrationStatisticsInner.md)
 - [DarkMaskSettings](docs/DarkMaskSettings.md)
 - [DatasetSettings](docs/DatasetSettings.md)
 - [DatasetSettingsXrayFluorescenceSpectrum](docs/DatasetSettingsXrayFluorescenceSpectrum.md)
 - [Detector](docs/Detector.md)
 - [DetectorList](docs/DetectorList.md)
 - [DetectorListElement](docs/DetectorListElement.md)
 - [DetectorModule](docs/DetectorModule.md)
 - [DetectorModuleDirection](docs/DetectorModuleDirection.md)
 - [DetectorPowerState](docs/DetectorPowerState.md)
 - [DetectorSelection](docs/DetectorSelection.md)
 - [DetectorSettings](docs/DetectorSettings.md)
 - [DetectorState](docs/DetectorState.md)
 - [DetectorStatus](docs/DetectorStatus.md)
 - [DetectorTiming](docs/DetectorTiming.md)
 - [DetectorType](docs/DetectorType.md)
 - [ErrorMessage](docs/ErrorMessage.md)
 - [FileWriterFormat](docs/FileWriterFormat.md)
 - [FileWriterSettings](docs/FileWriterSettings.md)
 - [FpgaStatusInner](docs/FpgaStatusInner.md)
 - [GeomRefinementAlgorithm](docs/GeomRefinementAlgorithm.md)
 - [GridScan](docs/GridScan.md)
 - [ImageBufferStatus](docs/ImageBufferStatus.md)
 - [ImageFormatSettings](docs/ImageFormatSettings.md)
 - [ImagePusherType](docs/ImagePusherType.md)
 - [IndexingAlgorithm](docs/IndexingAlgorithm.md)
 - [IndexingSettings](docs/IndexingSettings.md)
 - [InstrumentMetadata](docs/InstrumentMetadata.md)
 - [JfjochSettings](docs/JfjochSettings.md)
 - [JfjochSettingsSsl](docs/JfjochSettingsSsl.md)
 - [JfjochStatistics](docs/JfjochStatistics.md)
 - [MeasurementStatistics](docs/MeasurementStatistics.md)
 - [PcieDevicesInner](docs/PcieDevicesInner.md)
 - [PixelMaskStatistics](docs/PixelMaskStatistics.md)
 - [Plot](docs/Plot.md)
 - [PlotUnitX](docs/PlotUnitX.md)
 - [Plots](docs/Plots.md)
 - [RoiAzimList](docs/RoiAzimList.md)
 - [RoiAzimuthal](docs/RoiAzimuthal.md)
 - [RoiBox](docs/RoiBox.md)
 - [RoiBoxList](docs/RoiBoxList.md)
 - [RoiCircle](docs/RoiCircle.md)
 - [RoiCircleList](docs/RoiCircleList.md)
 - [RoiDefinitions](docs/RoiDefinitions.md)
 - [RotationAxis](docs/RotationAxis.md)
 - [ScanResult](docs/ScanResult.md)
 - [ScanResultImagesInner](docs/ScanResultImagesInner.md)
 - [SpotFindingSettings](docs/SpotFindingSettings.md)
 - [StandardDetectorGeometry](docs/StandardDetectorGeometry.md)
 - [UnitCell](docs/UnitCell.md)
 - [ZeromqMetadataSettings](docs/ZeromqMetadataSettings.md)
 - [ZeromqPreviewSettings](docs/ZeromqPreviewSettings.md)
 - [ZeromqSettings](docs/ZeromqSettings.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author

filip.leonarski@psi.ch


