# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates.  # License Clarification  While this API definition is licensed under GPL-3.0, **the GPL copyleft provisions do not apply** when this file is used solely to generate OpenAPI clients or when implementing applications that interact with the API. Generated client code and applications using this API definition are not subject to the GPL license requirements and may be distributed under terms of your choosing.  This exception is similar in spirit to the Linux Kernel's approach to userspace API headers and the GCC Runtime Library Exception. The Linux Kernel developers have explicitly stated that user programs that merely use the kernel interfaces (syscalls, ioctl definitions, etc.) are not derivative works of the kernel and are not subject to the terms of the GPL.  This exception is intended to allow wider use of this API specification without imposing GPL requirements on applications that merely interact with the API, regardless of whether they communicate through network calls or other mechanisms. 

    The version of the OpenAPI document: 1.0.0-rc.104
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class DarkMaskSettings(BaseModel):
    """
    Settings for collection of dark images to be used for mask calculation
    """ # noqa: E501
    detector_threshold_ke_v: Union[Annotated[float, Field(le=100.0, strict=True, ge=2.5)], Annotated[int, Field(le=100, strict=True, ge=3)]] = Field(description="Energy threshold for dark image collection", alias="detector_threshold_keV")
    frame_time_us: Annotated[int, Field(le=100000, strict=True, ge=500)] = Field(description="Time between frames for dark image collection")
    number_of_frames: Annotated[int, Field(strict=True, ge=0)] = Field(description="Number of frames for dark image collection; zero means no dark collection")
    max_allowed_pixel_count: Annotated[int, Field(strict=True, ge=0)] = Field(description="Maximum count in a pixel considered normal (not-masked)")
    max_frames_with_signal: Annotated[int, Field(strict=True, ge=0)] = Field(description="Maximum number of frames with signal in a pixel considered normal (not-masked)")
    __properties: ClassVar[List[str]] = ["detector_threshold_keV", "frame_time_us", "number_of_frames", "max_allowed_pixel_count", "max_frames_with_signal"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DarkMaskSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DarkMaskSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "detector_threshold_keV": obj.get("detector_threshold_keV") if obj.get("detector_threshold_keV") is not None else 3.5,
            "frame_time_us": obj.get("frame_time_us") if obj.get("frame_time_us") is not None else 10000,
            "number_of_frames": obj.get("number_of_frames") if obj.get("number_of_frames") is not None else 1000,
            "max_allowed_pixel_count": obj.get("max_allowed_pixel_count") if obj.get("max_allowed_pixel_count") is not None else 1,
            "max_frames_with_signal": obj.get("max_frames_with_signal") if obj.get("max_frames_with_signal") is not None else 10
        })
        return _obj


