# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates.  # License Clarification  While this API definition is licensed under GPL-3.0, **the GPL copyleft provisions do not apply** when this file is used solely to generate OpenAPI clients or when implementing applications that interact with the API. Generated client code and applications using this API definition are not subject to the GPL license requirements and may be distributed under terms of your choosing.  This exception is similar in spirit to the Linux Kernel's approach to userspace API headers and the GCC Runtime Library Exception. The Linux Kernel developers have explicitly stated that user programs that merely use the kernel interfaces (syscalls, ioctl definitions, etc.) are not derivative works of the kernel and are not subject to the terms of the GPL.  This exception is intended to allow wider use of this API specification without imposing GPL requirements on applications that merely interact with the API, regardless of whether they communicate through network calls or other mechanisms. 

    The version of the OpenAPI document: 1.0.0-rc.104
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class FpgaStatusInner(BaseModel):
    """
    FpgaStatusInner
    """ # noqa: E501
    pci_dev_id: StrictStr
    serial_number: StrictStr
    fw_version: StrictStr
    base_mac_addr: StrictStr
    eth_link_count: StrictInt
    eth_link_status: StrictInt
    power_usage_w: Union[StrictFloat, StrictInt] = Field(alias="power_usage_W")
    fpga_temp_c: Union[StrictFloat, StrictInt] = Field(alias="fpga_temp_C")
    hbm_temp_c: Union[StrictFloat, StrictInt] = Field(alias="hbm_temp_C")
    packets_udp: StrictInt
    packets_sls: StrictInt
    idle: StrictBool
    pcie_link_speed: StrictInt = Field(description="PCIe link speed measured by generation (expected value is 4 == PCIe Gen4)")
    pcie_link_width: StrictInt = Field(description="PCIe link width (expected value is 8 == x8)")
    __properties: ClassVar[List[str]] = ["pci_dev_id", "serial_number", "fw_version", "base_mac_addr", "eth_link_count", "eth_link_status", "power_usage_W", "fpga_temp_C", "hbm_temp_C", "packets_udp", "packets_sls", "idle", "pcie_link_speed", "pcie_link_width"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FpgaStatusInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FpgaStatusInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pci_dev_id": obj.get("pci_dev_id"),
            "serial_number": obj.get("serial_number"),
            "fw_version": obj.get("fw_version"),
            "base_mac_addr": obj.get("base_mac_addr"),
            "eth_link_count": obj.get("eth_link_count"),
            "eth_link_status": obj.get("eth_link_status"),
            "power_usage_W": obj.get("power_usage_W"),
            "fpga_temp_C": obj.get("fpga_temp_C"),
            "hbm_temp_C": obj.get("hbm_temp_C"),
            "packets_udp": obj.get("packets_udp"),
            "packets_sls": obj.get("packets_sls"),
            "idle": obj.get("idle"),
            "pcie_link_speed": obj.get("pcie_link_speed"),
            "pcie_link_width": obj.get("pcie_link_width")
        })
        return _obj


