# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates.  # License Clarification  While this API definition is licensed under GPL-3.0, **the GPL copyleft provisions do not apply** when this file is used solely to generate OpenAPI clients or when implementing applications that interact with the API. Generated client code and applications using this API definition are not subject to the GPL license requirements and may be distributed under terms of your choosing.  This exception is similar in spirit to the Linux Kernel's approach to userspace API headers and the GCC Runtime Library Exception. The Linux Kernel developers have explicitly stated that user programs that merely use the kernel interfaces (syscalls, ioctl definitions, etc.) are not derivative works of the kernel and are not subject to the terms of the GPL.  This exception is intended to allow wider use of this API specification without imposing GPL requirements on applications that merely interact with the API, regardless of whether they communicate through network calls or other mechanisms. 

    The version of the OpenAPI document: 1.0.0-rc.104
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class SpotFindingSettings(BaseModel):
    """
    SpotFindingSettings
    """ # noqa: E501
    enable: StrictBool = Field(description="Enable spot finding. This is temporary setting, i.e. can be changed anytime during data collection.  Even if disabled spot finding information will still be send and written, though always with zero spots. ")
    indexing: StrictBool = Field(description="Enable indexing. This is temporary setting, i.e. can be changed anytime during data collection. ")
    signal_to_noise_threshold: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]
    photon_count_threshold: Annotated[int, Field(strict=True, ge=0)]
    min_pix_per_spot: Annotated[int, Field(strict=True, ge=1)]
    max_pix_per_spot: Annotated[int, Field(strict=True, ge=1)]
    high_resolution_limit: Union[StrictFloat, StrictInt] = Field(description="High resolution limit for spot finding [Angstrom]")
    low_resolution_limit: Union[StrictFloat, StrictInt] = Field(description="Low resolution limit for spot finding [Angstrom]")
    high_resolution_limit_for_spot_count_low_res: Union[Annotated[float, Field(le=8.0, strict=True, ge=2.0)], Annotated[int, Field(le=8, strict=True, ge=2)]] = Field(description="High resolution threshold to consider spot \"low resolution\" [Angstrom]")
    quick_integration: StrictBool = Field(description="Quick integration of Bragg spots in diffraction images. If enabled it will likely reduce performance of Jungfraujoch for datasets with a very high indexing rate. (experimental feature) ")
    ice_ring_width_q_recip_a: Union[Annotated[float, Field(le=1.0, strict=True, ge=0.0)], Annotated[int, Field(le=1, strict=True, ge=0)]] = Field(description="Width of ice ring in q-space in reciprocal space", alias="ice_ring_width_q_recipA")
    high_res_gap_q_recip_a: Optional[Union[Annotated[float, Field(le=5.0, strict=True, ge=0.1)], Annotated[int, Field(le=5, strict=True, ge=1)]]] = Field(default=1.5, description="This parameter is used to remove spurious spots at a very high resolution, that sometimes appear due to very low background close to the edge of the detector. If there is a gap in (1/d)-space between spots of at least this size, spots on the side of the gap with high resolution will be discarded. This is optional parameter. This option should be turned OFF for small molecule datasets or for crystals with very low mosaicity, when it is expected to see only few spots in any case. ", alias="high_res_gap_Q_recipA")
    __properties: ClassVar[List[str]] = ["enable", "indexing", "signal_to_noise_threshold", "photon_count_threshold", "min_pix_per_spot", "max_pix_per_spot", "high_resolution_limit", "low_resolution_limit", "high_resolution_limit_for_spot_count_low_res", "quick_integration", "ice_ring_width_q_recipA", "high_res_gap_Q_recipA"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpotFindingSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpotFindingSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enable": obj.get("enable") if obj.get("enable") is not None else True,
            "indexing": obj.get("indexing") if obj.get("indexing") is not None else True,
            "signal_to_noise_threshold": obj.get("signal_to_noise_threshold"),
            "photon_count_threshold": obj.get("photon_count_threshold"),
            "min_pix_per_spot": obj.get("min_pix_per_spot"),
            "max_pix_per_spot": obj.get("max_pix_per_spot"),
            "high_resolution_limit": obj.get("high_resolution_limit"),
            "low_resolution_limit": obj.get("low_resolution_limit"),
            "high_resolution_limit_for_spot_count_low_res": obj.get("high_resolution_limit_for_spot_count_low_res"),
            "quick_integration": obj.get("quick_integration") if obj.get("quick_integration") is not None else False,
            "ice_ring_width_q_recipA": obj.get("ice_ring_width_q_recipA") if obj.get("ice_ring_width_q_recipA") is not None else 0.02,
            "high_res_gap_Q_recipA": obj.get("high_res_gap_Q_recipA") if obj.get("high_res_gap_Q_recipA") is not None else 1.5
        })
        return _obj


