# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates.  # License Clarification  While this API definition is licensed under GPL-3.0, **the GPL copyleft provisions do not apply** when this file is used solely to generate OpenAPI clients or when implementing applications that interact with the API. Generated client code and applications using this API definition are not subject to the GPL license requirements and may be distributed under terms of your choosing.  This exception is similar in spirit to the Linux Kernel's approach to userspace API headers and the GCC Runtime Library Exception. The Linux Kernel developers have explicitly stated that user programs that merely use the kernel interfaces (syscalls, ioctl definitions, etc.) are not derivative works of the kernel and are not subject to the terms of the GPL.  This exception is intended to allow wider use of this API specification without imposing GPL requirements on applications that merely interact with the API, regardless of whether they communicate through network calls or other mechanisms. 

    The version of the OpenAPI document: 1.0.0-rc.104
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from jfjoch_client.models.detector_list import DetectorList

class TestDetectorList(unittest.TestCase):
    """DetectorList unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> DetectorList:
        """Test DetectorList
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `DetectorList`
        """
        model = DetectorList()
        if include_optional:
            return DetectorList(
                detectors = [
                    jfjoch_client.models.detector_list_element.detector_list_element(
                        id = 0, 
                        description = 'JUNGFRAU 4 Mpixel', 
                        serial_number = 'JF17T16V01', 
                        base_ipv4_addr = '10.10.10.1', 
                        udp_interface_count = 2, 
                        nmodules = 18, 
                        width = 2068, 
                        height = 2164, 
                        pixel_size_mm = 0.075, 
                        readout_time_us = 56, 
                        min_frame_time_us = 56, 
                        min_count_time_us = 56, 
                        type = 'EIGER', )
                    ],
                current_id = 0
            )
        else:
            return DetectorList(
                detectors = [
                    jfjoch_client.models.detector_list_element.detector_list_element(
                        id = 0, 
                        description = 'JUNGFRAU 4 Mpixel', 
                        serial_number = 'JF17T16V01', 
                        base_ipv4_addr = '10.10.10.1', 
                        udp_interface_count = 2, 
                        nmodules = 18, 
                        width = 2068, 
                        height = 2164, 
                        pixel_size_mm = 0.075, 
                        readout_time_us = 56, 
                        min_frame_time_us = 56, 
                        min_count_time_us = 56, 
                        type = 'EIGER', )
                    ],
                current_id = 0,
        )
        """

    def testDetectorList(self):
        """Test DetectorList"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
