# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates.  # License Clarification  While this API definition is licensed under GPL-3.0, **the GPL copyleft provisions do not apply** when this file is used solely to generate OpenAPI clients or when implementing applications that interact with the API. Generated client code and applications using this API definition are not subject to the GPL license requirements and may be distributed under terms of your choosing.  This exception is similar in spirit to the Linux Kernel's approach to userspace API headers and the GCC Runtime Library Exception. The Linux Kernel developers have explicitly stated that user programs that merely use the kernel interfaces (syscalls, ioctl definitions, etc.) are not derivative works of the kernel and are not subject to the terms of the GPL.  This exception is intended to allow wider use of this API specification without imposing GPL requirements on applications that merely interact with the API, regardless of whether they communicate through network calls or other mechanisms. 

    The version of the OpenAPI document: 1.0.0-rc.104
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from jfjoch_client.models.jfjoch_statistics import JfjochStatistics

class TestJfjochStatistics(unittest.TestCase):
    """JfjochStatistics unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> JfjochStatistics:
        """Test JfjochStatistics
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `JfjochStatistics`
        """
        model = JfjochStatistics()
        if include_optional:
            return JfjochStatistics(
                detector = jfjoch_client.models.detector_status.detector_status(
                    state = 'Idle', 
                    powerchip = 'PowerOn', 
                    server_version = '', 
                    number_of_triggers_left = 56, 
                    fpga_temp_deg_c = [
                        56
                        ], 
                    high_voltage_v = [
                        56
                        ], ),
                detector_list = jfjoch_client.models.detector_list.detector_list(
                    detectors = [
                        jfjoch_client.models.detector_list_element.detector_list_element(
                            id = 0, 
                            description = 'JUNGFRAU 4 Mpixel', 
                            serial_number = 'JF17T16V01', 
                            base_ipv4_addr = '10.10.10.1', 
                            udp_interface_count = 2, 
                            nmodules = 18, 
                            width = 2068, 
                            height = 2164, 
                            pixel_size_mm = 0.075, 
                            readout_time_us = 56, 
                            min_frame_time_us = 56, 
                            min_count_time_us = 56, 
                            type = 'EIGER', )
                        ], 
                    current_id = 0, ),
                detector_settings = jfjoch_client.models.detector_settings.detector_settings(
                    frame_time_us = 1, 
                    count_time_us = 56, 
                    internal_frame_generator = True, 
                    internal_frame_generator_images = 1, 
                    detector_trigger_delay_ns = 0, 
                    timing = 'trigger', 
                    eiger_threshold_ke_v = 1.0, 
                    eiger_bit_depth = 8, 
                    jungfrau_pedestal_g0_frames = 0, 
                    jungfrau_pedestal_g1_frames = 0, 
                    jungfrau_pedestal_g2_frames = 0, 
                    jungfrau_pedestal_min_image_count = 32, 
                    jungfrau_storage_cell_count = 1, 
                    jungfrau_storage_cell_delay_ns = 2100, 
                    jungfrau_fixed_gain_g1 = True, 
                    jungfrau_use_gain_hg0 = True, ),
                image_format_settings = jfjoch_client.models.image_format_settings.image_format_settings(
                    summation = True, 
                    geometry_transform = True, 
                    jungfrau_conversion = True, 
                    jungfrau_conversion_factor_ke_v = 0.001, 
                    bit_depth_image = 8, 
                    signed_output = True, 
                    mask_module_edges = True, 
                    mask_chip_edges = True, 
                    jungfrau_mask_pixels_without_g0 = True, 
                    apply_mask = True, 
                    jungfrau_pedestal_g0_rms_limit = 0, ),
                instrument_metadata = jfjoch_client.models.instrument_metadata.instrument_metadata(
                    source_name = 'Swiss Light Source', 
                    source_type = '', 
                    instrument_name = 'CristallinaMX', 
                    pulsed_source = True, 
                    electron_source = True, ),
                file_writer_settings = jfjoch_client.models.file_writer_settings.file_writer_settings(
                    overwrite = True, 
                    format = 'NXmxLegacy', ),
                data_processing_settings = jfjoch_client.models.spot_finding_settings.spot_finding_settings(
                    enable = True, 
                    indexing = True, 
                    signal_to_noise_threshold = 0, 
                    photon_count_threshold = 0, 
                    min_pix_per_spot = 1, 
                    max_pix_per_spot = 1, 
                    high_resolution_limit = 1.337, 
                    low_resolution_limit = 1.337, 
                    high_resolution_limit_for_spot_count_low_res = 2.0, 
                    quick_integration = True, 
                    ice_ring_width_q_recip_a = 0.0, 
                    high_res_gap_q_recip_a = 0.1, ),
                measurement = jfjoch_client.models.measurement_statistics.measurement_statistics(
                    file_prefix = '', 
                    run_number = 56, 
                    experiment_group = '', 
                    images_expected = 56, 
                    images_collected = 56, 
                    images_sent = 56, 
                    images_discarded_lossy_compression = 56, 
                    max_image_number_sent = 56, 
                    collection_efficiency = 1.0, 
                    compression_ratio = 5.3, 
                    cancelled = True, 
                    max_receiver_delay = 56, 
                    indexing_rate = 1.337, 
                    detector_width = 56, 
                    detector_height = 56, 
                    detector_pixel_depth = 2, 
                    bkg_estimate = 1.337, 
                    unit_cell = '', 
                    error_pixels = 1.337, 
                    saturated_pixels = 1.337, 
                    roi_beam_pixels = 1.337, 
                    roi_beam_sum = 1.337, ),
                broker = jfjoch_client.models.broker_status.broker_status(
                    state = 'Inactive', 
                    progress = 1.0, 
                    message = '', 
                    message_severity = 'error', 
                    gpu_count = 56, ),
                fpga = [
                    jfjoch_client.models.fpga_status_inner.fpga_status_inner(
                        pci_dev_id = '', 
                        serial_number = '', 
                        fw_version = '', 
                        base_mac_addr = '', 
                        eth_link_count = 56, 
                        eth_link_status = 56, 
                        power_usage_w = 1.337, 
                        fpga_temp_c = 1.337, 
                        hbm_temp_c = 1.337, 
                        packets_udp = 56, 
                        packets_sls = 56, 
                        idle = True, 
                        pcie_link_speed = 56, 
                        pcie_link_width = 56, )
                    ],
                calibration = [
                    jfjoch_client.models.calibration_statistics_inner.calibration_statistics_inner(
                        module_number = 56, 
                        storage_cell_number = 56, 
                        pedestal_g0_mean = 1.337, 
                        pedestal_g1_mean = 1.337, 
                        pedestal_g2_mean = 1.337, 
                        gain_g0_mean = 1.337, 
                        gain_g1_mean = 1.337, 
                        gain_g2_mean = 1.337, 
                        masked_pixels = 56, )
                    ],
                zeromq_preview = jfjoch_client.models.zeromq_preview_settings.zeromq_preview_settings(
                    enabled = True, 
                    period_ms = 56, 
                    socket_address = '', ),
                zeromq_metadata = jfjoch_client.models.zeromq_metadata_settings.zeromq_metadata_settings(
                    enabled = True, 
                    period_ms = 1, 
                    socket_address = '', ),
                dark_mask = jfjoch_client.models.dark_mask_settings.dark_mask_settings(
                    detector_threshold_ke_v = 2.5, 
                    frame_time_us = 500, 
                    number_of_frames = 0, 
                    max_allowed_pixel_count = 0, 
                    max_frames_with_signal = 0, ),
                pixel_mask = jfjoch_client.models.pixel_mask_statistics.pixel_mask_statistics(
                    user_mask = 0, 
                    too_high_pedestal_rms = 0, 
                    wrong_gain = 0, ),
                roi = jfjoch_client.models.roi_definitions.roi_definitions(
                    box = jfjoch_client.models.roi_box_list.roi_box_list(
                        rois = [
                            jfjoch_client.models.roi_box.roi_box(
                                name = '0', 
                                min_x_pxl = 0, 
                                max_x_pxl = 0, 
                                min_y_pxl = 0, 
                                max_y_pxl = 0, )
                            ], ), 
                    circle = jfjoch_client.models.roi_circle_list.roi_circle_list(
                        rois = [
                            jfjoch_client.models.roi_circle.roi_circle(
                                name = '0', 
                                center_x_pxl = 1.337, 
                                center_y_pxl = 1.337, 
                                radius_pxl = 0.0, )
                            ], ), 
                    azim = jfjoch_client.models.roi_azim_list.roi_azim_list(), ),
                az_int = jfjoch_client.models.azim_int_settings.azim_int_settings(
                    polarization_corr = True, 
                    solid_angle_corr = True, 
                    high_q_recip_a = 1.337, 
                    low_q_recip_a = 1.337, 
                    q_spacing = 1.337, 
                    azimuthal_bins = 1, ),
                buffer = jfjoch_client.models.image_buffer_status.image_buffer_status(
                    min_image_number = 0, 
                    max_image_number = 0, 
                    image_numbers = [
                        56
                        ], 
                    total_slots = 56, 
                    available_slots = 56, ),
                indexing = jfjoch_client.models.indexing_settings.indexing_settings(
                    algorithm = 'FFBIDX', 
                    fft_max_unit_cell_a = 50, 
                    fft_min_unit_cell_a = 5, 
                    fft_high_resolution_a = 0.5, 
                    fft_num_vectors = 128, 
                    tolerance = 0.0, 
                    thread_count = 1, 
                    geom_refinement_algorithm = 'BeamCenter', 
                    unit_cell_dist_tolerance = 0.00010, 
                    viable_cell_min_spots = 5, 
                    index_ice_rings = True, )
            )
        else:
            return JfjochStatistics(
        )
        """

    def testJfjochStatistics(self):
        """Test JfjochStatistics"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
