/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_connect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class DynamicMethodExecutor {
    public static Object invokeMethod(String className, String methodName, String[] argValues, String[] argTypes) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (argValues.length != argTypes.length) {
            throw new IllegalArgumentException("Number of arguments does not match number of types");
        }
        Object[] convertedArgs = new Object[argValues.length];
        Class[] parameterTypes = new Class[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            parameterTypes[i] = DynamicMethodExecutor.getClassFromString(argTypes[i]);
            convertedArgs[i] = DynamicMethodExecutor.convertStringToType(argValues[i], parameterTypes[i]);
        }
        Class<?> clazz = Class.forName(className);
        try {
            method = clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            method = DynamicMethodExecutor.getMethodAsGeneric(clazz, methodName, parameterTypes.length);
        }
        return method.invoke(null, convertedArgs);
    }

    private static Method getMethodAsGeneric(Class<?> clazz, String methodName, int numArgs) throws NoSuchMethodException {
        Object[] parameterTypesForGeneric = new Class[numArgs];
        Arrays.fill(parameterTypesForGeneric, Object.class);
        return clazz.getDeclaredMethod(methodName, (Class<?>[])parameterTypesForGeneric);
    }

    private static Class<?> getClassFromString(String type) {
        return switch (type.toLowerCase()) {
            case "bigint" -> Long.TYPE;
            case "boolean" -> Boolean.TYPE;
            case "double" -> Double.TYPE;
            case "float" -> Float.TYPE;
            case "int" -> Integer.TYPE;
            case "string" -> String.class;
            case "tinyint" -> Byte.TYPE;
            default -> throw new RuntimeException("Unsupported type: " + type);
        };
    }

    private static Object convertStringToType(String value, Class<?> type) {
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.parseInt(value);
        }
        if (type.equals(Long.TYPE)) {
            return Long.parseLong(value);
        }
        if (type.equals(Double.TYPE)) {
            return Double.parseDouble(value);
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.parseBoolean(value);
        }
        if (type.equals(Float.TYPE)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.parseByte(value);
        }
        throw new RuntimeException("Unsupported type: " + String.valueOf(type));
    }
}

