/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_connect.udfs;

import com.snowflake.snowpark_java.types.Variant;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Locale;

public class SentencesUdf {
    public static Variant sentences(String str, String language, String country) {
        if (str == null) {
            return null;
        }
        Locale locale = language != null && country != null ? new Locale(language, country) : (language != null ? new Locale(language) : Locale.US);
        BreakIterator sentenceInstance = BreakIterator.getSentenceInstance(locale);
        sentenceInstance.setText(str);
        int sentenceIndex = 0;
        ArrayList res = new ArrayList();
        while (sentenceInstance.next() != -1) {
            String sentence = str.substring(sentenceIndex, sentenceInstance.current());
            sentenceIndex = sentenceInstance.current();
            BreakIterator wordInstance = BreakIterator.getWordInstance(locale);
            wordInstance.setText(sentence);
            int wordIndex = 0;
            ArrayList<String> words = new ArrayList<String>();
            while (wordInstance.next() != -1) {
                String word = sentence.substring(wordIndex, wordInstance.current());
                wordIndex = wordInstance.current();
                if (!Character.isLetterOrDigit(word.charAt(0))) continue;
                words.add(word);
            }
            res.add(new ArrayList(words));
        }
        return new Variant(res);
    }
}

