# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNetworkResult',
    'AwaitableGetNetworkResult',
    'get_network',
    'get_network_output',
]

@pulumi.output_type
class GetNetworkResult:
    """
    A collection of values returned by getNetwork.
    """
    def __init__(__self__, datacenter_id=None, distributed_virtual_switch_uuid=None, filters=None, id=None, name=None, retry_interval=None, retry_timeout=None, type=None, vpc_id=None):
        if datacenter_id and not isinstance(datacenter_id, str):
            raise TypeError("Expected argument 'datacenter_id' to be a str")
        pulumi.set(__self__, "datacenter_id", datacenter_id)
        if distributed_virtual_switch_uuid and not isinstance(distributed_virtual_switch_uuid, str):
            raise TypeError("Expected argument 'distributed_virtual_switch_uuid' to be a str")
        pulumi.set(__self__, "distributed_virtual_switch_uuid", distributed_virtual_switch_uuid)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if retry_interval and not isinstance(retry_interval, int):
            raise TypeError("Expected argument 'retry_interval' to be a int")
        pulumi.set(__self__, "retry_interval", retry_interval)
        if retry_timeout and not isinstance(retry_timeout, int):
            raise TypeError("Expected argument 'retry_timeout' to be a int")
        pulumi.set(__self__, "retry_timeout", retry_timeout)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "datacenter_id")

    @_builtins.property
    @pulumi.getter(name="distributedVirtualSwitchUuid")
    def distributed_virtual_switch_uuid(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "distributed_virtual_switch_uuid")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNetworkFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="retryInterval")
    def retry_interval(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "retry_interval")

    @_builtins.property
    @pulumi.getter(name="retryTimeout")
    def retry_timeout(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "retry_timeout")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The managed object type for the discovered network. This will be one
        of `DistributedVirtualPortgroup` for distributed port groups, `Network` for
        standard (host-based) port groups, or `OpaqueNetwork` for networks managed
        externally, such as those managed by NSX.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vpc_id")


class AwaitableGetNetworkResult(GetNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkResult(
            datacenter_id=self.datacenter_id,
            distributed_virtual_switch_uuid=self.distributed_virtual_switch_uuid,
            filters=self.filters,
            id=self.id,
            name=self.name,
            retry_interval=self.retry_interval,
            retry_timeout=self.retry_timeout,
            type=self.type,
            vpc_id=self.vpc_id)


def get_network(datacenter_id: Optional[_builtins.str] = None,
                distributed_virtual_switch_uuid: Optional[_builtins.str] = None,
                filters: Optional[Sequence[Union['GetNetworkFilterArgs', 'GetNetworkFilterArgsDict']]] = None,
                name: Optional[_builtins.str] = None,
                retry_interval: Optional[_builtins.int] = None,
                retry_timeout: Optional[_builtins.int] = None,
                vpc_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkResult:
    """
    The `get_network` data source can be used to discover the ID of a network in
    vSphere. This can be any network that can be used as the backing for a network
    interface for `VirtualMachine` or any other vSphere resource that
    requires a network. This includes standard (host-based) port groups, distributed
    port groups, or opaque networks such as those managed by NSX.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    network = vsphere.get_network(name="VM Network",
        datacenter_id=datacenter.id)
    ```

    ### Additional Examples

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    my_port_group = vsphere.get_network(datacenter_id=datacenter.id,
        name="VM Network",
        filters=[{
            "network_type": "Network",
        }])
    ```


    :param _builtins.str datacenter_id: The managed object reference ID
           of the datacenter the network is located in. This can be omitted if the
           search path used in `name` is an absolute path. For default datacenters,
           use the `id` attribute from an empty `Datacenter` data source.
    :param _builtins.str distributed_virtual_switch_uuid: For distributed port group type
           network objects, the ID of the distributed virtual switch for which the port
           group belongs. It is useful to differentiate port groups with same name using
           the distributed virtual switch ID.
    :param Sequence[Union['GetNetworkFilterArgs', 'GetNetworkFilterArgsDict']] filters: Apply a filter for the discovered network.
    :param _builtins.str name: The name of the network. This can be a name or path.
    :param _builtins.int retry_interval: The interval in milliseconds to retry the read operation if `retry_timeout` is set. Default: 500.
    :param _builtins.int retry_timeout: The timeout duration in seconds for the data source to retry read operations.
    :param _builtins.str vpc_id: Select a VPC scope for retrieval of VPC subnets.
    """
    __args__ = dict()
    __args__['datacenterId'] = datacenter_id
    __args__['distributedVirtualSwitchUuid'] = distributed_virtual_switch_uuid
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['retryInterval'] = retry_interval
    __args__['retryTimeout'] = retry_timeout
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vsphere:index/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult).value

    return AwaitableGetNetworkResult(
        datacenter_id=pulumi.get(__ret__, 'datacenter_id'),
        distributed_virtual_switch_uuid=pulumi.get(__ret__, 'distributed_virtual_switch_uuid'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        retry_interval=pulumi.get(__ret__, 'retry_interval'),
        retry_timeout=pulumi.get(__ret__, 'retry_timeout'),
        type=pulumi.get(__ret__, 'type'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_network_output(datacenter_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       distributed_virtual_switch_uuid: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNetworkFilterArgs', 'GetNetworkFilterArgsDict']]]]] = None,
                       name: Optional[pulumi.Input[_builtins.str]] = None,
                       retry_interval: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       retry_timeout: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkResult]:
    """
    The `get_network` data source can be used to discover the ID of a network in
    vSphere. This can be any network that can be used as the backing for a network
    interface for `VirtualMachine` or any other vSphere resource that
    requires a network. This includes standard (host-based) port groups, distributed
    port groups, or opaque networks such as those managed by NSX.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    network = vsphere.get_network(name="VM Network",
        datacenter_id=datacenter.id)
    ```

    ### Additional Examples

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    my_port_group = vsphere.get_network(datacenter_id=datacenter.id,
        name="VM Network",
        filters=[{
            "network_type": "Network",
        }])
    ```


    :param _builtins.str datacenter_id: The managed object reference ID
           of the datacenter the network is located in. This can be omitted if the
           search path used in `name` is an absolute path. For default datacenters,
           use the `id` attribute from an empty `Datacenter` data source.
    :param _builtins.str distributed_virtual_switch_uuid: For distributed port group type
           network objects, the ID of the distributed virtual switch for which the port
           group belongs. It is useful to differentiate port groups with same name using
           the distributed virtual switch ID.
    :param Sequence[Union['GetNetworkFilterArgs', 'GetNetworkFilterArgsDict']] filters: Apply a filter for the discovered network.
    :param _builtins.str name: The name of the network. This can be a name or path.
    :param _builtins.int retry_interval: The interval in milliseconds to retry the read operation if `retry_timeout` is set. Default: 500.
    :param _builtins.int retry_timeout: The timeout duration in seconds for the data source to retry read operations.
    :param _builtins.str vpc_id: Select a VPC scope for retrieval of VPC subnets.
    """
    __args__ = dict()
    __args__['datacenterId'] = datacenter_id
    __args__['distributedVirtualSwitchUuid'] = distributed_virtual_switch_uuid
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['retryInterval'] = retry_interval
    __args__['retryTimeout'] = retry_timeout
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vsphere:index/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult)
    return __ret__.apply(lambda __response__: GetNetworkResult(
        datacenter_id=pulumi.get(__response__, 'datacenter_id'),
        distributed_virtual_switch_uuid=pulumi.get(__response__, 'distributed_virtual_switch_uuid'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        retry_interval=pulumi.get(__response__, 'retry_interval'),
        retry_timeout=pulumi.get(__response__, 'retry_timeout'),
        type=pulumi.get(__response__, 'type'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
