print('''
###############
# scope testing
###############
''')

print('''
# for-loop variables survive the loop
# -----------------------------------
''')
for i in range(5):
    print('i in for-loop: ' + str(i))
print('i after exiting for-loop: ' + str(i))
del i


print('''
# for-loop modifies existing variable
# -----------------------------------
''')
var = 'orig'
mylist = ['one', 'two', 'three']
print('var before entering the for-loop: ' + var)
for var in mylist:
    print('var in the for-loop: ' + var)
print('var after exiting the for-loop: ' + var)


print('''
# access global variable from within function
# -------------------------------------------
''')
def myfunc():
    print("The global var can even be accessed in a function: " + var.capitalize())
myfunc()


print('''
# nested functions
# ----------------
''')
def outer():
    x = 20
    
    def inner():
        global x
        x = 100
    
    print('x is a local variable in outer: ' + str(x))
    inner()
    print('Calling inner, which makes x global and changes its value to 100, has no effect for the local variable x: ' + str(x))

outer()
print('After calling outer from main, x has the global value assigned in inner, and no more the local value from outer: ' + str(x))



print('''
#################################################
# Pointer problem: dict is unvoluntarily modified
#################################################
''')

# we start with two dictionaries that we need later
link_properties = {
    'rosetta:hasTextMedium': ['rosetta:Image2D'], 
    'rosetta:hasRelatedArtwork': [
        'rosetta:Text', 
        'rosetta:ImagePartOfABook', 
        'rosetta:Image3D'
    ]
}

resources = {
    'rosetta:Text': {
        'rosetta:hasTextMedium',
        'rosetta:hasRelatedArtwork'
    }
}

# create a new dict 'dependencies' and populate it, based on the other dicts
dependencies = dict()
for resource, cardinalities in resources.items():
    for cardinality in cardinalities:
        targets = link_properties[cardinality]
        # 1. loop: targets points to `link_properties['rosetta:hasTextMedium']`
        if resource not in dependencies:
            dependencies[resource] = targets
            # 1. loop: `dependencies['rosetta:Text']` points to `link_properties['rosetta:hasTextMedium']`
        else:
            dependencies[resource].extend(targets)
            # 2. loop: `link_properties['rosetta:hasTextMedium']` is now extended by the contents of targets!

print(
    f"link_properties['rosetta:hasTextMedium'] should still be a list of length 1: ['rosetta:Image2D']\n"
    f"But look how it looks like:\n{link_properties['rosetta:hasTextMedium']}\n"
    f"The solution is that `targets` must be made a new list with `targets = list(link_properties[cardinality])`"
)
