# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['charmonium', 'charmonium.freeze']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'charmonium.freeze',
    'version': '0.5.3',
    'description': 'Injectively, deterministically maps objects to hashable, immutable objects',
    'long_description': '==========================\ncharmonium.freeze\n==========================\n\n.. image:: https://img.shields.io/pypi/v/charmonium.freeze\n   :alt: PyPI Package\n   :target: https://pypi.org/project/charmonium.freeze\n.. image:: https://img.shields.io/pypi/dm/charmonium.freeze\n   :alt: PyPI Downloads\n   :target: https://pypi.org/project/charmonium.freeze\n.. image:: https://img.shields.io/pypi/l/charmonium.freeze\n   :alt: License\n   :target: https://github.com/charmonium/charmonium.freeze/blob/main/LICENSE\n.. image:: https://img.shields.io/pypi/pyversions/charmonium.freeze\n   :alt: Python Versions\n   :target: https://pypi.org/project/charmonium.freeze\n.. image:: https://img.shields.io/librariesio/sourcerank/pypi/charmonium.freeze\n   :alt: libraries.io sourcerank\n   :target: https://libraries.io/pypi/charmonium.freeze\n.. image:: https://img.shields.io/github/stars/charmonium/charmonium.freeze?style=social\n   :alt: GitHub stars\n   :target: https://github.com/charmonium/charmonium.freeze\n.. image:: https://github.com/charmonium/charmonium.freeze/actions/workflows/main.yaml/badge.svg\n   :alt: CI status\n   :target: https://github.com/charmonium/charmonium.freeze/actions/workflows/main.yaml\n.. image:: https://img.shields.io/github/last-commit/charmoniumQ/charmonium.determ_hash\n   :alt: GitHub last commit\n   :target: https://github.com/charmonium/charmonium.freeze/commits\n.. image:: http://www.mypy-lang.org/static/mypy_badge.svg\n   :target: https://mypy.readthedocs.io/en/stable/\n   :alt: Checked with Mypy\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :target: https://github.com/psf/black\n   :alt: Code style: black\n\nInjectively, deterministically maps objects to hashable, immutable objects\n\n``frozenset`` is to ``set`` as ``freeze`` is to ``Any``.\n\nThat is, ``type(a) is type(b) and a != b`` implies ``freeze(a) != freeze(b)``.\n\nMoreover, this function is deterministic, so it can be used to compare\nstates **across subsequent process invocations** (with the same\ninterpreter major and minor version).\n\n>>> obj = [1, 2, 3, {4, 5, 6}, object()]\n>>> hash(obj)\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nTypeError: unhashable type: \'list\'\n\n>>> from charmonium.freeze import freeze\n>>> frozen_obj = freeze(obj)\n>>> frozen_obj\n(1, 2, 3, frozenset({4, 5, 6}), (\'args\', \'object\'))\n\nIt even works on custom types.\n\n>>> # Make a custom type\n>>> class Struct:\n...     def frobnicate(self):\n...         print(123)\n>>> s = Struct()\n>>> s.attr = 4\n>>> freeze(s)\n(\'args\', \'Struct\', \'state\', ((\'attr\', 4),))\n\nAnd methods, functions, lambdas, etc.\n\n>>> freeze(lambda x: x + 123)\n((\'code\', ((\'name\', \'<lambda>\'), (\'varnames\', (\'x\',)), (\'constants\', (None, 123)), (\'bytecode\', b\'|\\x00d\\x01\\x17\\x00S\\x00\'))),)\n>>> import functools\n>>> freeze(functools.partial(print, 123))\n(\'constructor\', \'partial\', \'args\', \'print\', \'state\', (\'print\', (123,), (), None))\n>>> freeze(Struct.frobnicate)\n((\'code\', ((\'name\', \'frobnicate\'), (\'varnames\', (\'self\',)), (\'constants\', (None, 123)), (\'bytecode\', b\'t\\x00d\\x01\\x83\\x01\\x01\\x00d\\x00S\\x00\'))),)\n\nIf the source code of ``Struct.frobnicate`` changes between successive\ninvocations, then the ``freeze`` value will change. This is useful for caching\nunchanged functions.\n\n\n-------------\nSpecial cases\n-------------\n\n- ``freeze`` on functions returns their bytecode, constants, and\n  closure-vars. This means that ``freeze_state(f) == freeze_state(g)`` implies\n  ``f(x) == g(x)``. The remarkable thing is that this is true across subsequent\n  invocations of the same process. If the user edits the script and changes the\n  function, then it\'s ``freeze_state`` will change too.\n\n- ``freeze`` on objects returns the objects that would be used by `pickle`_ from\n  ``__reduce__``, ``__reduce_ex__``, ``__getnewargs__``, ``__getnewargs_ex__``,\n  and ``__getstate__``. The simplest of these to customize your object\n  ``__gestate__``. See the `pickle`_ documentation for details.\n\n- In the cases where ``__getstate__`` is already defined for pickle, and this\n  definition is not suitable for ``freeze_state``, one may override this with\n  ``__getfrozenstate__`` which takes precedence.\n\nAlthough, this function is not infallible for user-defined types; I will do my\nbest, but sometimes these laws will be violated. These cases include:\n\n- Cases where ``__eq__`` makes objects equal despite differing attributes or\n  inversely make objects inequal despite equal attributes.\n\n   - This can be mitigated if ``__getstate__`` or ``__getfrozenstate__``\n\n------------\nInstalling\n------------\n\nIf you don\'t have ``pip`` installed, see the `pip install guide`_.\n\n.. _`pip install guide`: https://pip.pypa.io/en/latest/installing/\n\n.. code-block:: console\n\n    $ pip install charmonium.freeze\n\nSee `CONTRIBUTING.md`_ for instructions on setting up a development environment.\n\n.. _`CONTRIBUTING.md`: https://github.com/charmonium/charmonium.freeze/tree/main/CONTRIBUTING.md\n\n---------\nDebugging\n---------\n\nUse the following lines to see how ``freeze`` decomposes an object. It shows the\nobject tree that ``freeze`` walks until it reaches primitive values on the\nleaves\n\n.. code:: python\n\n    import logging\n    import os\n    logger = logging.getLogger("charmonium.freeze")\n    logger.setLevel(logging.DEBUG)\n    fh = logging.FileHandler("freeze.log")\n    fh.setLevel(logging.DEBUG)\n    fh.setFormatter(logging.Formatter("%(message)s"))\n    logger.addHandler(fh)\n    logger.debug("Program %d", os.getpid())\n\n.. _`PyPI`: https://pypi.org/project/charmonium.freeze/\n.. _`GitHub`: https://github.com/charmoniumQ/charmonium.freeze\n.. _`pickle`: https://docs.python.org/3/library/pickle.html#pickling-class-instances\n',
    'author': 'Samuel Grayson',
    'author_email': 'sam+dev@samgrayson.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/charmonium/charmonium.freeze',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
