ALPHABETIC = r'^[a-zA-Z]+$'
ALPHANUMERIC = r'^[a-zA-Z0-9]+$'
ALPHANUMERIC_UNDERSCORE = r'^[a-zA-Z0-9_]+$'
ALPHA_NUMERIC = r'^[a-zA-Z0-9]+$'
ALPHA_ONLY = r'^[a-zA-Z]+$'
AUSTRALIAN_PHONE_NUMBER = r'^\(?\d{2}\)?[\s.-]?\d{4}[-.\s]?\d{4}$'
AUSTRALIAN_POSTCODE = r'^\d{4}$'
BASE64 = r'^[A-Za-z0-9+/=]+$'
BIC_SWIFT_CODE = r'^[A-Z]{4}[A-Z]{2}[A-Z\d]{2}(?:[A-Z\d]{3})?$'
BINARY_NUMBER = r'^[01]+$'
BRAZILIAN_PHONE_NUMBER = r'^\(?\d{2}\)?[\s.-]?\d{4,5}[-.\s]?\d{4}$'
CANADA_DATE = r'^\d{4}/\d{2}/\d{2}$'
CANADIAN_PHONE_NUMBER = r'^\d{10}$'
CANADIAN_POSTAL_CODE = r'^[A-Za-z]\d[A-Za-z] \d[A-Za-z]\d$'
CANADIAN_POSTAL_CODE = r'^[ABCEGHJ-NPRSTVXY]\d[A-Z] \d[A-Z]\d$'
COLOR_HEX = r'^#(?:[0-9A-Fa-f]{3}){1,2}$'
CREDIT_CARD = r'^\d{4}-\d{4}-\d{4}-\d{4}$'
CREDIT_CARD_AMEX = r'^3[47][0-9]{13}$'
CREDIT_CARD_DISCOVER = r'^6(?:011|5[0-9]{2})[0-9]{12}$'
CREDIT_CARD_EXPIRY_DATE = r'^(0[1-9]|1[0-2])\/\d{2}$'
CREDIT_CARD_JCB = r'^(?:2131|1800|35[0-9]{3})[0-9]{11}$'
CREDIT_CARD_MASTERCARD = r'^5[1-5][0-9]{14}$'
CREDIT_CARD_VISA = r'^4[0-9]{12}(?:[0-9]{3})?$'
CSV_FIELD = r'[^,\n"]+|"[^"]*"'
CSV_LINE = r'(?:[^,\n"]+|"[^"]*")*(?:,[^,\n"]+|"[^"]*")*'
CURRENCY = r'^\$\d+(?:\.\d{2})?$'
CURRENCY_SYMBOL = r'^[\p{Sc}]'
DATETIME_YYYY_MM_DD_HH_MM_SS = r'^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$'
DATE_CANADA_FORMAT = r'^\d{4}/\d{2}/\d{2}$'
DATE_ISO = r'^\d{4}-\d{2}-\d{2}$'
DATE_UK = r'^\d{2}/\d{2}/\d{4}$'
DATE_UK_FORMAT = r'^\d{2}/\d{2}/\d{4}$'
DATE_US = r'^\d{2}/\d{2}/\d{4}$'
DATE_US_FORMAT = r'^\d{2}/\d{2}/\d{4}$'
DATE_YYYY_MM_DD = r'^\d{4}-\d{2}-\d{2}$'
DECIMAL_NUMBER = r'^\d+(\.\d+)?$'
DOLLAR_AMOUNT = r'^\$\d+(?:\.\d{2})?$'
DOMINANT_COLOR_HEX = r'#[0-9A-Fa-f]{6}'
EMAIL = r'^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$'
EMAIL_DOMAIN = r'^[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$'
EMAIL_DOMAIN_ONLY = r'^[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$'
EMAIL_LOCAL_PART = r'^[a-zA-Z0-9._%+-]+$'
EMAIL_LOCAL_PART_ONLY = r'^[a-zA-Z0-9._%+-]+$'
EMAIL_WITH_DOMAIN = r'^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$'
EURO_AMOUNT = r'^\€\d+(?:\.\d{2})?$'
EVERYTHING_BUT_NUMBERS = r'[^0-9]'
FACEBOOK_URL = r'^https://www\.facebook\.com/[A-Za-z0-9.]+$'
FACEBOOK_URL = r'^https://www\.facebook\.com/[a-zA-Z0-9.]+$'
FILENAME = r'^[\w,\s-]+\.[A-Za-z]{3}$'
FILE_EXTENSION = r'\.[a-zA-Z0-9]{2,4}$'
FILE_EXTENSION = r'\.\w+$'
FILE_PATH = r'^[a-zA-Z]:\\(?:[\w\s]+\\)*\w([\w\s]+\.\w+)?$'
FRACTION = r'^\d+/\d+$'
GENDER = r'^(Male|Female|Other)$'
GITHUB_USERNAME = r'^[a-zA-Z0-9_-]{1,39}$'
GIT_COMMIT_HASH = r'^[a-fA-F0-9]{40}$'
HASHTAG = r'#\w+'
HEXADECIMAL = r'^[0-9A-Fa-f]+$'
HEX_COLOR = r'^#(?:[0-9a-fA-F]{3}){1,2}$'
HEX_COLOR_FULL = r'^#(?:[0-9a-fA-F]{3}){1,2}$'
HEX_COLOR_LONG = r'^#[0-9A-Fa-f]{6}$'
HEX_COLOR_SHORT = r'^#[0-9A-Fa-f]{3}$'
HSLA_COLOR = r'^hsla\(\d{1,3},\s?\d+%,\s?\d+%,\s?\d(\.\d+)?\)$'
HSLA_COLOR_OLD = r'^hsla\(\d{1,3},\d+%,\d+%,\d(\.\d+)?\)$'
HSL_COLOR = r'^hsl\(\d{1,3},\s?\d+%,\s?\d+%\)$'
HSL_COLOR_OLD = r'^hsl\(\d{1,3},\d+%,\d+%\)$'
HTML_ATTRIBUTE = r'\b\w+(?==)"[^"]*"'
HTML_ATTRIBUTE = r'\b\w+(?==)'
HTML_ATTRIBUTE_VALUE = r'"[^"]*"'
HTML_ATTRIBUTE_VALUE = r'(?&lt;=\w+=")[^"]*"'
HTML_COMMENT = r'&lt;!--.*?--&gt;'
HTML_DOCTYPE = r'&lt;!DOCTYPE\s+html&gt;'
HTML_DOCTYPE_HTML5 = r'&lt;!DOCTYPE html&gt;'
HTML_ENTITY = r'&[a-zA-Z0-9#]+;'
HTML_ENTITY = r'&\w+;'
HTML_TAG = r'&lt;[^&gt;]+&gt;'
HTML_TAG_CLOSE = r'&lt;/\w+&gt;'
HTML_TAG_CLOSE = r'&lt;/\w+'
HTML_TAG_NAME = r'&lt;(\w+)'
HTML_TAG_OPEN = r'&lt;\w+'
HTML_TAG_WITH_ATTRIBUTES = r'&lt;\w+[^&gt;]*&gt;'
IMAGE_URL = r'^(https?:\/\/.*\.(?:png|jpg|jpeg|gif|bmp))$'
import re
INSTAGRAM_URL = r'^https://instagram\.com/[a-zA-Z0-9_]+$'
INTEGER = r'^[+-]?\d+$'
IPV4 = r'^((25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)$'
IPV6 = r'^((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|::|[0-9a-fA-F]{1,4}::[0-9a-fA-F]{1,4}|[0-9a-fA-F]{1,4}::[0-9a-fA-F]{1,4})$'
IPV6_ADDRESS = r'^((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|::|[0-9a-fA-F]{1,4}::[0-9a-fA-F]{1,4}|[0-9a-fA-F]{1,4}::[0-9a-fA-F]{1,4})$'
IP_ADDRESS = r'^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'
IP_ADDRESS_V4 = r'^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'
IP_ADDRESS_V6 = r'^((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|::|[0-9a-fA-F]{1,4}::[0-9a-fA-F]{1,4}|[0-9a-fA-F]{1,4}::[0-9a-fA-F]{1,4})$'
ISBN_10 = r'^\d{9}[\dX]$'
ISBN_13 = r'^\d{13}$'
ISO_8601_DATE = r'^\d{4}-\d{2}-\d{2}$'
ISO_8601_DATETIME = r'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}$'
ISO_8601_DATETIME_MS = r'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d+$'
JSON_ARRAY = r'\[.*?\]'
JSON_ARRAY_END = r'\]'
JSON_ARRAY_START = r'\['
JSON_BOOLEAN = r'true|false'
JSON_NULL = r'null'
JSON_NUMBER = r'-?\d+(\.\d+)?'
JSON_OBJECT = r'^\{(?:[^{}]|(?R))*\}$'
JSON_OBJECT_END = r'\}'
JSON_OBJECT_KEY = r'"[^"]+":'
JSON_OBJECT_START = r'\{'
JSON_OBJECT_VALUE = r':\s*(?:"[^"]*"|\d+|\[.*?\]|\{.*?\}|\w+|true|false|null)\b'
JSON_STRING = r'"[^"]*"'
JSON_STRING = r'^(?:[^"\\]|\\.)*$'
LATITUDE = r'^-?([1-8]?\d(\.\d+)?|90(\.0+)?)$'
LAT_LONG = r'^-?([1-8]?\d(\.\d+)?|90(\.0+)?)°, ?-?(1[0-7]\d(\.\d+)?|[1-9]?\d(\.\d+)?)°$'
LINKEDIN_URL = r'^https://www\.linkedin\.com/in/[A-Za-z0-9_-]+$'
LINKEDIN_URL = r'^https://www\.linkedin\.com/in/[a-zA-Z0-9_-]+$'
LONGITUDE = r'^-?((1[0-7]\d(\.\d+)?|[0-9]?\d)(\.\d+)?|180(\.0+)?)$'
MAC_ADDRESS = r'^([0-9A-Fa-f]{2}[:-]){5}[0-9A-Fa-f]{2}$'
MARKDOWN_LINK = r'\[([^\]]+)\]\([^\)]+\)'
MD5_HASH = r'^[a-fA-F0-9]{32}$'
MENTION = r'@\w+'
MIME_TYPE = r'^[a-zA-Z0-9/.-]+$'
MONEY_WITH_COMMA = r'^\$\d{1,3}(?:,\d{3})*(?:\.\d{2})?$'
MULTI_LINE_COMMENT = r'/\*[\s\S]*?\*/'
NEGATIVE_INTEGER = r'^-\d+$'
NON_WHITESPACE = r'\S+'
NUMERIC_ONLY = r'^\d+$'
NUMERIC_RANGE = r'^\d+[-~]\d+$'
ONLY_NUMBERS = r'^\d+$'
ORDER_NUMBER = r'^\d{3}-\d{4}-\d{4}$'
PASSWORD = r'^(?=.*[A-Za-z])(?=.*\d)[A-Za-z\d]{8,}$'
PASSWORD_COMPLEX = r'^(?=.*[A-Za-z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$'
PASSWORD_MAXIMUM = r'^.{0,20}$'
PASSWORD_MINIMUM = r'^.{8,}$'
PERCENTAGE = r'^\d+%$'
PHONE_AUS = r'^\(?\d{2}\)?[-.\s]?\d{4}[-.\s]?\d{4}$'
PHONE_BRAZIL = r'^\+55\s?\d{2}\s?\d{4}-\d{4}$'
PHONE_CANADA = r'^\(?\d{3}\)?[-.\s]?\d{3}[-.\s]?\d{4}$'
PHONE_CHINA = r'^\+86\s?\d{11}$'
PHONE_FRANCE = r'^\+33\s?\d{9}$'
PHONE_GERMANY = r'^\+49\s?\d{10,11}$'
PHONE_INDIA = r'^\+91\s?\d{10}$'
PHONE_ITALY = r'^\+39\s?\d{10}$'
PHONE_JAPAN = r'^\+81\s?\d{10}$'
PHONE_NORTH_AMERICA = r'^\+1\s?\(?\d{3}\)?[-.\s]?\d{3}[-.\s]?\d{4}$'
PHONE_NUMBER = r'^\(?\d{3}\)?[-.\s]?\d{3}[-.\s]?\d{4}$'
PHONE_NUMBER_INTL = r'^\+?[1-9]\d{1,14}$'
PHONE_NUMBER_US = r'^\+1\s?\(?\d{3}\)?[-.\s]?\d{3}[-.\s]?\d{4}$'
PHONE_RUSSIA = r'^\+7\s?\d{10}$'
PHONE_SPAIN = r'^\+34\s?\d{9}$'
PHONE_UK = r'^\+44\s?\d{4}\s?\d{6}$'
PHONE_US = r'^\(?\d{3}\)?[-.\s]?\d{3}[-.\s]?\d{4}$'
PLATE_NUMBER = r'^[A-Z0-9]{1,7}$'
POSITIVE_INTEGER = r'^\d+$'
QUOTED_STRING = r'"(?:[^"\\]|\\.)*"'
QUOTED_STRING_DOUBLE = r'"(?:[^"\\]|\\.)*"'
QUOTED_STRING_SINGLE = r"'(?:[^'\\]|\\.)*'"
REDDIT_URL = r'^https://www\.reddit\.com/r/[a-zA-Z0-9_]+$'
RGBA_COLOR = r'^rgba\(\d{1,3},\s?\d{1,3},\s?\d{1,3},\s?\d(\.\d+)?\)$'
RGBA_COLOR_OLD = r'^rgba\(\d{1,3},\d{1,3},\d{1,3},\d(\.\d+)?\)$'
RGB_COLOR = r'^rgb\(\d{1,3},\s?\d{1,3},\s?\d{1,3}\)$'
RGB_COLOR_OLD = r'^rgb\(\d{1,3},\d{1,3},\d{1,3}\)$'
SHA1_HASH = r'^[a-fA-F0-9]{40}$'
SHA256_HASH = r'^[a-fA-F0-9]{64}$'
SINGLE_LINE_COMMENT = r'//.*'
SINGLE_QUOTED_STRING = r"'(?:[^'\\]|\\.)*'"
SQL_INJECTION = r'(?:\bSELECT\b|\bUPDATE\b|\bDELETE\b|\bINSERT\b|\bDROP\b|\bTRUNCATE\b|\bUNION\b|\bEXEC\b|\bRENAME\b|\bALTER\b|\bCREATE\b)'
SSN = r'^\d{3}-\d{2}-\d{4}$'
SSN_CANADA = r'^\d{3}-\d{3}-\d{3}$'
TEXT_WITH_NEWLINES = r'^[\s\S]+$'
TICKET_NUMBER = r'^[A-Z]{2}\d{6}$'
TIKTOK_URL = r'^https://www\.tiktok\.com/@[a-zA-Z0-9_]+$'
TIMEZONE = r'^[A-Za-z]+/[A-Za-z_]+$'
TIME_12H = r'^(0?[1-9]|1[0-2]):([0-5]\d) ?([APap][Mm])$'
TIME_12H = r'^(?:0?[1-9]|1[0-2]):[0-5]\d\s?(?:AM|PM)$'
TIME_24H = r'^(?:[01]\d|2[0-3]):[0-5]\d$'
TIME_24H = r'^([01]\d|2[0-3]):([0-5]\d)$'
TIME_HH_MM_SS = r'^\d{2}:\d{2}:\d{2}$'
TWITTER_HANDLE = r'^@([A-Za-z0-9_]{1,15})$'
TWITTER_URL = r'^https://twitter\.com/[a-zA-Z0-9_]+$'
UK_DATE = r'^\d{2}/\d{2}/\d{4}$'
UK_DATE_DD_MM_YYYY = r'^\d{2}/\d{2}/\d{4}$'
UK_POSTCODE = r'^[A-Z]{1,2}\d{1,2} \d[A-Z]{2}$'
URL = r'^(https?|ftp)://[^\s/$.?#].[^\s]*$'
URL_NO_QUERY = r'^(https?|ftp)://[^\s/$.?#].[^\s]*$'
URL_QUERY_PARAM = r'[?&]([^=]+)=([^&]*)'
URL_WITHOUT_HTTP = r'^[a-zA-Z0-9.-]+(?:\.[a-zA-Z]{2,})+$'
URL_WITH_PATH = r'^(https?|ftp)://[^\s/$.?#].[^\s]*[^\s/].*$'
USERNAME = r'^[a-zA-Z0-9_]{3,16}$'
USERNAME_EMAIL = r'^[a-zA-Z0-9._%+-]+@(?:[a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}$'
US_ADDRESS = r'\d+ [A-Za-z\s]+, [A-Za-z\s]+, [A-Z]{2} \d{5}'
US_DATE = r'^\d{2}/\d{2}/\d{4}$'
US_DATE_MM_DD_YYYY = r'^\d{2}/\d{2}/\d{4}$'
US_SOCIAL_SECURITY_NUMBER = r'^\d{3}-\d{2}-\d{4}$'
US_STATE_ABBR = r'^[A-Z]{2}$'
US_ZIP_CODE_EXTENDED = r'^\d{5}-\d{4}$'
UUID = r'^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$'
UUID_SHORT = r'^[a-fA-F0-9]{32}$'
UUID_V1 = r'^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-1[0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$'
UUID_V4 = r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-4[a-fA-F0-9]{3}-[89abAB][a-fA-F0-9]{3}-[a-fA-F0-9]{12}$'
VALID_EMAIL_DOMAIN = r'^[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$'
VALID_EMAIL_LOCAL_PART = r'^[a-zA-Z0-9._%+-]+$'
VIDEO_URL = r'^(https?:\/\/.*\.(?:mp4|avi|mov|mkv))$'
XML_COMMENT = r'&lt;!--.*?--&gt;'
XML_TAG = r'&lt;\w+[^&gt;]*&gt;.*?&lt;/\w+&gt;'
XML_TAG_CONTENT = r'&gt;.*?&lt;'
YOUTUBE_CHANNEL_URL = r'^https://www\.youtube\.com/channel/[a-zA-Z0-9_-]+$'
YOUTUBE_URL = r'^https://www\.youtube\.com/watch\?v=[a-zA-Z0-9_-]+$'
ZIP_CODE = r'^\d{5}(-\d{4})?$'
ZIP_CODE_AUS = r'^\d{4}$'
ZIP_CODE_CANADA = r'^[A-Za-z]\d[A-Za-z] \d[A-Za-z]\d$'
ZIP_CODE_CANADA = r'^[ABCEGHJKLMNPRSTVXY]\d[A-Z] \d[A-Z]\d$'
ZIP_CODE_CHINA = r'^\d{6}$'
ZIP_CODE_JAPAN = r'^\d{3}-\d{4}$'
ZIP_CODE_UK = r'^[A-Z]{1,2}\d[A-Z\d]? \d[A-Z]{2}$'
ZIP_CODE_UK = r'^[A-Z]{1,2}\d{1,2} \d[A-Z]{2}$'
ZIP_CODE_US = r'^\d{5}(?:-\d{4})?$'