# MD001 - Heading levels should only increment by one

## What this rule does

Prevents skipping heading levels (like jumping from # to ### without ##).

## Why this matters

- **Document structure**: Logical heading hierarchy makes documents easier to navigate
- **Accessibility**: Screen readers rely on proper heading order to help users
- **Table of contents**: Automated TOC generators need correct heading levels
- **SEO**: Search engines use heading structure to understand content

## Examples

### ✅ Correct

```markdown
# Title
## Chapter 1
### Section 1.1
### Section 1.2
## Chapter 2
### Section 2.1
```

### ❌ Incorrect

```markdown
# Title
### Section 1.1     (skipped level 2)
##### Subsection    (skipped levels 2, 3, and 4)
```

### 🔧 Fixed

```markdown
# Title
## Section 1.1
### Subsection
```

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule automatically adjusts heading levels to maintain proper hierarchy, changing skipped levels to the next appropriate level.

## Learn more

- [Web Content Accessibility Guidelines - Headings](https://www.w3.org/WAI/tutorials/page-structure/headings/) - Why heading structure matters
- [CommonMark headings](https://spec.commonmark.org/0.31.2/#atx-headings) - Technical specification

## Related rules

- [MD002](md002.md) - First heading should be a top-level heading
- [MD003](md003.md) - Heading style should be consistent
- [MD022](md022.md) - Headings should be surrounded by blank lines
