# MD013 - Keep lines short for better readability

## What this rule does

Checks that lines don't exceed a maximum length to ensure your content is easy to read on all devices.

## Why this matters

- **Improves readability**: Shorter lines are easier to scan and understand quickly
- **Works everywhere**: Content displays properly on mobile devices, terminals, and narrow windows
- **Better for code reviews**: Side-by-side comparisons work better with reasonable line lengths
- **Accessibility**: Screen readers and assistive technologies handle shorter lines more effectively

## Examples

<!-- rumdl-disable MD013 -->

### ✅ Correct

```markdown
This line is a reasonable length that's easy to read
and displays well on all devices.

Even with links, you can keep lines manageable by using
[reference-style links][1] instead of inline URLs.

[1]: https://example.com/very-long-url-that-would-make-the-line-too-long
```

### ❌ Incorrect

```markdown
This is an extremely long line that goes on and on and makes it difficult to read the content, especially on mobile devices or when viewing files in split-screen editors or during code reviews where horizontal space is limited.
```

### 🔧 Fixed

```markdown
This is a line that has been wrapped to stay within
the maximum length, making it much easier to read
and work with in various contexts.
```

<!-- rumdl-enable MD013 -->

## Configuration

```yaml
MD013:
  line_length: 100              # Maximum characters per line (default: 80)
  code_blocks: false            # Don't check code blocks (default: true)
  tables: false                 # Don't check tables (default: true)
  headings: true                # Check headings (default: true)
  heading_line_length: 120      # Different limit for headings (default: uses line_length)
  code_block_line_length: 150   # Different limit for code blocks (default: uses line_length)
  stern: false                  # Stricter checking without exceptions (default: false)
  strict: false                 # Disables exceptions for URLs, etc. (default: false)
  enable_reflow: false          # Enable automatic text reflow/wrapping (default: false)
```

### Configuration options explained

- `line_length`: The maximum number of characters allowed per line
- `code_blocks`: Whether to check line length in code blocks
- `tables`: Whether to check line length in tables
- `headings`: Whether to check line length in headings
- `heading_line_length`: Optional separate limit for headings (useful since headings often need to be longer)
- `code_block_line_length`: Optional separate limit for code blocks
- `stern`: When true, applies stricter checking without common exceptions
- `strict`: When true, disables exceptions for URLs and other special content
- `enable_reflow`: When true, enables automatic text reflow to wrap long lines intelligently

### Example with different limits

```yaml
MD013:
  line_length: 80
  heading_line_length: 100
  code_block_line_length: 120
  code_blocks: true
  headings: true
```

With this configuration:
- Regular text must stay within 80 characters
- Headings can extend up to 100 characters
- Code blocks can have lines up to 120 characters

````markdown
This regular paragraph text must wrap at 80 characters to comply with the rule.

## This heading can be longer and extend up to 100 characters without triggering a warning

```python
# This code block can have longer lines up to 120 characters
def very_long_function_name_that_demonstrates_the_code_block_line_length_configuration_option():
    pass
```
````

## Automatic fixes

When `enable_reflow` is set to `true`, this rule can automatically wrap long lines while preserving Markdown formatting:

- Intelligently breaks lines at appropriate points
- Preserves bold, italic, links, code spans, and other Markdown elements
- Maintains proper list continuation indentation
- Preserves hard line breaks (two trailing spaces)
- Does not wrap code blocks, tables, headings, or reference definitions

### Example with automatic reflow

```yaml
MD013:
  line_length: 80
  enable_reflow: true
```

With this configuration, long lines will be automatically wrapped to fit within 80 characters while maintaining proper Markdown formatting.

**Note**: When `enable_reflow` is `false` (default), automatic fixes are not available and you'll need to manually wrap long lines.

## Learn more

- [Line length best practices](https://en.wikipedia.org/wiki/Line_length)
- [Readability and line length](https://baymard.com/blog/line-length-readability)

## Related rules

- [MD009](md009.md): Remove trailing spaces at line ends
- [MD010](md010.md): Use spaces instead of tabs
- [MD047](md047.md): End files with a single newline
