# MD040 - Code blocks should have a language specified

## What this rule does

Ensures code blocks (```) specify what programming language they contain.

## Why this matters

- **Syntax highlighting**: Editors and renderers can color-code the syntax correctly
- **Clarity**: Readers immediately know what language they're looking at
- **Tools**: Some tools use language hints for processing or validation

## Examples

### ✅ Correct

````markdown
```python
def hello():
    print("Hello, world!")
```

```javascript
console.log("Hello, world!");
```

```bash
echo "Hello, world!"
```
````

### ❌ Incorrect

<!-- rumdl-disable MD040 MD031 -->

````markdown
```
def hello():
    print("Hello, world!")
```

```
console.log("Hello, world!");
```
````

<!-- rumdl-enable MD040 MD031 -->

### 🔧 Fixed

````markdown
```text
def hello():
    print("Hello, world!")
```

```text
console.log("Hello, world!");
```
````

> **Note**: The fix adds `text` as a default language hint when none is specified.

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule automatically adds `text` as the language specifier for code blocks without one.

## Learn more

- [CommonMark fenced code blocks](https://spec.commonmark.org/0.31.2/#fenced-code-blocks) - Technical specification
- [GitHub Flavored Markdown](https://github.github.com/gfm/#info-string) - Language hints in code blocks

## Related rules

- [MD046](md046.md) - Code block style should be consistent
- [MD048](md048.md) - Code fence style should be consistent
- [MD031](md031.md) - Code blocks should be surrounded by blank lines
