# MD047 - End Files with a Single Newline

## What this rule does

Ensures every file ends with exactly one newline character, following standard text file conventions.

## Why this matters

- **Version control**: Git and other tools expect files to end with newlines
- **File concatenation**: Prevents issues when combining files
- **Terminal display**: Files display correctly in command-line tools
- **Cross-platform compatibility**: Consistent behavior across operating systems

## Examples

### ✅ Correct

```markdown
# My Document

This is the content of my document.

The last line ends with a single newline.
```

(Note: There's an invisible newline after "newline.")

### ❌ Incorrect  

```markdown
# My Document

This is the content of my document.

The last line has no newline.
```

(Note: In the actual file, there would be no newline after "newline." - the file ends immediately)

```markdown
# My Document  

This is the content of my document.

The last line has multiple newlines.


```

(Note: Multiple blank lines at the end)

### 🔧 Fixed

```markdown
# My Document

This is the content of my document.

The last line now ends with a single newline.
```

(Note: Exactly one newline added at the end)

## Configuration

This rule has no configuration options.

## Automatic fixes

When enabled, this rule will:
- Add a newline if the file doesn't end with one
- Remove extra newlines if there are multiple
- Ensure exactly one newline at the end

## Why this matters technically

- Many text editors automatically add this newline
- POSIX defines a line as ending with a newline
- Prevents "No newline at end of file" warnings
- Makes file processing more predictable

## Special cases

- Empty files are considered valid
- Binary files are not checked
- The rule only checks for a single newline, not multiple blank lines (see MD012)

## Learn more

- [POSIX definition of a text file](https://pubs.opengroup.org/onlinepubs/9699919799/basedefs/V1_chap03.html#tag_03_206)
- [Why files should end with a newline](https://stackoverflow.com/questions/729692/why-should-text-files-end-with-a-newline)

## Related rules

- [MD012](md012.md) - Remove multiple consecutive blank lines
- [MD022](md022.md) - Add blank lines around headings
- [MD031](md031.md) - Add blank lines around code blocks
