import llvm2py
import re

src = """
; RUN: llvm-as < %s | llvm-dis > %t.orig
; RUN: llvm-as < %s | llvm-c-test --echo > %t.echo
; RUN: diff -w %t.orig %t.echo

source_filename = "/test/Bindings/echo.ll"
target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.11.0"

module asm "classical GAS"

%S = type { i64, %S* }

@var = global i32 42
@ext = external global i32*
@cst = constant %S { i64 1, %S* @cst }
@tl = thread_local global { i64, %S* } { i64 1, %S* @cst }
@arr = linkonce_odr global [5 x i8] [ i8 2, i8 3, i8 5, i8 7, i8 11 ]
@str = private unnamed_addr constant [13 x i8] c"hello world\\0A\\00"
@locStr = private local_unnamed_addr constant [13 x i8] c"hello world\\0A\\00"
@hidden = hidden global i32 7
@protected = protected global i32 23
@section = global i32 27, section ".custom"
@align = global i32 31, align 4
@nullptr = global i32* null

@const_gep = global i32* getelementptr (i32, i32* @var, i64 2)
@const_inbounds_gep = global i32* getelementptr inbounds (i32, i32* @var, i64 1)

@aliased1 = alias i32, i32* @var
@aliased2 = internal alias i32, i32* @var
@aliased3 = external alias i32, i32* @var
@aliased4 = weak alias i32, i32* @var
@aliased5 = weak_odr alias i32, i32* @var

@ifunc = ifunc i32 (i32), i32 (i32)* ()* @ifunc_resolver

define i32 (i32)* @ifunc_resolver() {
entry:
  ret i32 (i32)* null
}

define { i64, %S* } @unpackrepack(%S %s) {
  %1 = extractvalue %S %s, 0
  %2 = extractvalue %S %s, 1
  %3 = insertvalue { i64, %S* } undef, %S* %2, 1
  %4 = insertvalue { i64, %S* } %3, i64 %1, 0
  ret { i64, %S* } %4
}

declare void @decl()

; TODO: label and metadata types
define void @types() {
  %1 = alloca half, align 2
  %2 = alloca float, align 4
  %3 = alloca double, align 8
  %4 = alloca x86_fp80, align 16
  %5 = alloca fp128, align 16
  %6 = alloca ppc_fp128, align 16
  %7 = alloca inalloca i7, align 1
  %8 = alloca void (i1)*, align 8
  %9 = alloca [3 x i22], align 4
  %10 = alloca i328 addrspace(5)*, align 8
  %11 = alloca <5 x i23*>, align 64
  ret void
}

define double @fops(double %a, double %b) {
  %1 = fneg nnan double %a
  %2 = fadd ninf double %a, %b
  %3 = fsub nsz double %a, %b
  %4 = fmul arcp double %a, %b
  %5 = fdiv contract afn reassoc double %a, %b
  %6 = frem contract afn reassoc double %a, %b
  ret double %6
}

define i32 @iops(i32 %a, i32 %b) {
  %1 = add i32 %a, %b
  %2 = mul nsw i32 %a, %1
  %3 = sub nuw nsw i32 %2, %1
  %4 = udiv exact i32 %3, %b
  %5 = sdiv i32 %2, %4
  %6 = urem i32 %3, %5
  %7 = srem i32 %2, %6
  %8 = shl nuw i32 %1, %b
  %9 = lshr exact i32 %a, %7
  %10 = ashr i32 %b, %8
  %11 = and i32 %9, %10
  %12 = or disjoint i32 %2, %11
  %13 = xor i32 %12, %4
  ret i32 %13
}

define i32 @call() {
  %1 = call i32 @iops(i32 23, i32 19)
  %2 = call fast double @fops(double immarg 3.0, double 71.0)
  ret i32 %1
}

define i32 @cond(i32 %a, i32 %b) {
  br label %br
unreachable:
  unreachable
br:
  %1 = icmp eq i32 %a, %b
  br i1 %1, label %next0, label %unreachable
next0:
  %2 = icmp ne i32 %a, %b
  br i1 %2, label %next1, label %unreachable
next1:
  %3 = icmp ugt i32 %a, %b
  br i1 %3, label %next2, label %unreachable
next2:
  %4 = icmp uge i32 %a, %b
  br i1 %4, label %next3, label %unreachable
next3:
  %5 = icmp ult i32 %a, %b
  br i1 %5, label %next4, label %unreachable
next4:
  %6 = icmp ule i32 %a, %b
  br i1 %6, label %next5, label %unreachable
next5:
  %7 = icmp sgt i32 %a, %b
  br i1 %7, label %next6, label %unreachable
next6:
  %8 = icmp sge i32 %a, %b
  br i1 %8, label %next7, label %unreachable
next7:
  %9 = icmp slt i32 %a, %b
  br i1 %9, label %next8, label %unreachable
next8:
  %10 = fcmp fast olt double 1.0, 2.0
  br i1 %10, label %next9, label %unreachable
next9:
  ret i32 0
}

define i32 @loop(i32 %i) {
  br label %cond
cond:
  %c = phi i32 [ %i, %0 ], [ %j, %do ]
  %p = phi i32 [ %r, %do ], [ 789, %0 ]
  %1 = icmp eq i32 %c, 0
  br i1 %1, label %do, label %done
do:
  %2 = sub i32 %p, 23
  %j = sub i32 %i, 1
  %r = mul i32 %2, 3
  br label %cond
done:
  ret i32 %p
}

define void @memops(i8* %ptr) {
  %a = load i8, i8* %ptr
  %b = load volatile i8, i8* %ptr
  %c = load i8, i8* %ptr, align 8
  %d = load atomic i8, i8* %ptr acquire, align 32
  store i8 0, i8* %ptr
  store volatile i8 0, i8* %ptr
  store i8 0, i8* %ptr, align 8
  store atomic i8 0, i8* %ptr release, align 32
  %e = atomicrmw add i8* %ptr, i8 0 monotonic, align 1
  %f = atomicrmw volatile xchg i8* %ptr, i8 0 acq_rel, align 8
  %g = cmpxchg i8* %ptr, i8 1, i8 2 seq_cst acquire, align 1
  %h = cmpxchg weak i8* %ptr, i8 1, i8 2 seq_cst acquire, align 8
  %i = cmpxchg volatile i8* %ptr, i8 1, i8 2 monotonic monotonic, align 16
  ret void
}

define i32 @vectorops(i32, i32) {
  %a = insertelement <4 x i32> undef, i32 %0, i32 0
  %b = insertelement <4 x i32> %a, i32 %1, i32 2
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = shufflevector <4 x i32> %c, <4 x i32> %b, <4 x i32> <i32 1, i32 2, i32 3, i32 0>
  %e = add <4 x i32> %d, %a
  %f = mul <4 x i32> %e, %b
  %g = xor <4 x i32> %f, %d
  %h = or <4 x i32> %f, %e
  %i = lshr <4 x i32> %h, <i32 2, i32 2, i32 2, i32 2>
  %j = shl <4 x i32> %i, <i32 2, i32 3, i32 4, i32 5>
  %k = shufflevector <4 x i32> %j, <4 x i32> %i, <4 x i32> <i32 2, i32 3, i32 undef, i32 undef>
  %m = shufflevector <4 x i32> %k, <4 x i32> undef, <1 x i32> <i32 1>
  %n = shufflevector <4 x i32> %j, <4 x i32> undef, <8 x i32> <i32 0, i32 0, i32 1, i32 2, i32 undef, i32 3, i32 undef, i32 undef>
  %p = extractelement <8 x i32> %n, i32 5
  ret i32 %p
}

define i32 @scalablevectorops(i32, <vscale x 4 x i32>) {
  %a = insertelement <vscale x 4 x i32> undef, i32 %0, i32 0
  %b = insertelement <vscale x 4 x i32> %a, i32 %0, i32 2
  %c = shufflevector <vscale x 4 x i32> %b, <vscale x 4 x i32> undef, <vscale x 4 x i32> zeroinitializer
  %e = add <vscale x 4 x i32> %a, %1
  %f = mul <vscale x 4 x i32> %e, %b
  %g = xor <vscale x 4 x i32> %f, %e
  %h = or <vscale x 4 x i32> %g, %e
  %i = lshr <vscale x 4 x i32> %h, undef
  %j = extractelement <vscale x 4 x i32> %i, i32 3
  ret i32 %j
}

declare void @personalityFn()

define void @exn() personality void ()* @personalityFn {
entry:
  invoke void @decl()
          to label %via.cleanup unwind label %exn.dispatch
via.cleanup:
  invoke void @decl()
          to label %via.catchswitch unwind label %cleanup.inner
cleanup.inner:
  %cp.inner = cleanuppad within none []
  cleanupret from %cp.inner unwind label %exn.dispatch
via.catchswitch:
  invoke void @decl()
          to label %exit unwind label %dispatch.inner
dispatch.inner:
  %cs.inner = catchswitch within none [label %pad.inner] unwind label %exn.dispatch
pad.inner:
  %catch.inner = catchpad within %cs.inner [i32 0]
  catchret from %catch.inner to label %exit
exn.dispatch:
  %cs = catchswitch within none [label %pad1, label %pad2] unwind label %cleanup
pad1:
  catchpad within %cs [i32 1]
  unreachable
pad2:
  catchpad within %cs [i32 2]
  unreachable
cleanup:
  %cp = cleanuppad within none []
  cleanupret from %cp unwind to caller
exit:
  ret void
}

declare i8* @llvm.stacksave()
declare void @llvm.stackrestore(i8*)
declare void @llvm.lifetime.start.p0i8(i64, i8*)
declare void @llvm.lifetime.end.p0i8(i64, i8*)

define void @test_intrinsics() {
entry:
  %sp = call i8* @llvm.stacksave()
  %x = alloca i32, align 4
  %0 = bitcast i32* %x to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0)
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %0)
  call void @llvm.stackrestore(i8* %sp)
  ret void
}
"""

reference = """Module(funcs={'ifunc_resolver': Function(value=Value(val='ifunc_resolver', ty=FunctionType(param_tys=[], ret_ty=PtrType(addr_space=0, ty=None))), args=[], blocks={'entry': Block(value=Value(val='entry', ty=LabelType()), instrs=[Ret(value=Value(val=None, ty=PtrType(addr_space=0, ty=None)))], pred_blocks=[])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'unpackrepack': Function(value=Value(val='unpackrepack', ty=FunctionType(param_tys=[StructureType(name='S', elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)], ret_ty=StructureType(name=None, elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False))), args=[Value(val='s', ty=StructureType(name='S', elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False))], blocks={'%0': Block(value=Value(val='%0', ty=LabelType()), instrs=[ExtractValue(result=Value(val='%1', ty=IntegerType(num_bits=64)), aggregate=Value(val='s', ty=StructureType(name='S', elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)), indices=[0]), ExtractValue(result=Value(val='%2', ty=PtrType(addr_space=0, ty=None)), aggregate=Value(val='s', ty=StructureType(name='S', elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)), indices=[1]), InsertValue(result=Value(val='%3', ty=StructureType(name=None, elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)), aggregate=Value(val='undef', ty=StructureType(name=None, elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)), elem=Value(val='%2', ty=PtrType(addr_space=0, ty=None)), indices=[1]), InsertValue(result=Value(val='%4', ty=StructureType(name=None, elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)), aggregate=Value(val='%3', ty=StructureType(name=None, elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)), elem=Value(val='%1', ty=IntegerType(num_bits=64)), indices=[0]), Ret(value=Value(val='%4', ty=StructureType(name=None, elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)))], pred_blocks=[])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'decl': Function(value=Value(val='decl', ty=FunctionType(param_tys=[], ret_ty=VoidType())), args=[], blocks={}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'types': Function(value=Value(val='types', ty=FunctionType(param_tys=[], ret_ty=VoidType())), args=[], blocks={'%0': Block(value=Value(val='%0', ty=LabelType()), instrs=[Alloca(result=Value(val='%1', ty=PtrType(addr_space=0, ty=None)), allocated_ty=FPType(kind='half'), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=2, is_inalloca=False), Alloca(result=Value(val='%2', ty=PtrType(addr_space=0, ty=None)), allocated_ty=FPType(kind='float'), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=4, is_inalloca=False), Alloca(result=Value(val='%3', ty=PtrType(addr_space=0, ty=None)), allocated_ty=FPType(kind='double'), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=8, is_inalloca=False), Alloca(result=Value(val='%4', ty=PtrType(addr_space=0, ty=None)), allocated_ty=FPType(kind='x86_fp80'), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=16, is_inalloca=False), Alloca(result=Value(val='%5', ty=PtrType(addr_space=0, ty=None)), allocated_ty=FPType(kind='fp128'), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=16, is_inalloca=False), Alloca(result=Value(val='%6', ty=PtrType(addr_space=0, ty=None)), allocated_ty=FPType(kind='ppc_fp128'), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=16, is_inalloca=False), Alloca(result=Value(val='%7', ty=PtrType(addr_space=0, ty=None)), allocated_ty=IntegerType(num_bits=7), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=1, is_inalloca=True), Alloca(result=Value(val='%8', ty=PtrType(addr_space=0, ty=None)), allocated_ty=PtrType(addr_space=0, ty=None), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=8, is_inalloca=False), Alloca(result=Value(val='%9', ty=PtrType(addr_space=0, ty=None)), allocated_ty=ArrayType(elem_count=3, elem_ty=IntegerType(num_bits=22)), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=4, is_inalloca=False), Alloca(result=Value(val='%10', ty=PtrType(addr_space=0, ty=None)), allocated_ty=PtrType(addr_space=5, ty=None), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=8, is_inalloca=False), Alloca(result=Value(val='%11', ty=PtrType(addr_space=0, ty=None)), allocated_ty=VectorType(elem_count=5, elem_ty=PtrType(addr_space=0, ty=None), is_scalable=False), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=64, is_inalloca=False), Ret(value=None)], pred_blocks=[])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'fops': Function(value=Value(val='fops', ty=FunctionType(param_tys=[FPType(kind='double'), FPType(kind='double')], ret_ty=FPType(kind='double'))), args=[Value(val='a', ty=FPType(kind='double')), Value(val='b', ty=FPType(kind='double'))], blocks={'%0': Block(value=Value(val='%0', ty=LabelType()), instrs=[UnaryOp(opcode='fneg', result=Value(val='%1', ty=FPType(kind='double')), operand=Value(val='a', ty=FPType(kind='double')), fast_math_flags=frozenset), BinOp(opcode='fadd', result=Value(val='%2', ty=FPType(kind='double')), fst_operand=Value(val='a', ty=FPType(kind='double')), snd_operand=Value(val='b', ty=FPType(kind='double')), fast_math_flags=frozenset, is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='fsub', result=Value(val='%3', ty=FPType(kind='double')), fst_operand=Value(val='a', ty=FPType(kind='double')), snd_operand=Value(val='b', ty=FPType(kind='double')), fast_math_flags=frozenset, is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='fmul', result=Value(val='%4', ty=FPType(kind='double')), fst_operand=Value(val='a', ty=FPType(kind='double')), snd_operand=Value(val='b', ty=FPType(kind='double')), fast_math_flags=frozenset, is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='fdiv', result=Value(val='%5', ty=FPType(kind='double')), fst_operand=Value(val='a', ty=FPType(kind='double')), snd_operand=Value(val='b', ty=FPType(kind='double')), fast_math_flags=frozenset, is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='frem', result=Value(val='%6', ty=FPType(kind='double')), fst_operand=Value(val='a', ty=FPType(kind='double')), snd_operand=Value(val='b', ty=FPType(kind='double')), fast_math_flags=frozenset, is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), Ret(value=Value(val='%6', ty=FPType(kind='double')))], pred_blocks=[])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'iops': Function(value=Value(val='iops', ty=FunctionType(param_tys=[IntegerType(num_bits=32), IntegerType(num_bits=32)], ret_ty=IntegerType(num_bits=32))), args=[Value(val='a', ty=IntegerType(num_bits=32)), Value(val='b', ty=IntegerType(num_bits=32))], blocks={'%0': Block(value=Value(val='%0', ty=LabelType()), instrs=[BinOp(opcode='add', result=Value(val='%1', ty=IntegerType(num_bits=32)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='mul', result=Value(val='%2', ty=IntegerType(num_bits=32)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%1', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=True, is_exact=False, is_disjoint=False), BinOp(opcode='sub', result=Value(val='%3', ty=IntegerType(num_bits=32)), fst_operand=Value(val='%2', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%1', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=True, is_nsw=True, is_exact=False, is_disjoint=False), BinOp(opcode='udiv', result=Value(val='%4', ty=IntegerType(num_bits=32)), fst_operand=Value(val='%3', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=True, is_disjoint=False), BinOp(opcode='sdiv', result=Value(val='%5', ty=IntegerType(num_bits=32)), fst_operand=Value(val='%2', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%4', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='urem', result=Value(val='%6', ty=IntegerType(num_bits=32)), fst_operand=Value(val='%3', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%5', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='srem', result=Value(val='%7', ty=IntegerType(num_bits=32)), fst_operand=Value(val='%2', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%6', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='shl', result=Value(val='%8', ty=IntegerType(num_bits=32)), fst_operand=Value(val='%1', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=True, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='lshr', result=Value(val='%9', ty=IntegerType(num_bits=32)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%7', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=True, is_disjoint=False), BinOp(opcode='ashr', result=Value(val='%10', ty=IntegerType(num_bits=32)), fst_operand=Value(val='b', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%8', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='and', result=Value(val='%11', ty=IntegerType(num_bits=32)), fst_operand=Value(val='%9', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%10', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='or', result=Value(val='%12', ty=IntegerType(num_bits=32)), fst_operand=Value(val='%2', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%11', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=True), BinOp(opcode='xor', result=Value(val='%13', ty=IntegerType(num_bits=32)), fst_operand=Value(val='%12', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%4', ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), Ret(value=Value(val='%13', ty=IntegerType(num_bits=32)))], pred_blocks=[])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'call': Function(value=Value(val='call', ty=FunctionType(param_tys=[], ret_ty=IntegerType(num_bits=32))), args=[], blocks={'%0': Block(value=Value(val='%0', ty=LabelType()), instrs=[Call(result=Value(val='%1', ty=IntegerType(num_bits=32)), callee=Value(val='iops', ty=FunctionType(param_tys=[IntegerType(num_bits=32), IntegerType(num_bits=32)], ret_ty=IntegerType(num_bits=32))), args=[Value(val=23, ty=IntegerType(num_bits=32)), Value(val=19, ty=IntegerType(num_bits=32))], calling_conv=<CallingConv.C: 0>, call_attrs=[], tail_kind=None, fast_math_flags=frozenset()), Call(result=Value(val='%2', ty=FPType(kind='double')), callee=Value(val='fops', ty=FunctionType(param_tys=[FPType(kind='double'), FPType(kind='double')], ret_ty=FPType(kind='double'))), args=[Value(val=3.0, ty=FPType(kind='double')), Value(val=71.0, ty=FPType(kind='double'))], calling_conv=<CallingConv.C: 0>, call_attrs=[{}, {}, {'immarg': ()}], tail_kind=None, fast_math_flags=frozenset), Ret(value=Value(val='%1', ty=IntegerType(num_bits=32)))], pred_blocks=[])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'cond': Function(value=Value(val='cond', ty=FunctionType(param_tys=[IntegerType(num_bits=32), IntegerType(num_bits=32)], ret_ty=IntegerType(num_bits=32))), args=[Value(val='a', ty=IntegerType(num_bits=32)), Value(val='b', ty=IntegerType(num_bits=32))], blocks={'%0': Block(value=Value(val='%0', ty=LabelType()), instrs=[Br(cond=None, label_false=Value(val='br', ty=LabelType()), label_true=None)], pred_blocks=[]), 'unreachable': Block(value=Value(val='unreachable', ty=LabelType()), instrs=[Unreacheble], pred_blocks=['next8', 'next7', 'next6', 'next5', 'next4', 'next3', 'next2', 'next1', 'next0', 'br']), 'br': Block(value=Value(val='br', ty=LabelType()), instrs=[ICmp(cond='eq', result=Value(val='%1', ty=IntegerType(num_bits=1)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32))), Br(cond=Value(val='%1', ty=IntegerType(num_bits=1)), label_false=Value(val='unreachable', ty=LabelType()), label_true=Value(val='next0', ty=LabelType()))], pred_blocks=['%0']), 'next0': Block(value=Value(val='next0', ty=LabelType()), instrs=[ICmp(cond='ne', result=Value(val='%2', ty=IntegerType(num_bits=1)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32))), Br(cond=Value(val='%2', ty=IntegerType(num_bits=1)), label_false=Value(val='unreachable', ty=LabelType()), label_true=Value(val='next1', ty=LabelType()))], pred_blocks=['br']), 'next1': Block(value=Value(val='next1', ty=LabelType()), instrs=[ICmp(cond='ugt', result=Value(val='%3', ty=IntegerType(num_bits=1)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32))), Br(cond=Value(val='%3', ty=IntegerType(num_bits=1)), label_false=Value(val='unreachable', ty=LabelType()), label_true=Value(val='next2', ty=LabelType()))], pred_blocks=['next0']), 'next2': Block(value=Value(val='next2', ty=LabelType()), instrs=[ICmp(cond='uge', result=Value(val='%4', ty=IntegerType(num_bits=1)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32))), Br(cond=Value(val='%4', ty=IntegerType(num_bits=1)), label_false=Value(val='unreachable', ty=LabelType()), label_true=Value(val='next3', ty=LabelType()))], pred_blocks=['next1']), 'next3': Block(value=Value(val='next3', ty=LabelType()), instrs=[ICmp(cond='ult', result=Value(val='%5', ty=IntegerType(num_bits=1)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32))), Br(cond=Value(val='%5', ty=IntegerType(num_bits=1)), label_false=Value(val='unreachable', ty=LabelType()), label_true=Value(val='next4', ty=LabelType()))], pred_blocks=['next2']), 'next4': Block(value=Value(val='next4', ty=LabelType()), instrs=[ICmp(cond='ule', result=Value(val='%6', ty=IntegerType(num_bits=1)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32))), Br(cond=Value(val='%6', ty=IntegerType(num_bits=1)), label_false=Value(val='unreachable', ty=LabelType()), label_true=Value(val='next5', ty=LabelType()))], pred_blocks=['next3']), 'next5': Block(value=Value(val='next5', ty=LabelType()), instrs=[ICmp(cond='sgt', result=Value(val='%7', ty=IntegerType(num_bits=1)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32))), Br(cond=Value(val='%7', ty=IntegerType(num_bits=1)), label_false=Value(val='unreachable', ty=LabelType()), label_true=Value(val='next6', ty=LabelType()))], pred_blocks=['next4']), 'next6': Block(value=Value(val='next6', ty=LabelType()), instrs=[ICmp(cond='sge', result=Value(val='%8', ty=IntegerType(num_bits=1)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32))), Br(cond=Value(val='%8', ty=IntegerType(num_bits=1)), label_false=Value(val='unreachable', ty=LabelType()), label_true=Value(val='next7', ty=LabelType()))], pred_blocks=['next5']), 'next7': Block(value=Value(val='next7', ty=LabelType()), instrs=[ICmp(cond='slt', result=Value(val='%9', ty=IntegerType(num_bits=1)), fst_operand=Value(val='a', ty=IntegerType(num_bits=32)), snd_operand=Value(val='b', ty=IntegerType(num_bits=32))), Br(cond=Value(val='%9', ty=IntegerType(num_bits=1)), label_false=Value(val='unreachable', ty=LabelType()), label_true=Value(val='next8', ty=LabelType()))], pred_blocks=['next6']), 'next8': Block(value=Value(val='next8', ty=LabelType()), instrs=[FCmp(cond='olt', result=Value(val='%10', ty=IntegerType(num_bits=1)), fst_operand=Value(val=1.0, ty=FPType(kind='double')), snd_operand=Value(val=2.0, ty=FPType(kind='double')), fast_math_flags=frozenset), Br(cond=Value(val='%10', ty=IntegerType(num_bits=1)), label_false=Value(val='unreachable', ty=LabelType()), label_true=Value(val='next9', ty=LabelType()))], pred_blocks=['next7']), 'next9': Block(value=Value(val='next9', ty=LabelType()), instrs=[Ret(value=Value(val=0, ty=IntegerType(num_bits=32)))], pred_blocks=['next8'])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'loop': Function(value=Value(val='loop', ty=FunctionType(param_tys=[IntegerType(num_bits=32)], ret_ty=IntegerType(num_bits=32))), args=[Value(val='i', ty=IntegerType(num_bits=32))], blocks={'%0': Block(value=Value(val='%0', ty=LabelType()), instrs=[Br(cond=None, label_false=Value(val='cond', ty=LabelType()), label_true=None)], pred_blocks=[]), 'cond': Block(value=Value(val='cond', ty=LabelType()), instrs=[Phi(result=Value(val='c', ty=IntegerType(num_bits=32)), vals=[(Value(val='i', ty=IntegerType(num_bits=32)), Value(val='%0', ty=LabelType())), (Value(val='j', ty=IntegerType(num_bits=32)), Value(val='do', ty=LabelType()))], fast_math_flags=frozenset()), Phi(result=Value(val='p', ty=IntegerType(num_bits=32)), vals=[(Value(val='r', ty=IntegerType(num_bits=32)), Value(val='do', ty=LabelType())), (Value(val=789, ty=IntegerType(num_bits=32)), Value(val='%0', ty=LabelType()))], fast_math_flags=frozenset()), ICmp(cond='eq', result=Value(val='%1', ty=IntegerType(num_bits=1)), fst_operand=Value(val='c', ty=IntegerType(num_bits=32)), snd_operand=Value(val=0, ty=IntegerType(num_bits=32))), Br(cond=Value(val='%1', ty=IntegerType(num_bits=1)), label_false=Value(val='done', ty=LabelType()), label_true=Value(val='do', ty=LabelType()))], pred_blocks=['do', '%0']), 'do': Block(value=Value(val='do', ty=LabelType()), instrs=[BinOp(opcode='sub', result=Value(val='%2', ty=IntegerType(num_bits=32)), fst_operand=Value(val='p', ty=IntegerType(num_bits=32)), snd_operand=Value(val=23, ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='sub', result=Value(val='j', ty=IntegerType(num_bits=32)), fst_operand=Value(val='i', ty=IntegerType(num_bits=32)), snd_operand=Value(val=1, ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='mul', result=Value(val='r', ty=IntegerType(num_bits=32)), fst_operand=Value(val='%2', ty=IntegerType(num_bits=32)), snd_operand=Value(val=3, ty=IntegerType(num_bits=32)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), Br(cond=None, label_false=Value(val='cond', ty=LabelType()), label_true=None)], pred_blocks=['cond']), 'done': Block(value=Value(val='done', ty=LabelType()), instrs=[Ret(value=Value(val='p', ty=IntegerType(num_bits=32)))], pred_blocks=['cond'])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'memops': Function(value=Value(val='memops', ty=FunctionType(param_tys=[PtrType(addr_space=0, ty=None)], ret_ty=VoidType())), args=[Value(val='ptr', ty=PtrType(addr_space=0, ty=None))], blocks={'%0': Block(value=Value(val='%0', ty=LabelType()), instrs=[Load(result=Value(val='a', ty=IntegerType(num_bits=8)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), align=1, is_volatile=False, is_atomic=False, ordering=<Ordering.NotAtomic: 0>, syncscope=1), Load(result=Value(val='b', ty=IntegerType(num_bits=8)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), align=1, is_volatile=True, is_atomic=False, ordering=<Ordering.NotAtomic: 0>, syncscope=1), Load(result=Value(val='c', ty=IntegerType(num_bits=8)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), align=8, is_volatile=False, is_atomic=False, ordering=<Ordering.NotAtomic: 0>, syncscope=1), Load(result=Value(val='d', ty=IntegerType(num_bits=8)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), align=32, is_volatile=False, is_atomic=True, ordering=<Ordering.Acquire: 4>, syncscope=1), Store(value=Value(val=0, ty=IntegerType(num_bits=8)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), align=1, is_volatile=False, is_atomic=False, ordering=<Ordering.NotAtomic: 0>, syncscope=1), Store(value=Value(val=0, ty=IntegerType(num_bits=8)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), align=1, is_volatile=True, is_atomic=False, ordering=<Ordering.NotAtomic: 0>, syncscope=1), Store(value=Value(val=0, ty=IntegerType(num_bits=8)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), align=8, is_volatile=False, is_atomic=False, ordering=<Ordering.NotAtomic: 0>, syncscope=1), Store(value=Value(val=0, ty=IntegerType(num_bits=8)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), align=32, is_volatile=False, is_atomic=True, ordering=<Ordering.Release: 5>, syncscope=1), AtomicRmw(op='add', result=Value(val='e', ty=IntegerType(num_bits=8)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), operand=Value(val=0, ty=IntegerType(num_bits=8)), ordering=<Ordering.Monotonic: 2>, align=1, is_volatile=False, syncscope=1), AtomicRmw(op='xchg', result=Value(val='f', ty=IntegerType(num_bits=8)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), operand=Value(val=0, ty=IntegerType(num_bits=8)), ordering=<Ordering.AcquireRelease: 6>, align=8, is_volatile=True, syncscope=1), CmpXchg(result=Value(val='g', ty=StructureType(name=None, elem_tys=[IntegerType(num_bits=8), IntegerType(num_bits=1)], is_packed=False)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), compare_value=Value(val=1, ty=IntegerType(num_bits=8)), new_value=Value(val=2, ty=IntegerType(num_bits=8)), ordering_ok=<Ordering.SequentiallyConsistent: 7>, ordering_err=<Ordering.Acquire: 4>, align=1, is_weak=False, is_volatile=False, syncscope=1), CmpXchg(result=Value(val='h', ty=StructureType(name=None, elem_tys=[IntegerType(num_bits=8), IntegerType(num_bits=1)], is_packed=False)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), compare_value=Value(val=1, ty=IntegerType(num_bits=8)), new_value=Value(val=2, ty=IntegerType(num_bits=8)), ordering_ok=<Ordering.SequentiallyConsistent: 7>, ordering_err=<Ordering.Acquire: 4>, align=8, is_weak=True, is_volatile=False, syncscope=1), CmpXchg(result=Value(val='i', ty=StructureType(name=None, elem_tys=[IntegerType(num_bits=8), IntegerType(num_bits=1)], is_packed=False)), address=Value(val='ptr', ty=PtrType(addr_space=0, ty=None)), compare_value=Value(val=1, ty=IntegerType(num_bits=8)), new_value=Value(val=2, ty=IntegerType(num_bits=8)), ordering_ok=<Ordering.Monotonic: 2>, ordering_err=<Ordering.Monotonic: 2>, align=16, is_weak=False, is_volatile=True, syncscope=1), Ret(value=None)], pred_blocks=[])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'vectorops': Function(value=Value(val='vectorops', ty=FunctionType(param_tys=[IntegerType(num_bits=32), IntegerType(num_bits=32)], ret_ty=IntegerType(num_bits=32))), args=[Value(val='%0', ty=IntegerType(num_bits=32)), Value(val='%1', ty=IntegerType(num_bits=32))], blocks={'%2': Block(value=Value(val='%2', ty=LabelType()), instrs=[InsertElement(result=Value(val='a', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), vector=Value(val='undef', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), elem=Value(val='%0', ty=IntegerType(num_bits=32)), index=Value(val=0, ty=IntegerType(num_bits=32))), InsertElement(result=Value(val='b', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), vector=Value(val='a', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), elem=Value(val='%1', ty=IntegerType(num_bits=32)), index=Value(val=2, ty=IntegerType(num_bits=32))), ShuffleVector(result=Value(val='c', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fst_vector=Value(val='b', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), snd_vector=Value(val='undef', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), mask_vector=[0, 0, 0, 0]), ShuffleVector(result=Value(val='d', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fst_vector=Value(val='c', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), snd_vector=Value(val='b', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), mask_vector=[1, 2, 3, 0]), BinOp(opcode='add', result=Value(val='e', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fst_operand=Value(val='d', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), snd_operand=Value(val='a', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='mul', result=Value(val='f', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fst_operand=Value(val='e', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), snd_operand=Value(val='b', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='xor', result=Value(val='g', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fst_operand=Value(val='f', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), snd_operand=Value(val='d', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='or', result=Value(val='h', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fst_operand=Value(val='f', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), snd_operand=Value(val='e', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='lshr', result=Value(val='i', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fst_operand=Value(val='h', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), snd_operand=Value(val=[2, 2, 2, 2], ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='shl', result=Value(val='j', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fst_operand=Value(val='i', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), snd_operand=Value(val=[2, 3, 4, 5], ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), ShuffleVector(result=Value(val='k', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fst_vector=Value(val='j', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), snd_vector=Value(val='i', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), mask_vector=[2, 3, -1, -1]), ShuffleVector(result=Value(val='m', ty=VectorType(elem_count=1, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fst_vector=Value(val='k', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), snd_vector=Value(val='undef', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), mask_vector=[1]), ShuffleVector(result=Value(val='n', ty=VectorType(elem_count=8, elem_ty=IntegerType(num_bits=32), is_scalable=False)), fst_vector=Value(val='j', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), snd_vector=Value(val='undef', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=False)), mask_vector=[0, 0, 1, 2, -1, 3, -1, -1]), ExtractElement(result=Value(val='p', ty=IntegerType(num_bits=32)), vector=Value(val='n', ty=VectorType(elem_count=8, elem_ty=IntegerType(num_bits=32), is_scalable=False)), index=Value(val=5, ty=IntegerType(num_bits=32))), Ret(value=Value(val='p', ty=IntegerType(num_bits=32)))], pred_blocks=[])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'scalablevectorops': Function(value=Value(val='scalablevectorops', ty=FunctionType(param_tys=[IntegerType(num_bits=32), VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)], ret_ty=IntegerType(num_bits=32))), args=[Value(val='%0', ty=IntegerType(num_bits=32)), Value(val='%1', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True))], blocks={'%2': Block(value=Value(val='%2', ty=LabelType()), instrs=[InsertElement(result=Value(val='a', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), vector=Value(val='undef', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), elem=Value(val='%0', ty=IntegerType(num_bits=32)), index=Value(val=0, ty=IntegerType(num_bits=32))), InsertElement(result=Value(val='b', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), vector=Value(val='a', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), elem=Value(val='%0', ty=IntegerType(num_bits=32)), index=Value(val=2, ty=IntegerType(num_bits=32))), ShuffleVector(result=Value(val='c', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), fst_vector=Value(val='b', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), snd_vector=Value(val='undef', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), mask_vector=[0, 0, 0, 0]), BinOp(opcode='add', result=Value(val='e', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), fst_operand=Value(val='a', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), snd_operand=Value(val='%1', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='mul', result=Value(val='f', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), fst_operand=Value(val='e', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), snd_operand=Value(val='b', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='xor', result=Value(val='g', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), fst_operand=Value(val='f', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), snd_operand=Value(val='e', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='or', result=Value(val='h', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), fst_operand=Value(val='g', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), snd_operand=Value(val='e', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), BinOp(opcode='lshr', result=Value(val='i', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), fst_operand=Value(val='h', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), snd_operand=Value(val='undef', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False, is_exact=False, is_disjoint=False), ExtractElement(result=Value(val='j', ty=IntegerType(num_bits=32)), vector=Value(val='i', ty=VectorType(elem_count=4, elem_ty=IntegerType(num_bits=32), is_scalable=True)), index=Value(val=3, ty=IntegerType(num_bits=32))), Ret(value=Value(val='j', ty=IntegerType(num_bits=32)))], pred_blocks=[])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'personalityFn': Function(value=Value(val='personalityFn', ty=FunctionType(param_tys=[], ret_ty=VoidType())), args=[], blocks={}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'exn': Function(value=Value(val='exn', ty=FunctionType(param_tys=[], ret_ty=VoidType())), args=[], blocks={'entry': Block(value=Value(val='entry', ty=LabelType()), instrs=[Invoke(result=Value(val='<badref>', ty=VoidType()), callee=Value(val='decl', ty=FunctionType(param_tys=[], ret_ty=VoidType())), args=[], label_ok=Value(val='via.cleanup', ty=LabelType()), label_err=Value(val='exn.dispatch', ty=LabelType()), calling_conv=<CallingConv.C: 0>, call_attrs=[])], pred_blocks=[]), 'via.cleanup': Block(value=Value(val='via.cleanup', ty=LabelType()), instrs=[Invoke(result=Value(val='<badref>', ty=VoidType()), callee=Value(val='decl', ty=FunctionType(param_tys=[], ret_ty=VoidType())), args=[], label_ok=Value(val='via.catchswitch', ty=LabelType()), label_err=Value(val='cleanup.inner', ty=LabelType()), calling_conv=<CallingConv.C: 0>, call_attrs=[])], pred_blocks=['entry']), 'cleanup.inner': Block(value=Value(val='cleanup.inner', ty=LabelType()), instrs=[CleanupPad(result=Value(val='cp.inner', ty=TokenType()), parent=Value(val='none', ty=TokenType()), args=[]), CleanupRet(cleanup=Value(val='cp.inner', ty=TokenType()), succ_label=Value(val='exn.dispatch', ty=LabelType()))], pred_blocks=['via.cleanup']), 'via.catchswitch': Block(value=Value(val='via.catchswitch', ty=LabelType()), instrs=[Invoke(result=Value(val='<badref>', ty=VoidType()), callee=Value(val='decl', ty=FunctionType(param_tys=[], ret_ty=VoidType())), args=[], label_ok=Value(val='exit', ty=LabelType()), label_err=Value(val='dispatch.inner', ty=LabelType()), calling_conv=<CallingConv.C: 0>, call_attrs=[])], pred_blocks=['via.cleanup']), 'dispatch.inner': Block(value=Value(val='dispatch.inner', ty=LabelType()), instrs=[CatchSwitch(result=Value(val='cs.inner', ty=TokenType()), parent=Value(val='none', ty=TokenType()), handler_labels=[Value(val='pad.inner', ty=LabelType())], label_default=Value(val='exn.dispatch', ty=LabelType()))], pred_blocks=['via.catchswitch']), 'pad.inner': Block(value=Value(val='pad.inner', ty=LabelType()), instrs=[CatchPad(result=Value(val='catch.inner', ty=TokenType()), catchswith=Value(val='cs.inner', ty=TokenType()), args=[Value(val=0, ty=IntegerType(num_bits=32))]), CatchRet(catch=Value(val='catch.inner', ty=TokenType()), succ_label=Value(val='exit', ty=LabelType()))], pred_blocks=['dispatch.inner']), 'exn.dispatch': Block(value=Value(val='exn.dispatch', ty=LabelType()), instrs=[CatchSwitch(result=Value(val='cs', ty=TokenType()), parent=Value(val='none', ty=TokenType()), handler_labels=[Value(val='pad1', ty=LabelType()), Value(val='pad2', ty=LabelType())], label_default=Value(val='cleanup', ty=LabelType()))], pred_blocks=['dispatch.inner', 'cleanup.inner', 'entry']), 'pad1': Block(value=Value(val='pad1', ty=LabelType()), instrs=[CatchPad(result=Value(val='%0', ty=TokenType()), catchswith=Value(val='cs', ty=TokenType()), args=[Value(val=1, ty=IntegerType(num_bits=32))]), Unreacheble], pred_blocks=['exn.dispatch']), 'pad2': Block(value=Value(val='pad2', ty=LabelType()), instrs=[CatchPad(result=Value(val='%1', ty=TokenType()), catchswith=Value(val='cs', ty=TokenType()), args=[Value(val=2, ty=IntegerType(num_bits=32))]), Unreacheble], pred_blocks=['exn.dispatch']), 'cleanup': Block(value=Value(val='cleanup', ty=LabelType()), instrs=[CleanupPad(result=Value(val='cp', ty=TokenType()), parent=Value(val='none', ty=TokenType()), args=[]), CleanupRet(cleanup=Value(val='cp', ty=TokenType()), succ_label=None)], pred_blocks=['exn.dispatch']), 'exit': Block(value=Value(val='exit', ty=LabelType()), instrs=[Ret(value=None)], pred_blocks=['pad.inner', 'via.catchswitch'])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'test_intrinsics': Function(value=Value(val='test_intrinsics', ty=FunctionType(param_tys=[], ret_ty=VoidType())), args=[], blocks={'entry': Block(value=Value(val='entry', ty=LabelType()), instrs=[Call(result=Value(val='sp', ty=PtrType(addr_space=0, ty=None)), callee=Value(val='llvm.stacksave.p0', ty=FunctionType(param_tys=[], ret_ty=PtrType(addr_space=0, ty=None))), args=[], calling_conv=<CallingConv.C: 0>, call_attrs=[], tail_kind=None, fast_math_flags=frozenset()), Alloca(result=Value(val='x', ty=PtrType(addr_space=0, ty=None)), allocated_ty=IntegerType(num_bits=32), num_elements=Value(val=1, ty=IntegerType(num_bits=32)), align=4, is_inalloca=False), Conversion(opcode='bitcast', result=Value(val='%0', ty=PtrType(addr_space=0, ty=None)), value=Value(val='x', ty=PtrType(addr_space=0, ty=None)), fast_math_flags=frozenset(), is_nuw=False, is_nsw=False), Call(result=Value(val='<badref>', ty=VoidType()), callee=Value(val='llvm.lifetime.start.p0', ty=FunctionType(param_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], ret_ty=VoidType())), args=[Value(val=4, ty=IntegerType(num_bits=64)), Value(val='%0', ty=PtrType(addr_space=0, ty=None))], calling_conv=<CallingConv.C: 0>, call_attrs=[], tail_kind=None, fast_math_flags=frozenset()), Call(result=Value(val='<badref>', ty=VoidType()), callee=Value(val='llvm.lifetime.end.p0', ty=FunctionType(param_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], ret_ty=VoidType())), args=[Value(val=4, ty=IntegerType(num_bits=64)), Value(val='%0', ty=PtrType(addr_space=0, ty=None))], calling_conv=<CallingConv.C: 0>, call_attrs=[], tail_kind=None, fast_math_flags=frozenset()), Call(result=Value(val='<badref>', ty=VoidType()), callee=Value(val='llvm.stackrestore.p0', ty=FunctionType(param_tys=[PtrType(addr_space=0, ty=None)], ret_ty=VoidType())), args=[Value(val='sp', ty=PtrType(addr_space=0, ty=None))], calling_conv=<CallingConv.C: 0>, call_attrs=[], tail_kind=None, fast_math_flags=frozenset()), Ret(value=None)], pred_blocks=[])}, attrs=[], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'llvm.stacksave.p0': Function(value=Value(val='llvm.stacksave.p0', ty=FunctionType(param_tys=[], ret_ty=PtrType(addr_space=0, ty=None))), args=[], blocks={}, attrs=[{'nocallback': (), 'nofree': (), 'nosync': (), 'nounwind': (), 'willreturn': ()}], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'llvm.stackrestore.p0': Function(value=Value(val='llvm.stackrestore.p0', ty=FunctionType(param_tys=[PtrType(addr_space=0, ty=None)], ret_ty=VoidType())), args=[Value(val='%0', ty=PtrType(addr_space=0, ty=None))], blocks={}, attrs=[{'nocallback': (), 'nofree': (), 'nosync': (), 'nounwind': (), 'willreturn': ()}], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'llvm.lifetime.start.p0': Function(value=Value(val='llvm.lifetime.start.p0', ty=FunctionType(param_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], ret_ty=VoidType())), args=[Value(val='%0', ty=IntegerType(num_bits=64)), Value(val='%1', ty=PtrType(addr_space=0, ty=None))], blocks={}, attrs=[{'nocallback': (), 'nofree': (), 'nosync': (), 'nounwind': (), 'willreturn': (), 'memory': 3}, {}, {'immarg': ()}, {'nocapture': ()}], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None)), 'llvm.lifetime.end.p0': Function(value=Value(val='llvm.lifetime.end.p0', ty=FunctionType(param_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], ret_ty=VoidType())), args=[Value(val='%0', ty=IntegerType(num_bits=64)), Value(val='%1', ty=PtrType(addr_space=0, ty=None))], blocks={}, attrs=[{'nocallback': (), 'nofree': (), 'nosync': (), 'nounwind': (), 'willreturn': (), 'memory': 3}, {}, {'immarg': ()}, {'nocapture': ()}], calling_convention=<CallingConv.C: 0>, is_vararg=False, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None))}, global_vars={'var': GlobalVariable(value=Value(val='var', ty=IntegerType(num_bits=32)), initializer=Value(val=42, ty=IntegerType(num_bits=32)), is_const=False, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False), 'ext': GlobalVariable(value=Value(val='ext', ty=PtrType(addr_space=0, ty=None)), initializer=None, is_const=False, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False), 'cst': GlobalVariable(value=Value(val='cst', ty=StructureType(name='S', elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)), initializer=Value(val=[Value(val=1, ty=IntegerType(num_bits=64)), Value(val='cst', ty=StructureType(name='S', elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False))], ty=StructureType(name='S', elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)), is_const=True, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False), 'tl': GlobalVariable(value=Value(val='tl', ty=StructureType(name=None, elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)), initializer=Value(val=[Value(val=1, ty=IntegerType(num_bits=64)), Value(val='cst', ty=StructureType(name='S', elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False))], ty=StructureType(name=None, elem_tys=[IntegerType(num_bits=64), PtrType(addr_space=0, ty=None)], is_packed=False)), is_const=False, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.GeneralDynamicTLSModel: 1>, section=None), is_externally_initialized=False), 'arr': GlobalVariable(value=Value(val='arr', ty=ArrayType(elem_count=5, elem_ty=IntegerType(num_bits=8))), initializer=Value(val=b'\\x02\\x03\\x05\\x07\\x0b', ty=ArrayType(elem_count=5, elem_ty=IntegerType(num_bits=8))), is_const=False, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.LinkOnceODRLinkage: 3>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False), 'str': GlobalVariable(value=Value(val='str', ty=ArrayType(elem_count=13, elem_ty=IntegerType(num_bits=8))), initializer=Value(val=b'hello world\\n\\x00', ty=ArrayType(elem_count=13, elem_ty=IntegerType(num_bits=8))), is_const=True, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.PrivateLinkage: 8>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Global: 2>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False), 'locStr': GlobalVariable(value=Value(val='locStr', ty=ArrayType(elem_count=13, elem_ty=IntegerType(num_bits=8))), initializer=Value(val=b'hello world\\n\\x00', ty=ArrayType(elem_count=13, elem_ty=IntegerType(num_bits=8))), is_const=True, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.PrivateLinkage: 8>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Local: 1>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False), 'hidden': GlobalVariable(value=Value(val='hidden', ty=IntegerType(num_bits=32)), initializer=Value(val=7, ty=IntegerType(num_bits=32)), is_const=False, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.HiddenVisibility: 1>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False), 'protected': GlobalVariable(value=Value(val='protected', ty=IntegerType(num_bits=32)), initializer=Value(val=23, ty=IntegerType(num_bits=32)), is_const=False, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.ProtectedVisibility: 2>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False), 'section': GlobalVariable(value=Value(val='section', ty=IntegerType(num_bits=32)), initializer=Value(val=27, ty=IntegerType(num_bits=32)), is_const=False, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section='.custom'), is_externally_initialized=False), 'align': GlobalVariable(value=Value(val='align', ty=IntegerType(num_bits=32)), initializer=Value(val=31, ty=IntegerType(num_bits=32)), is_const=False, attrs={}, global_object=GlobalObject(addr_space=0, align=4, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False), 'nullptr': GlobalVariable(value=Value(val='nullptr', ty=PtrType(addr_space=0, ty=None)), initializer=Value(val=None, ty=PtrType(addr_space=0, ty=None)), is_const=False, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False), 'const_gep': GlobalVariable(value=Value(val='const_gep', ty=PtrType(addr_space=0, ty=None)), initializer=Value(val=GetElementPtr(result=Value(val='<badref>', ty=PtrType(addr_space=0, ty=None)), source_ty=IntegerType(num_bits=32), base_addr=Value(val='var', ty=IntegerType(num_bits=32)), indices=[Value(val=2, ty=IntegerType(num_bits=64))], dest_ty=IntegerType(num_bits=32), is_inbounds=False), ty=PtrType(addr_space=0, ty=None)), is_const=False, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False), 'const_inbounds_gep': GlobalVariable(value=Value(val='const_inbounds_gep', ty=PtrType(addr_space=0, ty=None)), initializer=Value(val=GetElementPtr(result=Value(val='<badref>', ty=PtrType(addr_space=0, ty=None)), source_ty=IntegerType(num_bits=32), base_addr=Value(val='var', ty=IntegerType(num_bits=32)), indices=[Value(val=1, ty=IntegerType(num_bits=64))], dest_ty=IntegerType(num_bits=32), is_inbounds=True), ty=PtrType(addr_space=0, ty=None)), is_const=False, attrs={}, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>, thread_local=<ThreadLocal.NotThreadLocal: 0>, section=None), is_externally_initialized=False)})"""

mod = llvm2py.parse_assembly(src)

dumped = str(mod)
dumped = re.sub(r"frozenset\([^)]+\)", "frozenset", dumped)
dumped = re.sub(r"<llvm2py\.ir\.instruction\.Unreacheble[^>]+\>", "Unreacheble", dumped)

assert dumped == reference, "Error, IR dump is different from original"
