# FastAPI App

Generated by `pd init fastapi`.

## Structure

- `/app` contains the main application code.
- `/static` serves static css, js, and images.
- `/templates` contains Jinja2 templates.

```bash
|-- app/
    |-- apis/ # Third-party APIs (e.g. OpenAI)
        |-- api.py
    |-- model/ # Data models (e.g. Pydantic)
        |-- model.py
    |-- routers/ # Application routes (uses FastAPI Router)
        |-- home.py
    |-- main.py # FastAPI Entry Point
|-- static/ # Static files
    |-- css/
        |-- index.css
        |-- main.css # Generated by Tailwind CSS
    |-- fonts/
        |-- Rosario-Regular.ttf
    |-- img/
        |-- pd.png
    |-- js/ # Generated by TypeScript
        |-- index.js
    |-- ts/
        |-- index.ts
    |-- favicon.ico
    |-- logo192.png
    |-- logo512.png
    |-- manifest.json
    |-- robots.txt
|-- styles/ # Tailwind CSS styles
    |-- main.css
|-- templates/
    |-- head.html
    |-- index.html # HTML Entry point
    |-- logo.html
|-- .gitignore
|-- package.json # Node.js dependencies
|-- README.md # This file
|-- requirements.txt # FastAPI App dependencies
|-- tailwind.config.js # Tailwind CSS configuration
|-- tsconfig.json # TypeScript configuration
```

## Install

In the root directory of the project, run:

```bash
pip install -r requirements.txt
npm install
```

## Run

In the root directory of the project, run:

```bash
python3 -m uvicorn app.main:app --reload
```

## Develop

If you are going to make changes to the Tailwind CSS styles, run:

```bash
npm run watch-tw
```

If you are going to make changes to the TypeScript code, run:

```bash
npm run watch-ts
```

## Learn More

To learn FastAPI, check out the [FastAPI documentation](https://fastapi.tiangolo.com/).